/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.accessibilityservice;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.support.annotation.RequiresApi;

public final class AccessibilityServiceInfoCompat {
    private static final AccessibilityServiceInfoBaseImpl IMPL = Build.VERSION.SDK_INT >= 18 ? new AccessibilityServiceInfoApi18Impl() : (Build.VERSION.SDK_INT >= 16 ? new AccessibilityServiceInfoApi16Impl() : new AccessibilityServiceInfoBaseImpl());
    public static final int CAPABILITY_CAN_RETRIEVE_WINDOW_CONTENT = 1;
    public static final int CAPABILITY_CAN_REQUEST_TOUCH_EXPLORATION = 2;
    public static final int CAPABILITY_CAN_REQUEST_ENHANCED_WEB_ACCESSIBILITY = 4;
    public static final int CAPABILITY_CAN_FILTER_KEY_EVENTS = 8;
    public static final int FEEDBACK_BRAILLE = 32;
    public static final int FEEDBACK_ALL_MASK = -1;
    @Deprecated
    public static final int DEFAULT = 1;
    public static final int FLAG_INCLUDE_NOT_IMPORTANT_VIEWS = 2;
    public static final int FLAG_REQUEST_TOUCH_EXPLORATION_MODE = 4;
    public static final int FLAG_REQUEST_ENHANCED_WEB_ACCESSIBILITY = 8;
    public static final int FLAG_REPORT_VIEW_IDS = 16;
    public static final int FLAG_REQUEST_FILTER_KEY_EVENTS = 32;

    private AccessibilityServiceInfoCompat() {
    }

    @Deprecated
    public static String getId(AccessibilityServiceInfo info) {
        return info.getId();
    }

    @Deprecated
    public static ResolveInfo getResolveInfo(AccessibilityServiceInfo info) {
        return info.getResolveInfo();
    }

    @Deprecated
    public static String getSettingsActivityName(AccessibilityServiceInfo info) {
        return info.getSettingsActivityName();
    }

    @Deprecated
    public static boolean getCanRetrieveWindowContent(AccessibilityServiceInfo info) {
        return info.getCanRetrieveWindowContent();
    }

    @Deprecated
    public static String getDescription(AccessibilityServiceInfo info) {
        return info.getDescription();
    }

    public static String loadDescription(AccessibilityServiceInfo info, PackageManager packageManager) {
        return IMPL.loadDescription(info, packageManager);
    }

    public static String feedbackTypeToString(int feedbackType) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        while (feedbackType > 0) {
            int feedbackTypeFlag = 1 << Integer.numberOfTrailingZeros(feedbackType);
            feedbackType &= ~feedbackTypeFlag;
            if (builder.length() > 1) {
                builder.append(", ");
            }
            switch (feedbackTypeFlag) {
                case 4: {
                    builder.append("FEEDBACK_AUDIBLE");
                    break;
                }
                case 2: {
                    builder.append("FEEDBACK_HAPTIC");
                    break;
                }
                case 16: {
                    builder.append("FEEDBACK_GENERIC");
                    break;
                }
                case 1: {
                    builder.append("FEEDBACK_SPOKEN");
                    break;
                }
                case 8: {
                    builder.append("FEEDBACK_VISUAL");
                }
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static String flagToString(int flag) {
        switch (flag) {
            case 1: {
                return "DEFAULT";
            }
            case 2: {
                return "FLAG_INCLUDE_NOT_IMPORTANT_VIEWS";
            }
            case 4: {
                return "FLAG_REQUEST_TOUCH_EXPLORATION_MODE";
            }
            case 8: {
                return "FLAG_REQUEST_ENHANCED_WEB_ACCESSIBILITY";
            }
            case 16: {
                return "FLAG_REPORT_VIEW_IDS";
            }
            case 32: {
                return "FLAG_REQUEST_FILTER_KEY_EVENTS";
            }
        }
        return null;
    }

    public static int getCapabilities(AccessibilityServiceInfo info) {
        return IMPL.getCapabilities(info);
    }

    public static String capabilityToString(int capability) {
        switch (capability) {
            case 1: {
                return "CAPABILITY_CAN_RETRIEVE_WINDOW_CONTENT";
            }
            case 2: {
                return "CAPABILITY_CAN_REQUEST_TOUCH_EXPLORATION";
            }
            case 4: {
                return "CAPABILITY_CAN_REQUEST_ENHANCED_WEB_ACCESSIBILITY";
            }
            case 8: {
                return "CAPABILITY_CAN_FILTER_KEY_EVENTS";
            }
        }
        return "UNKNOWN";
    }

    @RequiresApi(value=18)
    static class AccessibilityServiceInfoApi18Impl
    extends AccessibilityServiceInfoApi16Impl {
        AccessibilityServiceInfoApi18Impl() {
        }

        @Override
        public int getCapabilities(AccessibilityServiceInfo info) {
            return info.getCapabilities();
        }
    }

    @RequiresApi(value=16)
    static class AccessibilityServiceInfoApi16Impl
    extends AccessibilityServiceInfoBaseImpl {
        AccessibilityServiceInfoApi16Impl() {
        }

        @Override
        public String loadDescription(AccessibilityServiceInfo info, PackageManager pm) {
            return info.loadDescription(pm);
        }
    }

    static class AccessibilityServiceInfoBaseImpl {
        AccessibilityServiceInfoBaseImpl() {
        }

        public int getCapabilities(AccessibilityServiceInfo info) {
            if (AccessibilityServiceInfoCompat.getCanRetrieveWindowContent(info)) {
                return 1;
            }
            return 0;
        }

        public String loadDescription(AccessibilityServiceInfo info, PackageManager pm) {
            return null;
        }
    }
}

