/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.provider;

import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Handler;
import android.provider.BaseColumns;
import android.support.annotation.GuardedBy;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.res.FontResourcesParserCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.graphics.TypefaceCompat;
import android.support.v4.graphics.TypefaceCompatUtil;
import android.support.v4.provider.FontRequest;
import android.support.v4.provider.SelfDestructiveThread;
import android.support.v4.util.LruCache;
import android.support.v4.util.Preconditions;
import android.support.v4.util.SimpleArrayMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class FontsContractCompat {
    private static final String TAG = "FontsContractCompat";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String PARCEL_FONT_RESULTS = "font_results";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static final int RESULT_CODE_PROVIDER_NOT_FOUND = -1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static final int RESULT_CODE_WRONG_CERTIFICATES = -2;
    private static final LruCache<String, Typeface> sTypefaceCache = new LruCache(16);
    private static final int BACKGROUND_THREAD_KEEP_ALIVE_DURATION_MS = 10000;
    private static final SelfDestructiveThread sBackgroundThread = new SelfDestructiveThread("fonts", 10, 10000);
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static final SimpleArrayMap<String, ArrayList<SelfDestructiveThread.ReplyCallback<TypefaceResult>>> sPendingReplies = new SimpleArrayMap();
    private static final Comparator<byte[]> sByteArrayComparator = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] l, byte[] r) {
            if (l.length != r.length) {
                return l.length - r.length;
            }
            for (int i = 0; i < l.length; ++i) {
                if (l[i] == r[i]) continue;
                return l[i] - r[i];
            }
            return 0;
        }
    };

    private FontsContractCompat() {
    }

    @NonNull
    private static TypefaceResult getFontInternal(Context context, FontRequest request, int style) {
        FontFamilyResult result;
        try {
            result = FontsContractCompat.fetchFonts(context, null, request);
        }
        catch (PackageManager.NameNotFoundException e) {
            return new TypefaceResult(null, -1);
        }
        if (result.getStatusCode() == 0) {
            Typeface typeface;
            return new TypefaceResult(typeface, (typeface = TypefaceCompat.createFromFontInfo(context, null, result.getFonts(), style)) != null ? 0 : -3);
        }
        int resultCode = result.getStatusCode() == 1 ? -2 : -3;
        return new TypefaceResult(null, resultCode);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void resetCache() {
        sTypefaceCache.evictAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Typeface getFontSync(final Context context, final FontRequest request, final @Nullable ResourcesCompat.FontCallback fontCallback, final @Nullable Handler handler, boolean isBlockingFetch, int timeout, final int style) {
        final String id2 = request.getIdentifier() + "-" + style;
        Typeface cached = sTypefaceCache.get(id2);
        if (cached != null) {
            if (fontCallback != null) {
                fontCallback.onFontRetrieved(cached);
            }
            return cached;
        }
        if (isBlockingFetch && timeout == -1) {
            TypefaceResult typefaceResult = FontsContractCompat.getFontInternal(context, request, style);
            if (fontCallback != null) {
                if (typefaceResult.mResult == 0) {
                    fontCallback.callbackSuccessAsync(typefaceResult.mTypeface, handler);
                } else {
                    fontCallback.callbackFailAsync(typefaceResult.mResult, handler);
                }
            }
            return typefaceResult.mTypeface;
        }
        Callable<TypefaceResult> fetcher = new Callable<TypefaceResult>(){

            @Override
            public TypefaceResult call() throws Exception {
                TypefaceResult typeface = FontsContractCompat.getFontInternal(context, request, style);
                if (typeface.mTypeface != null) {
                    sTypefaceCache.put(id2, typeface.mTypeface);
                }
                return typeface;
            }
        };
        if (isBlockingFetch) {
            try {
                return FontsContractCompat.sBackgroundThread.postAndWait(fetcher, (int)timeout).mTypeface;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        SelfDestructiveThread.ReplyCallback<TypefaceResult> reply = fontCallback == null ? null : new SelfDestructiveThread.ReplyCallback<TypefaceResult>(){

            @Override
            public void onReply(TypefaceResult typeface) {
                if (typeface == null) {
                    fontCallback.callbackFailAsync(1, handler);
                } else if (typeface.mResult == 0) {
                    fontCallback.callbackSuccessAsync(typeface.mTypeface, handler);
                } else {
                    fontCallback.callbackFailAsync(typeface.mResult, handler);
                }
            }
        };
        Object object = sLock;
        synchronized (object) {
            if (sPendingReplies.containsKey(id2)) {
                if (reply != null) {
                    sPendingReplies.get(id2).add(reply);
                }
                return null;
            }
            if (reply != null) {
                ArrayList<2> pendingReplies = new ArrayList<2>();
                pendingReplies.add(reply);
                sPendingReplies.put(id2, pendingReplies);
            }
        }
        sBackgroundThread.postAndReply(fetcher, new SelfDestructiveThread.ReplyCallback<TypefaceResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReply(TypefaceResult typeface) {
                ArrayList replies;
                Object object = sLock;
                synchronized (object) {
                    replies = (ArrayList)sPendingReplies.get(id2);
                    if (replies == null) {
                        return;
                    }
                    sPendingReplies.remove(id2);
                }
                for (int i = 0; i < replies.size(); ++i) {
                    ((SelfDestructiveThread.ReplyCallback)replies.get(i)).onReply(typeface);
                }
            }
        });
        return null;
    }

    public static void requestFont(final @NonNull Context context, final @NonNull FontRequest request, final @NonNull FontRequestCallback callback, @NonNull Handler handler) {
        final Handler callerThreadHandler = new Handler();
        handler.post(new Runnable(){

            @Override
            public void run() {
                FontFamilyResult result;
                try {
                    result = FontsContractCompat.fetchFonts(context, null, request);
                }
                catch (PackageManager.NameNotFoundException e) {
                    callerThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTypefaceRequestFailed(-1);
                        }
                    });
                    return;
                }
                if (result.getStatusCode() != 0) {
                    switch (result.getStatusCode()) {
                        case 1: {
                            callerThreadHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onTypefaceRequestFailed(-2);
                                }
                            });
                            return;
                        }
                        case 2: {
                            callerThreadHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onTypefaceRequestFailed(-3);
                                }
                            });
                            return;
                        }
                    }
                    callerThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTypefaceRequestFailed(-3);
                        }
                    });
                    return;
                }
                FontInfo[] fonts = result.getFonts();
                if (fonts == null || fonts.length == 0) {
                    callerThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTypefaceRequestFailed(1);
                        }
                    });
                    return;
                }
                for (FontInfo font : fonts) {
                    if (font.getResultCode() == 0) continue;
                    final int resultCode = font.getResultCode();
                    if (resultCode < 0) {
                        callerThreadHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onTypefaceRequestFailed(-3);
                            }
                        });
                    } else {
                        callerThreadHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onTypefaceRequestFailed(resultCode);
                            }
                        });
                    }
                    return;
                }
                final Typeface typeface = FontsContractCompat.buildTypeface(context, null, fonts);
                if (typeface == null) {
                    callerThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTypefaceRequestFailed(-3);
                        }
                    });
                    return;
                }
                callerThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onTypefaceRetrieved(typeface);
                    }
                });
            }
        });
    }

    @Nullable
    public static Typeface buildTypeface(@NonNull Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontInfo[] fonts) {
        return TypefaceCompat.createFromFontInfo(context, cancellationSignal, fonts, 0);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=19)
    public static Map<Uri, ByteBuffer> prepareFontData(Context context, FontInfo[] fonts, CancellationSignal cancellationSignal) {
        HashMap<Uri, ByteBuffer> out = new HashMap<Uri, ByteBuffer>();
        for (FontInfo font : fonts) {
            Uri uri;
            if (font.getResultCode() != 0 || out.containsKey(uri = font.getUri())) continue;
            ByteBuffer buffer = TypefaceCompatUtil.mmap(context, cancellationSignal, uri);
            out.put(uri, buffer);
        }
        return Collections.unmodifiableMap(out);
    }

    @NonNull
    public static FontFamilyResult fetchFonts(@NonNull Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontRequest request) throws PackageManager.NameNotFoundException {
        ProviderInfo providerInfo = FontsContractCompat.getProvider(context.getPackageManager(), request, context.getResources());
        if (providerInfo == null) {
            return new FontFamilyResult(1, null);
        }
        FontInfo[] fonts = FontsContractCompat.getFontFromProvider(context, request, providerInfo.authority, cancellationSignal);
        return new FontFamilyResult(0, fonts);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static ProviderInfo getProvider(@NonNull PackageManager packageManager, @NonNull FontRequest request, @Nullable Resources resources) throws PackageManager.NameNotFoundException {
        String providerAuthority = request.getProviderAuthority();
        ProviderInfo info = packageManager.resolveContentProvider(providerAuthority, 0);
        if (info == null) {
            throw new PackageManager.NameNotFoundException("No package found for authority: " + providerAuthority);
        }
        if (!info.packageName.equals(request.getProviderPackage())) {
            throw new PackageManager.NameNotFoundException("Found content provider " + providerAuthority + ", but package was not " + request.getProviderPackage());
        }
        PackageInfo packageInfo = packageManager.getPackageInfo(info.packageName, 64);
        List<byte[]> signatures = FontsContractCompat.convertToByteArrayList(packageInfo.signatures);
        Collections.sort(signatures, sByteArrayComparator);
        List<List<byte[]>> requestCertificatesList = FontsContractCompat.getCertificates(request, resources);
        for (int i = 0; i < requestCertificatesList.size(); ++i) {
            ArrayList<byte[]> requestSignatures = new ArrayList<byte[]>((Collection)requestCertificatesList.get(i));
            Collections.sort(requestSignatures, sByteArrayComparator);
            if (!FontsContractCompat.equalsByteArrayList(signatures, requestSignatures)) continue;
            return info;
        }
        return null;
    }

    private static List<List<byte[]>> getCertificates(FontRequest request, Resources resources) {
        if (request.getCertificates() != null) {
            return request.getCertificates();
        }
        int resourceId = request.getCertificatesArrayResId();
        return FontResourcesParserCompat.readCerts(resources, resourceId);
    }

    private static boolean equalsByteArrayList(List<byte[]> signatures, List<byte[]> requestSignatures) {
        if (signatures.size() != requestSignatures.size()) {
            return false;
        }
        for (int i = 0; i < signatures.size(); ++i) {
            if (Arrays.equals(signatures.get(i), requestSignatures.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<byte[]> convertToByteArrayList(Signature[] signatures) {
        ArrayList<byte[]> shas = new ArrayList<byte[]>();
        for (int i = 0; i < signatures.length; ++i) {
            shas.add(signatures[i].toByteArray());
        }
        return shas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    static FontInfo[] getFontFromProvider(Context context, FontRequest request, String authority, CancellationSignal cancellationSignal) {
        ArrayList<FontInfo> result = new ArrayList<FontInfo>();
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        Uri fileBaseUri = new Uri.Builder().scheme("content").authority(authority).appendPath("file").build();
        try (Cursor cursor = null;){
            cursor = Build.VERSION.SDK_INT > 16 ? context.getContentResolver().query(uri, new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"}, "query = ?", new String[]{request.getQuery()}, null, cancellationSignal) : context.getContentResolver().query(uri, new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"}, "query = ?", new String[]{request.getQuery()}, null);
            if (cursor != null && cursor.getCount() > 0) {
                int resultCodeColumnIndex = cursor.getColumnIndex("result_code");
                result = new ArrayList();
                int idColumnIndex = cursor.getColumnIndex("_id");
                int fileIdColumnIndex = cursor.getColumnIndex("file_id");
                int ttcIndexColumnIndex = cursor.getColumnIndex("font_ttc_index");
                int weightColumnIndex = cursor.getColumnIndex("font_weight");
                int italicColumnIndex = cursor.getColumnIndex("font_italic");
                while (cursor.moveToNext()) {
                    Uri fileUri;
                    long id2;
                    int ttcIndex;
                    int resultCode = resultCodeColumnIndex != -1 ? cursor.getInt(resultCodeColumnIndex) : 0;
                    int n = ttcIndex = ttcIndexColumnIndex != -1 ? cursor.getInt(ttcIndexColumnIndex) : 0;
                    if (fileIdColumnIndex == -1) {
                        id2 = cursor.getLong(idColumnIndex);
                        fileUri = ContentUris.withAppendedId((Uri)uri, (long)id2);
                    } else {
                        id2 = cursor.getLong(fileIdColumnIndex);
                        fileUri = ContentUris.withAppendedId((Uri)fileBaseUri, (long)id2);
                    }
                    int weight = weightColumnIndex != -1 ? cursor.getInt(weightColumnIndex) : 400;
                    boolean italic = italicColumnIndex != -1 && cursor.getInt(italicColumnIndex) == 1;
                    result.add(new FontInfo(fileUri, ttcIndex, weight, italic, resultCode));
                }
            }
        }
        return result.toArray(new FontInfo[0]);
    }

    public static class FontRequestCallback {
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static final int RESULT_OK = 0;
        public static final int FAIL_REASON_PROVIDER_NOT_FOUND = -1;
        public static final int FAIL_REASON_WRONG_CERTIFICATES = -2;
        public static final int FAIL_REASON_FONT_LOAD_ERROR = -3;
        public static final int FAIL_REASON_SECURITY_VIOLATION = -4;
        public static final int FAIL_REASON_FONT_NOT_FOUND = 1;
        public static final int FAIL_REASON_FONT_UNAVAILABLE = 2;
        public static final int FAIL_REASON_MALFORMED_QUERY = 3;

        public void onTypefaceRetrieved(Typeface typeface) {
        }

        public void onTypefaceRequestFailed(int reason) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface FontRequestFailReason {
        }
    }

    public static class FontFamilyResult {
        public static final int STATUS_OK = 0;
        public static final int STATUS_WRONG_CERTIFICATES = 1;
        public static final int STATUS_UNEXPECTED_DATA_PROVIDED = 2;
        private final int mStatusCode;
        private final FontInfo[] mFonts;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public FontFamilyResult(int statusCode, @Nullable FontInfo[] fonts) {
            this.mStatusCode = statusCode;
            this.mFonts = fonts;
        }

        public int getStatusCode() {
            return this.mStatusCode;
        }

        public FontInfo[] getFonts() {
            return this.mFonts;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        static @interface FontResultStatus {
        }
    }

    public static class FontInfo {
        private final Uri mUri;
        private final int mTtcIndex;
        private final int mWeight;
        private final boolean mItalic;
        private final int mResultCode;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public FontInfo(@NonNull Uri uri, @IntRange(from=0L) int ttcIndex, @IntRange(from=1L, to=1000L) int weight, boolean italic, int resultCode) {
            this.mUri = Preconditions.checkNotNull(uri);
            this.mTtcIndex = ttcIndex;
            this.mWeight = weight;
            this.mItalic = italic;
            this.mResultCode = resultCode;
        }

        @NonNull
        public Uri getUri() {
            return this.mUri;
        }

        @IntRange(from=0L)
        public int getTtcIndex() {
            return this.mTtcIndex;
        }

        @IntRange(from=1L, to=1000L)
        public int getWeight() {
            return this.mWeight;
        }

        public boolean isItalic() {
            return this.mItalic;
        }

        public int getResultCode() {
            return this.mResultCode;
        }
    }

    private static final class TypefaceResult {
        final Typeface mTypeface;
        final int mResult;

        TypefaceResult(@Nullable Typeface typeface, int result) {
            this.mTypeface = typeface;
            this.mResult = result;
        }
    }

    public static final class Columns
    implements BaseColumns {
        public static final String FILE_ID = "file_id";
        public static final String TTC_INDEX = "font_ttc_index";
        public static final String VARIATION_SETTINGS = "font_variation_settings";
        public static final String WEIGHT = "font_weight";
        public static final String ITALIC = "font_italic";
        public static final String RESULT_CODE = "result_code";
        public static final int RESULT_CODE_OK = 0;
        public static final int RESULT_CODE_FONT_NOT_FOUND = 1;
        public static final int RESULT_CODE_FONT_UNAVAILABLE = 2;
        public static final int RESULT_CODE_MALFORMED_QUERY = 3;
    }
}

