/*
 * Decompiled with CFR 0.152.
 */
package android.support.v13.view;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.view.DragAndDropPermissions;
import android.view.DragEvent;

public final class DragAndDropPermissionsCompat {
    private static DragAndDropPermissionsCompatImpl IMPL = Build.VERSION.SDK_INT >= 24 ? new Api24DragAndDropPermissionsCompatImpl() : new BaseDragAndDropPermissionsCompatImpl();
    private Object mDragAndDropPermissions;

    private DragAndDropPermissionsCompat(Object dragAndDropPermissions) {
        this.mDragAndDropPermissions = dragAndDropPermissions;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static DragAndDropPermissionsCompat request(Activity activity, DragEvent dragEvent) {
        Object dragAndDropPermissions = IMPL.request(activity, dragEvent);
        if (dragAndDropPermissions != null) {
            return new DragAndDropPermissionsCompat(dragAndDropPermissions);
        }
        return null;
    }

    public void release() {
        IMPL.release(this.mDragAndDropPermissions);
    }

    @RequiresApi(value=24)
    static class Api24DragAndDropPermissionsCompatImpl
    extends BaseDragAndDropPermissionsCompatImpl {
        Api24DragAndDropPermissionsCompatImpl() {
        }

        @Override
        public Object request(Activity activity, DragEvent dragEvent) {
            return activity.requestDragAndDropPermissions(dragEvent);
        }

        @Override
        public void release(Object dragAndDropPermissions) {
            ((DragAndDropPermissions)dragAndDropPermissions).release();
        }
    }

    static class BaseDragAndDropPermissionsCompatImpl
    implements DragAndDropPermissionsCompatImpl {
        BaseDragAndDropPermissionsCompatImpl() {
        }

        @Override
        public Object request(Activity activity, DragEvent dragEvent) {
            return null;
        }

        @Override
        public void release(Object dragAndDropPermissions) {
        }
    }

    static interface DragAndDropPermissionsCompatImpl {
        public Object request(Activity var1, DragEvent var2);

        public void release(Object var1);
    }
}

