/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.test.InstrumentationRegistry;
import android.support.test.annotation.Beta;
import android.support.test.internal.util.Checks;
import android.util.Log;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Beta
public class ServiceTestRule
implements TestRule {
    private static final String TAG = "ServiceTestRule";
    private static final long DEFAULT_TIMEOUT = 5L;
    private IBinder mBinder;
    private Intent mServiceIntent;
    private ServiceConnection mServiceConn;
    private long mTimeout;
    private TimeUnit mTimeUnit;
    boolean mServiceStarted = false;
    boolean mServiceBound = false;

    public ServiceTestRule() {
        this(5L, TimeUnit.SECONDS);
    }

    public static ServiceTestRule withTimeout(long timeout, TimeUnit timeUnit) {
        return new ServiceTestRule(timeout, timeUnit);
    }

    private ServiceTestRule(long timeout, TimeUnit timeUnit) {
        this.mTimeout = timeout;
        this.mTimeUnit = timeUnit;
    }

    public void startService(@NonNull Intent intent) throws TimeoutException {
        this.mServiceIntent = (Intent)Checks.checkNotNull((Object)intent, (Object)"intent can't be null");
        InstrumentationRegistry.getTargetContext().startService(this.mServiceIntent);
        this.mServiceStarted = true;
        this.mServiceBound = this.bindServiceAndWait(this.mServiceIntent, null, 1);
    }

    public IBinder bindService(@NonNull Intent intent) throws TimeoutException {
        this.mServiceIntent = ((Intent)Checks.checkNotNull((Object)intent, (Object)"intent can't be null")).cloneFilter();
        this.mServiceBound = this.bindServiceAndWait(intent, null, 1);
        return this.mBinder;
    }

    public IBinder bindService(@NonNull Intent intent, @NonNull ServiceConnection connection, int flags) throws TimeoutException {
        this.mServiceIntent = ((Intent)Checks.checkNotNull((Object)intent, (Object)"intent can't be null")).cloneFilter();
        ServiceConnection c = (ServiceConnection)Checks.checkNotNull((Object)connection, (Object)"connection can't be null");
        this.mServiceBound = this.bindServiceAndWait(this.mServiceIntent, c, flags);
        return this.mBinder;
    }

    @VisibleForTesting
    boolean bindServiceAndWait(Intent intent, ServiceConnection conn, int flags) throws TimeoutException {
        ProxyServiceConnection serviceConn = new ProxyServiceConnection(conn);
        boolean isBound = InstrumentationRegistry.getTargetContext().bindService(intent, (ServiceConnection)serviceConn, flags);
        if (isBound) {
            this.waitOnLatch(serviceConn.mConnectedLatch, "connected");
            this.mServiceConn = serviceConn;
        } else {
            Log.e((String)TAG, (String)"Failed to bind to service! Is your service declared in the manifest?");
        }
        return isBound;
    }

    public void unbindService() {
        if (this.mServiceBound) {
            InstrumentationRegistry.getTargetContext().unbindService(this.mServiceConn);
            this.mBinder = null;
            this.mServiceBound = false;
        }
    }

    private void waitOnLatch(CountDownLatch latch, String actionName) throws TimeoutException {
        try {
            if (!latch.await(this.mTimeout, this.mTimeUnit)) {
                long l = this.mTimeout;
                String string = this.mTimeUnit.name();
                throw new TimeoutException(new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(actionName).length()).append("Waited for ").append(l).append(" ").append(string).append(", but service was never ").append(actionName).toString());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String string = String.valueOf(actionName);
            throw new RuntimeException(string.length() != 0 ? "Interrupted while waiting for service to be ".concat(string) : new String("Interrupted while waiting for service to be "), e);
        }
    }

    @VisibleForTesting
    void shutdownService() throws TimeoutException {
        if (this.mServiceStarted) {
            InstrumentationRegistry.getTargetContext().stopService(this.mServiceIntent);
            this.mServiceStarted = false;
        }
        this.unbindService();
    }

    protected void beforeService() {
    }

    protected void afterService() {
    }

    public Statement apply(Statement base, Description description) {
        return new ServiceStatement(base);
    }

    private class ServiceStatement
    extends Statement {
        private final Statement mBase;

        public ServiceStatement(Statement base) {
            this.mBase = base;
        }

        public void evaluate() throws Throwable {
            try {
                ServiceTestRule.this.beforeService();
                this.mBase.evaluate();
            }
            finally {
                ServiceTestRule.this.shutdownService();
                ServiceTestRule.this.afterService();
            }
        }
    }

    class ProxyServiceConnection
    implements ServiceConnection {
        private ServiceConnection mCallerConnection;
        public CountDownLatch mConnectedLatch = new CountDownLatch(1);

        private ProxyServiceConnection(ServiceConnection connection) {
            this.mCallerConnection = connection;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            ServiceTestRule.this.mBinder = service;
            if (this.mCallerConnection != null) {
                this.mCallerConnection.onServiceConnected(name, service);
            }
            this.mConnectedLatch.countDown();
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.e((String)ServiceTestRule.TAG, (String)"Connection to the Service has been lost!");
            ServiceTestRule.this.mBinder = null;
            if (this.mCallerConnection != null) {
                this.mCallerConnection.onServiceDisconnected(name);
            }
        }
    }
}

