/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule.provider;

import android.content.ContentProvider;
import android.util.Log;
import java.io.File;
import java.lang.ref.WeakReference;

final class ProviderArgs {
    private static final String TAG = "ProviderArgs";
    private final String mAuthority;
    private final Class<? extends ContentProvider> mProviderClass;
    private String mDBName;
    private String[] mDBCmds;
    private File mDBCmdFile;
    private File mDBDataFile;
    private WeakReference<ContentProvider> mProviderRef;

    public ProviderArgs(String authority, Class<? extends ContentProvider> providerClass) {
        this.mAuthority = authority;
        this.mProviderClass = providerClass;
    }

    public void setDBName(String dbName) {
        if (this.mDBName != null) {
            Log.w((String)TAG, (String)String.format("Database name for ContentProvider with authority %s already exists", this.mAuthority));
        }
        this.mDBName = dbName;
    }

    public void setDBCmds(String ... dbCmds) {
        if (this.mDBCmds != null) {
            Log.w((String)TAG, (String)String.format("Database commands for ContentProvider with authority %s already set", this.mAuthority));
        }
        this.mDBCmds = dbCmds;
    }

    public void setDBCmdFile(File dbCmdFile) {
        if (this.mDBCmdFile != null) {
            Log.w((String)TAG, (String)String.format("Database command file for ContentProvider with authority %s already set", this.mAuthority));
        }
        this.mDBCmdFile = dbCmdFile;
    }

    public void setDBDataFile(File dbDataFile) {
        if (this.mDBDataFile != null) {
            Log.w((String)TAG, (String)String.format("Database file to restore for ContentProvider with authority %s already set", this.mAuthority));
        }
        this.mDBDataFile = dbDataFile;
    }

    public void setProviderRef(ContentProvider provider) {
        if (this.mProviderRef != null) {
            Log.w((String)TAG, (String)String.format("Reference to Provider instance with authority %s already set", this.mAuthority));
        }
        this.mProviderRef = new WeakReference<ContentProvider>(provider);
    }

    public void addDBCmds(String ... dbCmds) {
        if (null == this.mDBCmds) {
            this.mDBCmds = dbCmds;
        } else {
            String[] newCmds = new String[this.mDBCmds.length + dbCmds.length];
            System.arraycopy(this.mDBCmds, 0, newCmds, 0, this.mDBCmds.length);
            System.arraycopy(dbCmds, 0, newCmds, this.mDBCmds.length, dbCmds.length);
            this.mDBCmds = newCmds;
        }
    }

    public boolean hasDBName() {
        return this.mDBName != null;
    }

    public boolean hasDBCmds() {
        return this.mDBCmds != null;
    }

    public boolean hasDBCmdFile() {
        return this.mDBCmdFile != null;
    }

    public boolean hasDBDataFile() {
        return this.mDBDataFile != null;
    }

    public Class<? extends ContentProvider> getProviderClass() {
        return this.mProviderClass;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public String getDBName() {
        return this.mDBName;
    }

    public String[] getDBCmds() {
        return this.mDBCmds;
    }

    public File getDBCmdFile() {
        return this.mDBCmdFile;
    }

    public File getDBDataFile() {
        return this.mDBDataFile;
    }

    public ContentProvider getProvider() {
        if (this.mProviderRef != null) {
            return (ContentProvider)this.mProviderRef.get();
        }
        return null;
    }
}

