/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.google.wireless.android.sdk.stats.PercentileBucket;
import com.google.wireless.android.sdk.stats.PercentileEstimator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;

public class Percentiles {
    private double[] mInitialData;
    private double[] mTargets;
    private Bucket[] mBuckets;
    private long mCount = 0L;
    private final int mNumBuckets;
    private final int mRawDataSize;

    public Percentiles(double[] targets, int rawDataSize) {
        this.mTargets = Arrays.copyOf(targets, targets.length);
        Arrays.sort(this.mTargets);
        this.mNumBuckets = this.mTargets.length * 2 + 3;
        this.mRawDataSize = Math.max(rawDataSize, this.mNumBuckets);
        this.mInitialData = new double[this.mRawDataSize];
    }

    public void addSample(double sample) {
        if (this.mCount < (long)this.mRawDataSize) {
            this.mInitialData[(int)this.mCount++] = sample;
            return;
        }
        if (this.mCount == (long)this.mRawDataSize) {
            this.createBuckets();
        }
        ++this.mCount;
        if (this.mBuckets[0].value > sample) {
            this.mBuckets[0].value = sample;
        }
        if (this.mBuckets[this.mNumBuckets - 1].value < sample) {
            this.mBuckets[this.mNumBuckets - 1].value = sample;
        }
        for (int i = 1; i < this.mNumBuckets - 1; ++i) {
            this.mBuckets[i].optimalCount += this.mBuckets[i].target;
            if (!(this.mBuckets[i].value > sample)) continue;
            ++this.mBuckets[i].count;
        }
        this.mBuckets[this.mNumBuckets - 1].optimalCount += this.mBuckets[this.mNumBuckets - 1].target;
        ++this.mBuckets[this.mNumBuckets - 1].count;
        this.interpolateIfNecessary();
    }

    public double getApproximateValue(double target) {
        if (this.mBuckets == null) {
            assert (this.mInitialData != null);
            if (this.mCount == 0L) {
                return Double.NaN;
            }
            Arrays.sort(this.mInitialData);
            return this.mInitialData[(int)((double)this.mCount * target)];
        }
        for (Bucket b : this.mBuckets) {
            if (b.target != target) continue;
            return b.value;
        }
        return Double.NaN;
    }

    public static Percentiles merge(double[] targets, List<Percentiles> toMerge, int rawDataSize) throws MergeException {
        Percentiles p = new Percentiles(targets, rawDataSize);
        p.mBuckets = new Bucket[p.mNumBuckets];
        int currentBucket = 1;
        double[] markers = Percentiles.computeNonExtremeMarkers(targets);
        double minValue = Double.POSITIVE_INFINITY;
        double maxValue = Double.NEGATIVE_INFINITY;
        long totalCount = 0L;
        PriorityQueue<MergeHelper> queue = new PriorityQueue<MergeHelper>(toMerge.size());
        ArrayList<Percentiles> uninterpolatedEstimators = new ArrayList<Percentiles>();
        for (Percentiles input : toMerge) {
            if (input.mBuckets == null) {
                uninterpolatedEstimators.add(input);
                continue;
            }
            queue.add(new MergeHelper(input));
            minValue = Math.min(minValue, input.mBuckets[0].value);
            maxValue = Math.max(maxValue, input.mBuckets[input.mNumBuckets - 1].value);
            totalCount += input.mCount;
        }
        p.mBuckets[0] = new Bucket(0.0, minValue, 0L, totalCount);
        p.mBuckets[p.mNumBuckets - 1] = new Bucket(1.0, maxValue, totalCount, totalCount);
        p.mCount = totalCount;
        if (totalCount <= (long)p.mRawDataSize) {
            if (!queue.isEmpty()) {
                throw new MergeException("At least one interpolated estimator, but not of large enough size");
            }
            return Percentiles.mergeFromRaw(new Percentiles(targets, rawDataSize), uninterpolatedEstimators);
        }
        p.mInitialData = null;
        long countFromConsumedEstimators = 0L;
        for (double targetMarker : markers) {
            long targetCount = (long)(targetMarker * (double)totalCount);
            long lastCount = 0L;
            double lastMarkerValue = minValue;
            while (!queue.isEmpty()) {
                MergeHelper m = (MergeHelper)queue.poll();
                double markerValue = m.value();
                long countAtValue = m.count() + countFromConsumedEstimators;
                for (MergeHelper h : queue) {
                    countAtValue += h.estimatedCountAtValue(markerValue);
                }
                if (countAtValue < targetCount) {
                    lastCount = countAtValue;
                    lastMarkerValue = markerValue;
                    if (m.increment()) {
                        queue.add(m);
                        continue;
                    }
                    countFromConsumedEstimators += m.p.mCount;
                    continue;
                }
                if (countAtValue == targetCount) {
                    p.mBuckets[currentBucket++] = new Bucket(targetMarker, markerValue, countAtValue, totalCount);
                    if (m.increment()) {
                        queue.add(m);
                        break;
                    }
                    countFromConsumedEstimators += m.p.mCount;
                    break;
                }
                queue.add(m);
                double ratio = (double)(targetCount - lastCount) / (double)(countAtValue - lastCount);
                double estimatedMarkerValue = lastMarkerValue + (markerValue - lastMarkerValue) * ratio;
                p.mBuckets[currentBucket++] = new Bucket(targetMarker, estimatedMarkerValue, targetCount, totalCount);
                break;
            }
            assert (!queue.isEmpty());
        }
        return Percentiles.mergeFromRaw(p, uninterpolatedEstimators);
    }

    public PercentileEstimator export() {
        PercentileEstimator.Builder builder = PercentileEstimator.newBuilder();
        if (this.mBuckets == null) {
            int i = 0;
            while ((long)i < this.mCount) {
                builder.addRawSample(this.mInitialData[i]);
                ++i;
            }
        } else {
            for (Bucket b : this.mBuckets) {
                builder.addBucketBuilder().setTargetPercentile(b.target).setValue(b.value).setCount(b.count);
            }
        }
        return builder.build();
    }

    public static Percentiles fromProto(PercentileEstimator e, double[] targets, int rawDataSize) throws MismatchedTargetsException {
        Percentiles r = new Percentiles(targets, rawDataSize);
        if (e.getBucketCount() > 0) {
            double[] markers = Percentiles.computeNonExtremeMarkers(targets);
            assert (markers.length == r.mNumBuckets - 2);
            if (r.mNumBuckets != e.getBucketCount()) {
                throw new MismatchedTargetsException("Mismatched target lengths");
            }
            if (e.getBucket(0).getTargetPercentile() != 0.0) {
                throw new MismatchedTargetsException("First bucket target percentile was not 0.0");
            }
            if (e.getBucket(e.getBucketCount() - 1).getTargetPercentile() != 1.0) {
                throw new MismatchedTargetsException("Last bucket target percentile was not 1.0");
            }
            for (int i = 1; i < r.mNumBuckets - 1; ++i) {
                PercentileBucket b = e.getBucket(i);
                if (b.getTargetPercentile() == markers[i - 1]) continue;
                throw new MismatchedTargetsException("Mismatched targets at index " + i);
            }
        }
        if (e.getRawSampleCount() > 0) {
            assert (e.getBucketCount() == 0);
            for (int i = 0; i < e.getRawSampleCount(); ++i) {
                r.addSample(e.getRawSample(i));
            }
            return r;
        }
        if (e.getBucketCount() > 0) {
            r.mInitialData = null;
            r.mBuckets = new Bucket[e.getBucketCount()];
            r.mCount = e.getBucket(e.getBucketCount() - 1).getCount();
            for (int i = 0; i < e.getBucketCount(); ++i) {
                PercentileBucket bucket = e.getBucket(i);
                r.mBuckets[i] = new Bucket(bucket.getTargetPercentile(), bucket.getValue(), bucket.getCount(), r.mCount);
            }
        }
        return r;
    }

    private void createBuckets() {
        Arrays.sort(this.mInitialData);
        this.mBuckets = new Bucket[this.mNumBuckets];
        double last = 0.0;
        this.mBuckets[0] = new Bucket(0.0, this.mInitialData[0], 0L, this.mRawDataSize);
        int currentBucketIndex = 1;
        for (double t : this.mTargets) {
            double target = (last + t) / 2.0;
            int index = (int)(target * (double)this.mRawDataSize);
            this.mBuckets[currentBucketIndex] = new Bucket(target, this.mInitialData[index], index, this.mRawDataSize);
            target = t;
            index = (int)(target * (double)this.mRawDataSize);
            this.mBuckets[++currentBucketIndex] = new Bucket(target, this.mInitialData[index], index, this.mRawDataSize);
            ++currentBucketIndex;
            last = t;
        }
        assert (currentBucketIndex == this.mTargets.length * 2 + 1);
        double target = (1.0 + last) / 2.0;
        int index = (int)(target * (double)this.mRawDataSize);
        this.mBuckets[currentBucketIndex] = new Bucket(target, this.mInitialData[index], index, this.mRawDataSize);
        this.mBuckets[++currentBucketIndex] = new Bucket(1.0, this.mInitialData[this.mRawDataSize - 1], this.mRawDataSize, this.mRawDataSize);
        assert (currentBucketIndex + 1 == this.mNumBuckets);
        this.mInitialData = null;
    }

    private void interpolateIfNecessary() {
        for (int i = 1; i < this.mNumBuckets - 1; ++i) {
            Bucket b = this.mBuckets[i];
            Bucket prev = this.mBuckets[i - 1];
            Bucket next = this.mBuckets[i + 1];
            double delta = b.optimalCount - (double)b.count;
            if (delta < -1.0 && prev.count - b.count < -1L) {
                Percentiles.update(b, prev, next, -1.0);
                continue;
            }
            if (!(delta > 1.0) || next.count - b.count <= 1L) continue;
            Percentiles.update(b, prev, next, 1.0);
        }
    }

    private static void update(Bucket b, Bucket prev, Bucket next, double d) {
        double numerator = ((double)(b.count - prev.count) + d) * (next.value - b.value) / (double)(next.count - b.count) + ((double)(next.count - b.count) - d) * (b.value - prev.value) / (double)(b.count - prev.count);
        double newValue = b.value + d * numerator / (double)(next.count - prev.count);
        if (prev.value < newValue && newValue < next.value) {
            b.value = newValue;
        } else {
            newValue = d < 0.0 ? b.value - (b.value - prev.value) / (double)(b.count - prev.count) : b.value + (next.value - b.value) / (double)(next.count - b.count);
            b.value = newValue;
        }
        b.count += (long)d;
    }

    private static double[] computeNonExtremeMarkers(double[] targets) {
        double[] ret = new double[2 * targets.length + 1];
        int c = 0;
        double last = 0.0;
        for (double t : targets) {
            ret[c++] = (last + t) / 2.0;
            ret[c++] = t;
            last = t;
        }
        ret[c] = (last + 1.0) / 2.0;
        return ret;
    }

    private static Percentiles mergeFromRaw(Percentiles p, List<Percentiles> raw) {
        for (Percentiles input : raw) {
            int i = 0;
            while ((long)i < input.mCount) {
                p.addSample(input.mInitialData[i]);
                ++i;
            }
        }
        return p;
    }

    private static class Bucket {
        public double target;
        public double value;
        public long count;
        public double optimalCount;

        public Bucket(double target, double value, long count, long totalCount) {
            this.target = target;
            this.value = value;
            this.count = count;
            this.optimalCount = (double)totalCount * target;
        }
    }

    static class MergeHelper
    implements Comparable<MergeHelper> {
        private Percentiles p;
        private int markerIndex = 0;
        private double segmentLinearRate = 0.0;
        private double segmentStartValue = Double.NEGATIVE_INFINITY;
        private long segmentStartCount = Long.MIN_VALUE;

        public MergeHelper(Percentiles p) {
            this.p = p;
            this.increment();
        }

        public boolean done() {
            return this.markerIndex >= this.p.mBuckets.length;
        }

        public long estimatedCountAtValue(double value) {
            if (value < this.segmentStartValue) {
                return 0L;
            }
            return this.segmentStartCount + (long)((value - this.segmentStartValue) / this.segmentLinearRate);
        }

        public boolean increment() {
            ++this.markerIndex;
            if (!this.done()) {
                this.segmentStartValue = this.p.mBuckets[this.markerIndex - 1].value;
                this.segmentStartCount = this.p.mBuckets[this.markerIndex - 1].count;
                this.segmentLinearRate = (this.p.mBuckets[this.markerIndex].value - this.segmentStartValue) / (double)(this.p.mBuckets[this.markerIndex].count - this.segmentStartCount);
                return true;
            }
            return false;
        }

        public double target() {
            return this.p.mBuckets[this.markerIndex].target;
        }

        public double value() {
            return this.p.mBuckets[this.markerIndex].value;
        }

        public long count() {
            return this.p.mBuckets[this.markerIndex].count;
        }

        @Override
        public int compareTo(MergeHelper o) {
            return (int)Math.signum(this.value() - o.value());
        }
    }

    public static class MergeException
    extends Exception {
        public MergeException(String s) {
            super(s);
        }
    }

    public static class MismatchedTargetsException
    extends Exception {
        public MismatchedTargetsException(String s) {
            super(s);
        }
    }
}

