/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler.android;

import com.android.aaptcompiler.android.LocaleDataTablesKt;
import com.android.aaptcompiler.android.Ref;
import java.util.Arrays;
import java.util.Map;

public class LocaleData {
    static final int SCRIPT_LENGTH = 4;
    private static final int PACKED_ROOT = 0;
    private static final int US_SPANISH = 1702057299;
    private static final int MEXICAN_SPANISH = 1702055256;
    private static final int LATIN_AMERICAN_SPANISH = 1702077476;
    static final int[] ENGLISH_STOP_LIST = new int[]{1701707776, 1701741568};
    static final byte[] ENGLISH_CHARS = new byte[]{101, 110};
    static final String LATIN_CHARS = "Latn";

    private static int packLocale(byte[] language, byte[] region) {
        return (language[0] & 0xFF) << 24 | (language[1] & 0xFF) << 16 | (region[0] & 0xFF) << 8 | region[1] & 0xFF;
    }

    private static int dropRegion(int packed_locale) {
        return packed_locale & 0xFFFF0000;
    }

    private static boolean hasRegion(int packed_locale) {
        return (packed_locale & 0xFFFF) != 0;
    }

    private static int findParent(int packed_locale, String script) {
        if (LocaleData.hasRegion(packed_locale)) {
            for (Map.Entry<String, Map<Integer, Integer>> entry : LocaleDataTablesKt.getSCRIPT_PARENTS().entrySet()) {
                if (!script.equals(entry.getKey())) continue;
                Map<Integer, Integer> map = entry.getValue();
                Integer lookup_result = map.get(packed_locale);
                if (lookup_result == null) break;
                return lookup_result;
            }
            return LocaleData.dropRegion(packed_locale);
        }
        return 0;
    }

    static int findAncestors(int[] out, Ref<Long> stop_list_index, int packed_locale, String script, int[] stop_list, int stop_set_length) {
        int ancestor = packed_locale;
        int count = 0;
        do {
            if (out != null) {
                out[count] = ancestor;
            }
            ++count;
            for (int i = 0; i < stop_set_length; ++i) {
                if (stop_list[i] != ancestor) continue;
                stop_list_index.set(Long.valueOf(i));
                return count;
            }
        } while ((ancestor = LocaleData.findParent(ancestor, script)) != 0);
        stop_list_index.set(-1L);
        return count;
    }

    static int findDistance(int supported, String script, int[] request_ancestors, int request_ancestors_count) {
        Ref<Object> request_ancestors_indexRef = new Ref<Object>(null);
        int supported_ancestor_count = LocaleData.findAncestors(null, request_ancestors_indexRef, supported, script, request_ancestors, request_ancestors_count);
        return (int)((long)supported_ancestor_count + (Long)request_ancestors_indexRef.get() - 1L);
    }

    static boolean isRepresentative(int language_and_region, String script) {
        long packed_locale = (long)language_and_region << 32 | ((long)script.charAt(0) & 0xFFL) << 24 | ((long)script.charAt(1) & 0xFFL) << 16 | ((long)script.charAt(2) & 0xFFL) << 8 | (long)script.charAt(3) & 0xFFL;
        return LocaleDataTablesKt.getREPRESENTATIVE_LOCALES().contains(packed_locale);
    }

    private static boolean isSpecialSpanish(int language_and_region) {
        return language_and_region == 1702057299 || language_and_region == 1702055256;
    }

    static int localeDataCompareRegions(byte[] left_region, byte[] right_region, byte[] requested_language, String requested_script, byte[] requested_region) {
        boolean right_is_representative;
        int right_distance;
        if (left_region[0] == right_region[0] && left_region[1] == right_region[1]) {
            return 0;
        }
        int left = LocaleData.packLocale(requested_language, left_region);
        int right = LocaleData.packLocale(requested_language, right_region);
        int request = LocaleData.packLocale(requested_language, requested_region);
        boolean leftIsSpecialSpanish = LocaleData.isSpecialSpanish(left);
        boolean rightIsSpecialSpanish = LocaleData.isSpecialSpanish(right);
        if (leftIsSpecialSpanish && !rightIsSpecialSpanish && right != 1702077476) {
            left = 1702077476;
        } else if (rightIsSpecialSpanish && !leftIsSpecialSpanish && left != 1702077476) {
            right = 1702077476;
        }
        int[] request_ancestors = new int[4];
        Ref<Object> left_right_indexRef = new Ref<Object>(null);
        int[] left_and_right = new int[]{left, right};
        int ancestor_count = LocaleData.findAncestors(request_ancestors, left_right_indexRef, request, requested_script, left_and_right, LocaleData.sizeof(left_and_right));
        if ((Long)left_right_indexRef.get() == 0L) {
            return 1;
        }
        if ((Long)left_right_indexRef.get() == 1L) {
            return -1;
        }
        int left_distance = LocaleData.findDistance(left, requested_script, request_ancestors, ancestor_count);
        if (left_distance != (right_distance = LocaleData.findDistance(right, requested_script, request_ancestors, ancestor_count))) {
            return right_distance - left_distance;
        }
        boolean left_is_representative = LocaleData.isRepresentative(left, requested_script);
        if (left_is_representative != (right_is_representative = LocaleData.isRepresentative(right, requested_script))) {
            return (left_is_representative ? 1 : 0) - (right_is_representative ? 1 : 0);
        }
        return right - left;
    }

    static void localeDataComputeScript(byte[] out, byte[] language, byte[] region) {
        if (language[0] == 0) {
            Arrays.fill(out, (byte)0);
            return;
        }
        int lookup_key = LocaleData.packLocale(language, region);
        Byte lookup_result = LocaleDataTablesKt.getLIKELY_SCRIPTS().get(lookup_key);
        if (lookup_result == null) {
            if (region[0] != 0) {
                lookup_key = LocaleData.dropRegion(lookup_key);
                lookup_result = LocaleDataTablesKt.getLIKELY_SCRIPTS().get(lookup_key);
                if (lookup_result != null) {
                    System.arraycopy(LocaleDataTablesKt.getSCRIPT_CODES()[lookup_result], 0, out, 0, 4);
                    return;
                }
            }
            Arrays.fill(out, (byte)0);
            return;
        }
        System.arraycopy(LocaleDataTablesKt.getSCRIPT_CODES()[lookup_result], 0, out, 0, 4);
    }

    static boolean localeDataIsCloseToUsEnglish(byte[] region) {
        int locale = LocaleData.packLocale(ENGLISH_CHARS, region);
        Ref<Object> stop_list_indexRef = new Ref<Object>(null);
        LocaleData.findAncestors(null, stop_list_indexRef, locale, LATIN_CHARS, ENGLISH_STOP_LIST, 2);
        return (Long)stop_list_indexRef.get() == 0L;
    }

    private static int sizeof(int[] array) {
        return array.length;
    }
}

