/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class IncrementalFileMergerState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<String> inputNames;
    private final ImmutableMap<String, ImmutableList<String>> origin;
    private final ImmutableMap<String, ImmutableSet<String>> byInput;

    public IncrementalFileMergerState() {
        this.inputNames = ImmutableList.of();
        this.origin = ImmutableMap.of();
        this.byInput = ImmutableMap.of();
    }

    IncrementalFileMergerState(List<String> inputNames, Map<String, List<String>> origin, Map<String, Set<String>> byInput) {
        ImmutableMap.Builder originBuilder = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> e : origin.entrySet()) {
            originBuilder.put((Object)e.getKey(), (Object)ImmutableList.copyOf((Collection)e.getValue()));
        }
        ImmutableMap.Builder byInputBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Set<String>> e : byInput.entrySet()) {
            byInputBuilder.put((Object)e.getKey(), (Object)ImmutableSet.copyOf((Collection)e.getValue()));
        }
        this.inputNames = ImmutableList.copyOf(inputNames);
        this.origin = originBuilder.build();
        this.byInput = byInputBuilder.build();
    }

    ImmutableList<String> getInputNames() {
        return this.inputNames;
    }

    ImmutableList<String> inputsFor(String path) {
        ImmutableList names = (ImmutableList)this.origin.get((Object)path);
        if (names == null) {
            return ImmutableList.of();
        }
        return names;
    }

    ImmutableSet<String> filesOf(String name) {
        ImmutableSet files = (ImmutableSet)this.byInput.get((Object)name);
        if (files == null) {
            return ImmutableSet.of();
        }
        return files;
    }

    static class Builder {
        private List<String> inputNames;
        private Map<String, List<String>> origin;
        private Map<String, Set<String>> byInput;

        Builder(IncrementalFileMergerState state) {
            this.inputNames = new ArrayList<String>((Collection<String>)state.inputNames);
            this.origin = new HashMap<String, List<String>>();
            for (Map.Entry e : state.origin.entrySet()) {
                this.origin.put((String)e.getKey(), new ArrayList((Collection)e.getValue()));
            }
            this.byInput = new HashMap<String, Set<String>>();
            for (Map.Entry e : state.byInput.entrySet()) {
                this.byInput.put((String)e.getKey(), new HashSet((Collection)e.getValue()));
            }
        }

        void setInputNames(List<String> inputNames) {
            this.inputNames = new ArrayList<String>(inputNames);
            Iterator<String> it = this.byInput.keySet().iterator();
            while (it.hasNext()) {
                String in = it.next();
                if (inputNames.contains(in)) continue;
                Set<String> paths = this.byInput.get(in);
                for (String p : paths) {
                    List<String> inputs = this.origin.get(p);
                    int idx = inputs.indexOf(in);
                    assert (idx >= 0);
                    if (inputs.size() == 1) {
                        this.origin.remove(p);
                        continue;
                    }
                    inputs.remove(idx);
                }
                it.remove();
            }
        }

        void remove(String path) {
            List<String> names = this.origin.get(path);
            if (names == null) {
                return;
            }
            for (String n : names) {
                Set<String> files = this.byInput.get(n);
                assert (files != null);
                files.remove(path);
            }
            this.origin.remove(path);
        }

        void set(String path, List<String> names) {
            this.remove(path);
            assert (this.inputNames.containsAll(names));
            this.origin.put(path, new ArrayList<String>(names));
            for (String n : names) {
                Set files = this.byInput.computeIfAbsent(n, k -> new HashSet());
                files.add(path);
            }
        }

        IncrementalFileMergerState build() {
            return new IncrementalFileMergerState(this.inputNames, this.origin, this.byInput);
        }
    }
}

