/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfBinop;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.code.Format12x;
import com.android.tools.r8.code.NotInt;
import com.android.tools.r8.code.NotLong;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.analysis.constant.Bottom;
import com.android.tools.r8.ir.analysis.constant.ConstLatticeElement;
import com.android.tools.r8.ir.analysis.constant.LatticeElement;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Unop;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import java.util.function.Function;

public class Not
extends Unop {
    public final NumericType type;

    public Not(NumericType type, Value dest, Value source) {
        super(dest, source);
        this.type = type;
    }

    @Override
    public boolean canBeFolded() {
        return this.source().isConstant();
    }

    @Override
    public LatticeElement evaluate(IRCode code, Function<Value, LatticeElement> getLatticeElement) {
        LatticeElement sourceLattice = getLatticeElement.apply(this.source());
        if (sourceLattice.isConst()) {
            ConstNumber newConst;
            ConstNumber sourceConst = sourceLattice.asConst().getConstNumber();
            ValueType valueType = ValueType.fromNumericType(this.type);
            Value value = code.createValue(valueType, this.getLocalInfo());
            if (this.type == NumericType.INT) {
                newConst = new ConstNumber(value, ~sourceConst.getIntValue());
            } else {
                assert (this.type == NumericType.LONG);
                newConst = new ConstNumber(value, sourceConst.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return new ConstLatticeElement(newConst);
        }
        return Bottom.getInstance();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format12x instruction;
        assert (builder.getOptions().canUseNotInstruction());
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int src = builder.allocatedRegister(this.source(), this.getNumber());
        switch (this.type) {
            case INT: {
                instruction = new NotInt(dest, src);
                break;
            }
            case LONG: {
                instruction = new NotLong(dest, src);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asNot().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asNot().type.ordinal();
    }

    @Override
    public boolean isNot() {
        return true;
    }

    @Override
    public Not asNot() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public int getCfOpcode() {
        throw new Unreachable("Unexpected request for 'not' opcode which is translated to 'xor -1'");
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfConstNumber(-1L, ValueType.fromNumericType(this.type)));
        builder.add(new CfBinop(this.type.isWide() ? 131 : 130));
    }
}

