/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.FixedRegisterValue;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LongInterval;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Value {
    public static final int UNDEFINED_NUMBER = -1;
    public static final Value UNDEFINED = new Value(-1, ValueType.OBJECT, null);
    protected final int number;
    protected final ValueType type;
    public Instruction definition = null;
    private LinkedList<Instruction> users = new LinkedList();
    private Set<Instruction> uniqueUsers = null;
    private LinkedList<Phi> phiUsers = new LinkedList();
    private Set<Phi> uniquePhiUsers = null;
    private Value nextConsecutive = null;
    private Value previousConsecutive = null;
    private LiveIntervals liveIntervals;
    private int needsRegister = -1;
    private boolean neverNull = false;
    private boolean isThis = false;
    private boolean isArgument = false;
    private boolean knownToBeBoolean = false;
    private LongInterval valueRange;
    private DebugData debugData;

    public Value(int number, ValueType type, DebugLocalInfo local) {
        this.number = number;
        this.type = type;
        this.debugData = local == null ? null : new DebugData(local);
    }

    public boolean isFixedRegisterValue() {
        return false;
    }

    public FixedRegisterValue asFixedRegisterValue() {
        return null;
    }

    public int getNumber() {
        return this.number;
    }

    public int requiredRegisters() {
        return this.type.requiredRegisters();
    }

    public DebugLocalInfo getLocalInfo() {
        return this.debugData == null ? null : this.debugData.local;
    }

    public boolean hasLocalInfo() {
        return this.getLocalInfo() != null;
    }

    public void setLocalInfo(DebugLocalInfo local) {
        assert (local != null);
        assert (this.debugData == null);
        this.debugData = new DebugData(local);
    }

    public void clearLocalInfo() {
        assert (this.debugData.users.isEmpty());
        assert (this.debugData.phiUsers.isEmpty());
        this.debugData = null;
    }

    public List<Instruction> getDebugLocalStarts() {
        if (this.debugData == null) {
            return Collections.emptyList();
        }
        ArrayList<Instruction> starts = new ArrayList<Instruction>(this.debugData.users.size());
        for (Map.Entry<Instruction, DebugUse> entry : this.debugData.users.entrySet()) {
            if (entry.getValue() != DebugUse.START) continue;
            starts.add(entry.getKey());
        }
        return starts;
    }

    public List<Instruction> getDebugLocalEnds() {
        if (this.debugData == null) {
            return Collections.emptyList();
        }
        ArrayList<Instruction> ends = new ArrayList<Instruction>(this.debugData.users.size());
        for (Map.Entry<Instruction, DebugUse> entry : this.debugData.users.entrySet()) {
            if (entry.getValue() != DebugUse.END) continue;
            ends.add(entry.getKey());
        }
        return ends;
    }

    public void addDebugLocalStart(Instruction start) {
        assert (start != null);
        this.debugData.users.put(start, this.markStart(this.debugData.users.get(start)));
    }

    private DebugUse markStart(DebugUse use2) {
        assert (use2 != null);
        return use2 == null ? DebugUse.START : use2.start();
    }

    public void addDebugLocalEnd(Instruction end) {
        assert (end != null);
        this.debugData.users.put(end, this.markEnd(this.debugData.users.get(end)));
    }

    private DebugUse markEnd(DebugUse use2) {
        assert (use2 != null);
        return use2 == null ? DebugUse.END : use2.end();
    }

    public void linkTo(Value other) {
        assert (this.nextConsecutive == null || this.nextConsecutive == other);
        assert (other.previousConsecutive == null || other.previousConsecutive == this);
        other.previousConsecutive = this;
        this.nextConsecutive = other;
    }

    public void replaceLink(Value newArgument) {
        assert (this.isLinked());
        if (this.previousConsecutive != null) {
            this.previousConsecutive.nextConsecutive = newArgument;
            newArgument.previousConsecutive = this.previousConsecutive;
            this.previousConsecutive = null;
        }
        if (this.nextConsecutive != null) {
            this.nextConsecutive.previousConsecutive = newArgument;
            newArgument.nextConsecutive = this.nextConsecutive;
            this.nextConsecutive = null;
        }
    }

    public boolean isLinked() {
        return this.nextConsecutive != null || this.previousConsecutive != null;
    }

    public Value getStartOfConsecutive() {
        Value current = this;
        while (current.getPreviousConsecutive() != null) {
            current = current.getPreviousConsecutive();
        }
        return current;
    }

    public Value getNextConsecutive() {
        return this.nextConsecutive;
    }

    public Value getPreviousConsecutive() {
        return this.previousConsecutive;
    }

    public Set<Instruction> uniqueUsers() {
        if (this.uniqueUsers != null) {
            return this.uniqueUsers;
        }
        this.uniqueUsers = ImmutableSet.copyOf(this.users);
        return this.uniqueUsers;
    }

    public Set<Phi> uniquePhiUsers() {
        if (this.uniquePhiUsers != null) {
            return this.uniquePhiUsers;
        }
        this.uniquePhiUsers = ImmutableSet.copyOf(this.phiUsers);
        return this.uniquePhiUsers;
    }

    public Set<Instruction> debugUsers() {
        return this.debugData == null ? null : Collections.unmodifiableSet(this.debugData.users.keySet());
    }

    public Set<Phi> debugPhiUsers() {
        return this.debugData == null ? null : Collections.unmodifiableSet(this.debugData.phiUsers);
    }

    public int numberOfUsers() {
        int size = this.users.size();
        if (size <= 1) {
            return size;
        }
        return this.uniqueUsers().size();
    }

    public int numberOfPhiUsers() {
        int size = this.phiUsers.size();
        if (size <= 1) {
            return size;
        }
        return this.uniquePhiUsers().size();
    }

    public int numberOfAllNonDebugUsers() {
        return this.numberOfUsers() + this.numberOfPhiUsers();
    }

    public int numberOfDebugUsers() {
        return this.debugData == null ? 0 : this.debugData.users.size();
    }

    public int numberOfDebugPhiUsers() {
        return this.debugData == null ? 0 : this.debugData.phiUsers.size();
    }

    public int numberOfAllDebugUsers() {
        return this.numberOfDebugUsers() + this.numberOfDebugPhiUsers();
    }

    public int numberOfAllUsers() {
        return this.numberOfAllNonDebugUsers() + this.numberOfAllDebugUsers();
    }

    public boolean isUsed() {
        return !this.users.isEmpty() || !this.phiUsers.isEmpty() || this.numberOfAllDebugUsers() > 0;
    }

    public boolean usedInMonitorOperation() {
        for (Instruction instruction : this.uniqueUsers()) {
            if (!instruction.isMonitor()) continue;
            return true;
        }
        return false;
    }

    public void addUser(Instruction user) {
        this.users.add(user);
        this.uniqueUsers = null;
    }

    public void removeUser(Instruction user) {
        this.users.remove(user);
        this.uniqueUsers = null;
    }

    private void fullyRemoveUser(Instruction user) {
        this.users.removeIf(u -> u == user);
        this.uniqueUsers = null;
    }

    public void clearUsers() {
        this.users.clear();
        this.uniqueUsers = null;
        this.phiUsers.clear();
        this.uniquePhiUsers = null;
        if (this.debugData != null) {
            this.debugData.users.clear();
            this.debugData.phiUsers.clear();
        }
    }

    public void addPhiUser(Phi user) {
        this.phiUsers.add(user);
        this.uniquePhiUsers = null;
    }

    public void removePhiUser(Phi user) {
        this.phiUsers.remove(user);
        this.uniquePhiUsers = null;
    }

    private void fullyRemovePhiUser(Phi user) {
        this.phiUsers.removeIf(u -> u == user);
        this.uniquePhiUsers = null;
    }

    public void addDebugUser(Instruction user) {
        assert (this.hasLocalInfo());
        this.debugData.users.putIfAbsent(user, DebugUse.LIVE);
    }

    public void addDebugPhiUser(Phi user) {
        assert (this.hasLocalInfo());
        this.debugData.phiUsers.add(user);
    }

    public boolean isUninitializedLocal() {
        return this.definition != null && this.definition.isDebugLocalUninitialized();
    }

    public boolean isInitializedLocal() {
        return !this.isUninitializedLocal();
    }

    public void removeDebugUser(Instruction user) {
        if (this.debugData != null && this.debugData.users != null) {
            this.debugData.users.remove(user);
            return;
        }
        assert (false);
    }

    public void removeDebugPhiUser(Phi user) {
        if (this.debugData != null && this.debugData.phiUsers != null) {
            this.debugData.phiUsers.remove(user);
            return;
        }
        assert (false);
    }

    public boolean hasUsersInfo() {
        return this.users != null;
    }

    public void clearUsersInfo() {
        this.users = null;
        this.uniqueUsers = null;
        this.phiUsers = null;
        this.uniquePhiUsers = null;
        if (this.debugData != null) {
            this.debugData.users = null;
            this.debugData.phiUsers = null;
        }
    }

    public void replaceUsers(Value newValue) {
        if (this == newValue) {
            return;
        }
        for (Instruction instruction : this.uniqueUsers()) {
            instruction.replaceValue(this, newValue);
        }
        for (Phi phi : this.uniquePhiUsers()) {
            phi.replaceOperand(this, newValue);
        }
        if (this.debugData != null) {
            for (Instruction instruction : this.debugUsers()) {
                instruction.replaceDebugValue(this, newValue);
            }
            for (Phi phi : this.debugPhiUsers()) {
                phi.replaceDebugValue(this, newValue);
            }
        }
        this.clearUsers();
    }

    public void replaceSelectiveUsers(Value newValue, Set<Instruction> selectedInstructions, Set<Phi> selectedPhis) {
        if (this == newValue) {
            return;
        }
        for (Instruction instruction : this.uniqueUsers()) {
            if (!selectedInstructions.contains(instruction)) continue;
            this.fullyRemoveUser(instruction);
            instruction.replaceValue(this, newValue);
        }
        for (Phi phi : this.uniquePhiUsers()) {
            if (!selectedPhis.contains(phi)) continue;
            this.fullyRemovePhiUser(phi);
            phi.replaceOperand(this, newValue);
        }
        if (this.debugData != null) {
            Iterator<Instruction> it = this.debugData.users.keySet().iterator();
            while (it.hasNext()) {
                Instruction instruction = it.next();
                if (!selectedInstructions.contains(instruction)) continue;
                it.remove();
                instruction.replaceDebugValue(this, newValue);
            }
            Iterator<Phi> iterator = this.debugData.phiUsers.iterator();
            while (iterator.hasNext()) {
                Phi user = iterator.next();
                if (!selectedPhis.contains(user)) continue;
                iterator.remove();
                user.replaceDebugValue(this, newValue);
            }
        }
    }

    public void replaceDebugUser(Instruction oldUser, Instruction newUser) {
        DebugUse use2 = this.debugData.users.remove(oldUser);
        if (use2 != null) {
            newUser.addDebugValue(this);
            this.debugData.users.put(newUser, use2);
        }
    }

    public void setLiveIntervals(LiveIntervals intervals) {
        assert (this.liveIntervals == null);
        this.liveIntervals = intervals;
    }

    public LiveIntervals getLiveIntervals() {
        return this.liveIntervals;
    }

    public boolean needsRegister() {
        assert (this.needsRegister >= 0);
        assert (!this.hasUsersInfo() || this.needsRegister > 0 == this.internalComputeNeedsRegister());
        return this.needsRegister > 0;
    }

    public void setNeedsRegister(boolean value) {
        assert (this.needsRegister == -1 || this.needsRegister > 0 == value);
        this.needsRegister = value ? 1 : 0;
    }

    public void computeNeedsRegister() {
        assert (this.needsRegister < 0);
        this.setNeedsRegister(this.internalComputeNeedsRegister());
    }

    public boolean internalComputeNeedsRegister() {
        if (!this.isConstNumber()) {
            return true;
        }
        if (this.numberOfPhiUsers() > 0) {
            return true;
        }
        for (Instruction user : this.uniqueUsers()) {
            if (!user.needsValueInRegister(this)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRegisterConstraint() {
        for (Instruction instruction : this.uniqueUsers()) {
            if (instruction.maxInValueRegister() == 65535) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        boolean isConstant;
        StringBuilder builder = new StringBuilder();
        builder.append("v");
        builder.append(this.number);
        boolean bl = isConstant = this.definition != null && this.definition.isConstNumber();
        if (isConstant || this.hasLocalInfo()) {
            builder.append("(");
            if (isConstant) {
                ConstNumber constNumber = this.definition.asConstNumber();
                if (constNumber.outType().isSingle()) {
                    builder.append((int)constNumber.getRawValue());
                } else {
                    builder.append(constNumber.getRawValue());
                }
            }
            if (isConstant && this.hasLocalInfo()) {
                builder.append(", ");
            }
            if (this.hasLocalInfo()) {
                builder.append(this.getLocalInfo());
            }
            builder.append(")");
        }
        if (this.valueRange != null) {
            builder.append(this.valueRange);
        }
        return builder.toString();
    }

    public ValueType outType() {
        return this.type;
    }

    public ConstInstruction getConstInstruction() {
        assert (this.isConstant());
        return this.definition.getOutConstantConstInstruction();
    }

    public boolean isConstNumber() {
        return this.isConstant() && this.getConstInstruction().isConstNumber();
    }

    public boolean isConstString() {
        return this.isConstant() && this.getConstInstruction().isConstString();
    }

    public boolean isConstClass() {
        return this.isConstant() && this.getConstInstruction().isConstClass();
    }

    public boolean isConstant() {
        return this.definition.isOutConstant() && !this.hasLocalInfo();
    }

    public boolean isPhi() {
        return false;
    }

    public Phi asPhi() {
        return null;
    }

    public void markNeverNull() {
        assert (!this.neverNull);
        this.neverNull = true;
    }

    public boolean isNeverNull() {
        return this.neverNull || this.definition != null && this.definition.isNonNull();
    }

    public boolean canBeNull() {
        return !this.neverNull;
    }

    public void markAsArgument() {
        assert (!this.isArgument);
        assert (!this.isThis);
        this.isArgument = true;
    }

    public boolean isArgument() {
        return this.isArgument;
    }

    public void setKnownToBeBoolean(boolean knownToBeBoolean) {
        this.knownToBeBoolean = knownToBeBoolean;
    }

    public boolean knownToBeBoolean() {
        return this.knownToBeBoolean;
    }

    public void markAsThis() {
        assert (this.isArgument);
        assert (!this.isThis);
        this.isThis = true;
        this.markNeverNull();
    }

    public boolean isThis() {
        return this.isThis;
    }

    public void setValueRange(LongInterval range) {
        this.valueRange = range;
    }

    public boolean hasValueRange() {
        return this.valueRange != null || this.isConstNumber();
    }

    public boolean isValueInRange(int value) {
        if (this.isConstNumber()) {
            return value == this.getConstInstruction().asConstNumber().getIntValue();
        }
        return this.valueRange != null && this.valueRange.containsValue(value);
    }

    public LongInterval getValueRange() {
        if (this.isConstNumber()) {
            if (this.type.isSingle()) {
                int value = this.getConstInstruction().asConstNumber().getIntValue();
                return new LongInterval(value, value);
            }
            assert (this.type.isWide());
            long value = this.getConstInstruction().asConstNumber().getLongValue();
            return new LongInterval(value, value);
        }
        return this.valueRange;
    }

    public boolean isDead(InternalOptions options) {
        return !this.isUsed() || this.isDead(options, new HashSet<Value>());
    }

    protected boolean isDead(InternalOptions options, Set<Value> active) {
        if (this.numberOfDebugUsers() != 0) {
            return false;
        }
        active.add(this);
        for (Instruction instruction : this.uniqueUsers()) {
            if (!instruction.canBeDeadCode(null, options)) {
                return false;
            }
            Value outValue = instruction.outValue();
            assert (outValue != null);
            if (active.contains(outValue) || outValue.isDead(options, active)) continue;
            return false;
        }
        for (Phi phi : this.uniquePhiUsers()) {
            if (active.contains(phi) || phi.isDead(options, active)) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        return this.isConstant() && this.getConstInstruction().isConstNumber() && this.getConstInstruction().asConstNumber().isZero();
    }

    private static enum DebugUse {
        LIVE,
        START,
        END,
        LIVE_FINAL;


        DebugUse start() {
            switch (this) {
                case LIVE: 
                case START: {
                    return START;
                }
                case END: 
                case LIVE_FINAL: {
                    return LIVE_FINAL;
                }
            }
            throw new Unreachable();
        }

        DebugUse end() {
            switch (this) {
                case LIVE: 
                case END: {
                    return END;
                }
                case START: 
                case LIVE_FINAL: {
                    return LIVE_FINAL;
                }
            }
            throw new Unreachable();
        }
    }

    private static class DebugData {
        final DebugLocalInfo local;
        Map<Instruction, DebugUse> users = new HashMap<Instruction, DebugUse>();
        Set<Phi> phiUsers = new HashSet<Phi>();

        DebugData(DebugLocalInfo local) {
            this.local = local;
        }
    }
}

