/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda.kstyle;

import com.android.tools.r8.code.Const16;
import com.android.tools.r8.code.Const4;
import com.android.tools.r8.code.Format22c;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeDirect;
import com.android.tools.r8.code.Iput;
import com.android.tools.r8.code.IputBoolean;
import com.android.tools.r8.code.IputByte;
import com.android.tools.r8.code.IputChar;
import com.android.tools.r8.code.IputObject;
import com.android.tools.r8.code.IputShort;
import com.android.tools.r8.code.IputWide;
import com.android.tools.r8.code.NewInstance;
import com.android.tools.r8.code.ReturnVoid;
import com.android.tools.r8.code.SputObject;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.lambda.CaptureSignature;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.kstyle.KStyleLambdaGroup;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.utils.ThrowingConsumer;

final class KStyleLambdaClassValidator
implements ThrowingConsumer<DexClass, LambdaGroup.LambdaStructureError> {
    private final Kotlin kotlin;
    private final KStyleLambdaGroup group;
    private final AppInfoWithSubtyping appInfo;

    KStyleLambdaClassValidator(Kotlin kotlin, KStyleLambdaGroup group, AppInfoWithSubtyping appInfo) {
        this.kotlin = kotlin;
        this.group = group;
        this.appInfo = appInfo;
    }

    @Override
    public void accept(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        if (!CaptureSignature.getCaptureSignature(lambda2.instanceFields()).equals(this.group.id().capture)) {
            throw new LambdaGroup.LambdaStructureError("capture signature was modified");
        }
        DexEncodedMethod classInitializer = null;
        DexEncodedMethod instanceInitializer = null;
        for (DexEncodedMethod method : lambda2.directMethods()) {
            Code code;
            if (method.isClassInitializer()) {
                code = method.getCode();
                if (!this.group.isStateless()) {
                    throw new LambdaGroup.LambdaStructureError("static initializer on stateful lambda");
                }
                if (classInitializer != null || code == null || !code.isDexCode() || !this.validateStatelessLambdaClassInitializer(lambda2, code.asDexCode())) {
                    throw new LambdaGroup.LambdaStructureError("static initializer code verification failed");
                }
                classInitializer = method;
                continue;
            }
            if (!method.isInstanceInitializer()) continue;
            code = method.getCode();
            if (instanceInitializer != null || code == null || !code.isDexCode() || !this.validateInstanceInitializer(lambda2, code.asDexCode())) {
                throw new LambdaGroup.LambdaStructureError("instance initializer code verification failed");
            }
            instanceInitializer = method;
        }
        if (this.group.isStateless() && classInitializer == null) {
            throw new LambdaGroup.LambdaStructureError("missing static initializer on stateless lambda");
        }
        DexType fakeLambdaGroupType = this.kotlin.factory.createType("L" + this.group.getTypePackage() + "-$$LambdaGroup$XXXX;");
        for (DexEncodedMethod method : lambda2.virtualMethods()) {
            if (method.isInliningCandidate(fakeLambdaGroupType, Inliner.Reason.SIMPLE, this.appInfo)) continue;
            throw new LambdaGroup.LambdaStructureError("method " + method.method.toSourceString() + " is not inline-able into lambda group class");
        }
    }

    private boolean validateInstanceInitializer(DexClass lambda2, Code code) {
        DexEncodedField[] captures = lambda2.instanceFields();
        Instruction[] instructions = code.asDexCode().instructions;
        int index = 0;
        if (instructions.length != captures.length + 3) {
            return false;
        }
        int wideFieldsSeen = 0;
        for (DexEncodedField field : captures) {
            switch (field.field.type.toShorty()) {
                case 'Z': {
                    if (instructions[index] instanceof IputBoolean && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    return false;
                }
                case 'B': {
                    if (instructions[index] instanceof IputByte && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    return false;
                }
                case 'S': {
                    if (instructions[index] instanceof IputShort && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    return false;
                }
                case 'C': {
                    if (instructions[index] instanceof IputChar && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    return false;
                }
                case 'F': 
                case 'I': {
                    if (instructions[index] instanceof Iput && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    return false;
                }
                case 'D': 
                case 'J': {
                    if (!(instructions[index] instanceof IputWide) || instructions[index].getField() != field.field || ((Format22c)instructions[index]).A != index + 1 + wideFieldsSeen) {
                        return false;
                    }
                    ++wideFieldsSeen;
                    break;
                }
                case 'L': {
                    if (instructions[index] instanceof IputObject && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    return false;
                }
                default: {
                    throw new Unreachable();
                }
            }
            ++index;
        }
        if (!(instructions[index] instanceof Const4) && !(instructions[index] instanceof Const16)) {
            return false;
        }
        if (!(instructions[++index] instanceof InvokeDirect) || instructions[index].getMethod() != this.kotlin.functional.lambdaInitializerMethod) {
            return false;
        }
        if (!(instructions[++index] instanceof ReturnVoid)) {
            return false;
        }
        assert (++index == instructions.length);
        return true;
    }

    private boolean validateStatelessLambdaClassInitializer(DexClass lambda2, Code code) {
        assert (this.group.isStateless());
        Instruction[] instructions = code.asDexCode().instructions;
        if (instructions.length != 4) {
            return false;
        }
        if (!(instructions[0] instanceof NewInstance) || ((NewInstance)instructions[0]).getType() != lambda2.type) {
            return false;
        }
        if (!(instructions[1] instanceof InvokeDirect) || !this.isLambdaInitializerMethod(lambda2, instructions[1].getMethod())) {
            return false;
        }
        if (!(instructions[2] instanceof SputObject) || !this.isLambdaSingletonField(lambda2, instructions[2].getField())) {
            return false;
        }
        return instructions[3] instanceof ReturnVoid;
    }

    private boolean isLambdaSingletonField(DexClass lambda2, DexField field) {
        return field.type == lambda2.type && field.clazz == lambda2.type && field.name == this.kotlin.functional.kotlinStyleLambdaInstanceName;
    }

    private boolean isLambdaInitializerMethod(DexClass holder, DexMethod method) {
        return method.holder == holder.type && method.name == this.kotlin.factory.constructorMethodName && method.proto.parameters.isEmpty() && method.proto.returnType == this.kotlin.factory.voidType;
    }
}

