/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.joptsimple.util;

import com.android.tools.r8.joptsimple.ValueConversionException;
import com.android.tools.r8.joptsimple.ValueConverter;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexMatcher
implements ValueConverter<String> {
    private final Pattern pattern;

    public RegexMatcher(String pattern, int flags) {
        this.pattern = Pattern.compile(pattern, flags);
    }

    public static ValueConverter<String> regex(String pattern) {
        return new RegexMatcher(pattern, 0);
    }

    @Override
    public String convert(String value) {
        if (!this.pattern.matcher(value).matches()) {
            throw new ValueConversionException("Value [" + value + "] did not match regex [" + this.pattern.pattern() + ']');
        }
        return value;
    }

    @Override
    public Class<String> valueType() {
        return String.class;
    }

    @Override
    public String valuePattern() {
        return this.pattern.pattern();
    }
}

