/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.NamingLens;
import java.util.Arrays;

public class DexTypeList
extends DexItem
implements Comparable<DexTypeList> {
    private static final DexTypeList theEmptyTypeList = new DexTypeList();
    public final DexType[] values;

    public static DexTypeList empty() {
        return theEmptyTypeList;
    }

    private DexTypeList() {
        this.values = new DexType[0];
    }

    public DexTypeList(DexType[] values) {
        assert (values != null && values.length > 0);
        this.values = values;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        for (DexType type : this.values) {
            type.collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DexTypeList && Arrays.equals(this.values, ((DexTypeList)other).values);
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public int size() {
        return this.values.length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (DexType type : this.values) {
            builder.append(' ').append(type);
        }
        return builder.toString();
    }

    @Override
    public int compareTo(DexTypeList other) {
        for (int i = 0; i <= Math.min(this.values.length, other.values.length); ++i) {
            if (i == this.values.length) {
                return i == other.values.length ? 0 : -1;
            }
            if (i == other.values.length) {
                return 1;
            }
            int result = this.values[i].compareTo(other.values[i]);
            if (result == 0) continue;
            return result;
        }
        throw new Unreachable();
    }

    public int slowCompareTo(DexTypeList other) {
        for (int i = 0; i <= Math.min(this.values.length, other.values.length); ++i) {
            if (i == this.values.length) {
                return i == other.values.length ? 0 : -1;
            }
            if (i == other.values.length) {
                return 1;
            }
            int result = this.values[i].slowCompareTo(other.values[i]);
            if (result == 0) continue;
            return result;
        }
        throw new Unreachable();
    }

    public int slowCompareTo(DexTypeList other, NamingLens namingLens) {
        for (int i = 0; i <= Math.min(this.values.length, other.values.length); ++i) {
            if (i == this.values.length) {
                return i == other.values.length ? 0 : -1;
            }
            if (i == other.values.length) {
                return 1;
            }
            int result = this.values[i].slowCompareTo(other.values[i], namingLens);
            if (result == 0) continue;
            return result;
        }
        throw new Unreachable();
    }
}

