/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfLoad
extends CfInstruction {
    private final int var;
    private final ValueType type;

    public CfLoad(ValueType type, int var) {
        this.var = var;
        this.type = type;
    }

    private int getLoadType() {
        switch (this.type) {
            case OBJECT: {
                return 25;
            }
            case INT: {
                return 21;
            }
            case FLOAT: {
                return 23;
            }
            case LONG: {
                return 22;
            }
            case DOUBLE: {
                return 24;
            }
        }
        throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitVarInsn(this.getLoadType(), this.var);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public ValueType getType() {
        return this.type;
    }

    public int getLocalIndex() {
        return this.var;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        CfState.Slot local = state.read(this.var);
        CfState.Slot stack = state.push(local);
        builder.addMove(local.type, stack.register, local.register);
    }

    @Override
    public boolean emitsIR() {
        return false;
    }
}

