/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.ConstStringJumbo;
import com.android.tools.r8.code.Nop;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.StringUtils;
import java.nio.ShortBuffer;
import java.util.function.BiPredicate;

public abstract class Instruction {
    public static final int[] NO_TARGETS = null;
    public static final int[] EXIT_TARGET = new int[0];
    public int offset;

    Instruction(BytecodeStream stream) {
        this.offset = stream.getOffset() - 1;
    }

    protected Instruction() {
        this.offset = -1;
    }

    static byte readSigned8BitValue(BytecodeStream stream) {
        return (byte)stream.nextByte();
    }

    static short read8BitValue(BytecodeStream stream) {
        return (short)stream.nextByte();
    }

    static short readSigned16BitValue(BytecodeStream stream) {
        return (short)stream.nextShort();
    }

    static char read16BitValue(BytecodeStream stream) {
        return (char)(stream.nextShort() & 0xFFFF);
    }

    static int readSigned32BitValue(BytecodeStream stream) {
        char low = Instruction.read16BitValue(stream);
        char high = Instruction.read16BitValue(stream);
        int result = high << 16 & 0xFFFF0000 | low & 0xFFFF;
        return result;
    }

    static long read32BitValue(BytecodeStream stream) {
        long low = Instruction.read16BitValue(stream);
        long high = Instruction.read16BitValue(stream);
        long result = (high & 0xFFFFL) << 16 | low & 0xFFFFL;
        return result;
    }

    static long read64BitValue(BytecodeStream stream) {
        long low = Instruction.read32BitValue(stream);
        long high = Instruction.read32BitValue(stream);
        long result = high << 32 | low;
        return result;
    }

    protected static short combineBytes(int high, int low) {
        return (short)((high & 0xFF) << 8 | low & 0xFF);
    }

    protected static int makeByte(int high, int low) {
        return (high & 0xF) << 4 | low & 0xF;
    }

    protected void writeFirst(int aa, ShortBuffer dest) {
        dest.put((short)((aa & 0xFF) << 8 | this.getOpcode() & 0xFF));
    }

    protected void writeFirst(int a, int b, ShortBuffer dest) {
        dest.put((short)((a & 0xF) << 12 | (b & 0xF) << 8 | this.getOpcode() & 0xFF));
    }

    protected void write16BitValue(int value, ShortBuffer dest) {
        dest.put((short)value);
    }

    protected void write32BitValue(long value, ShortBuffer dest) {
        dest.put((short)(value & 0xFFFFL));
        dest.put((short)(value >> 16 & 0xFFFFL));
    }

    protected void write64BitValue(long value, ShortBuffer dest) {
        this.write32BitValue(value & 0xFFFFFFFFFFFFFFFFL, dest);
        this.write32BitValue(value >> 32 & 0xFFFFFFFFFFFFFFFFL, dest);
    }

    protected void write16BitReference(IndexedDexItem item, ShortBuffer dest, ObjectToOffsetMapping mapping) {
        int index = item.getOffset(mapping);
        assert (index == (index & 0xFFFF));
        this.write16BitValue(index, dest);
    }

    protected void write32BitReference(IndexedDexItem item, ShortBuffer dest, ObjectToOffsetMapping mapping) {
        this.write32BitValue(item.getOffset(mapping), dest);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public ConstString asConstString() {
        return null;
    }

    public boolean isConstString() {
        return false;
    }

    public ConstStringJumbo asConstStringJumbo() {
        return null;
    }

    public boolean isConstStringJumbo() {
        return false;
    }

    public boolean isSimpleNop() {
        return !this.isPayload() && this instanceof Nop;
    }

    public boolean isPayload() {
        return false;
    }

    public boolean isSwitchPayload() {
        return false;
    }

    public boolean hasPayload() {
        return false;
    }

    public boolean isSwitch() {
        return false;
    }

    public int getPayloadOffset() {
        return 0;
    }

    static String formatOffset(int offset) {
        return StringUtils.hexString(offset, 2);
    }

    static String formatDecimalOffset(int offset) {
        return offset >= 0 ? "+" + offset : Integer.toString(offset);
    }

    String formatRelativeOffset(int offset) {
        return Instruction.formatOffset(this.getOffset() + offset) + " (" + Instruction.formatDecimalOffset(offset) + ")";
    }

    String formatString(String left) {
        StringBuilder builder = new StringBuilder();
        StringUtils.appendLeftPadded(builder, Instruction.formatOffset(this.getOffset()), 6);
        builder.append(": ");
        StringUtils.appendRightPadded(builder, this.getName(), 20);
        builder.append(left == null ? "" : left);
        return builder.toString();
    }

    String formatSmaliString(String left) {
        StringBuilder builder = new StringBuilder();
        builder.append("    ");
        if (left != null) {
            StringUtils.appendRightPadded(builder, this.getSmaliName(), 20);
            builder.append(left);
        } else {
            builder.append(this.getSmaliName());
        }
        return builder.toString();
    }

    public int[] getTargets() {
        return NO_TARGETS;
    }

    public abstract void buildIR(IRBuilder var1);

    public DexCallSite getCallSite() {
        return null;
    }

    public DexMethod getMethod() {
        return null;
    }

    public DexProto getProto() {
        return null;
    }

    public DexField getField() {
        return null;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String getName();

    public abstract String getSmaliName();

    public abstract int getOpcode();

    public abstract int getSize();

    public String toSmaliString(Instruction payloadUser) {
        throw new InternalCompilerError("Instruction " + payloadUser + " is not a payload user");
    }

    public abstract String toSmaliString(ClassNameMapper var1);

    public String toSmaliString() {
        return this.toSmaliString((ClassNameMapper)null);
    }

    public abstract String toString(ClassNameMapper var1);

    public String toString(ClassNameMapper naming, Instruction payloadUser) {
        throw new InternalCompilerError("Instruction " + payloadUser + " is not a payload user");
    }

    public String toString() {
        return this.toString(null);
    }

    public abstract void write(ShortBuffer var1, ObjectToOffsetMapping var2);

    public abstract void collectIndexedItems(IndexedItemCollection var1, DexMethod var2, int var3);

    public boolean equals(Instruction other, BiPredicate<IndexedDexItem, IndexedDexItem> equality) {
        return this.equals(other);
    }

    public void registerUse(UseRegistry registry) {
    }

    public boolean canThrow() {
        return false;
    }
}

