/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import java.util.ArrayList;
import java.util.HashMap;

public class RedundantFieldLoadElimination {
    private final AppInfo appInfo;
    private final DexEncodedMethod method;
    private final IRCode code;
    private final boolean enableWholeProgramOptimizations;
    private final DominatorTree dominatorTree;
    private final HashMap<BasicBlock, HashMap<FieldAndObject, Instruction>> activeInstanceFieldsAtEntry = new HashMap();
    private final HashMap<BasicBlock, HashMap<DexField, Instruction>> activeStaticFieldsAtEntry = new HashMap();
    private HashMap<FieldAndObject, Instruction> activeInstanceFields;
    private HashMap<DexField, Instruction> activeStaticFields;

    public RedundantFieldLoadElimination(AppInfo appInfo, IRCode code, boolean enableWholeProgramOptimizations) {
        this.appInfo = appInfo;
        this.method = code.method;
        this.code = code;
        this.enableWholeProgramOptimizations = enableWholeProgramOptimizations;
        this.dominatorTree = new DominatorTree(code);
    }

    private boolean couldBeVolatile(DexField field) {
        if (!this.enableWholeProgramOptimizations && field.getHolder() != this.method.method.getHolder()) {
            return true;
        }
        DexEncodedField definition = this.appInfo.definitionFor(field);
        return definition == null || definition.accessFlags.isVolatile();
    }

    public void run() {
        for (BasicBlock block : this.dominatorTree.getSortedBlocks()) {
            this.activeInstanceFields = this.activeInstanceFieldsAtEntry.containsKey(block) ? this.activeInstanceFieldsAtEntry.get(block) : new HashMap();
            this.activeStaticFields = this.activeStaticFieldsAtEntry.containsKey(block) ? this.activeStaticFieldsAtEntry.get(block) : new HashMap();
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (instruction.isFieldInstruction()) {
                    DexField field = instruction.asFieldInstruction().getField();
                    if (instruction.isInstancePut() || instruction.isStaticPut()) {
                        this.killActiveFields(instruction.asFieldInstruction());
                    } else if (this.couldBeVolatile(field)) {
                        assert (instruction.isInstanceGet() || instruction.isStaticGet());
                        this.killAllActiveFields();
                    } else {
                        assert (instruction.isInstanceGet() || instruction.isStaticGet());
                        assert (!this.couldBeVolatile(field));
                        if (instruction.isInstanceGet() && !instruction.outValue().hasLocalInfo()) {
                            FieldAndObject fieldAndObject;
                            Value object = instruction.asInstanceGet().object();
                            if (!object.isPhi() && object.definition.isNonNull()) {
                                object = object.definition.asNonNull().src();
                            }
                            if (this.activeInstanceFields.containsKey(fieldAndObject = new FieldAndObject(field, object))) {
                                Instruction active = this.activeInstanceFields.get(fieldAndObject);
                                this.eliminateRedundantRead(it, instruction, active);
                            } else {
                                this.activeInstanceFields.put(fieldAndObject, instruction);
                            }
                        } else if (instruction.isStaticGet() && !instruction.outValue().hasLocalInfo()) {
                            if (this.activeStaticFields.containsKey(field)) {
                                Instruction active = this.activeStaticFields.get(field);
                                this.eliminateRedundantRead(it, instruction, active);
                            } else {
                                this.killActiveFields(instruction.asFieldInstruction());
                                this.activeStaticFields.put(field, instruction);
                            }
                        }
                    }
                }
                if ((!instruction.isMonitor() || !instruction.asMonitor().isEnter()) && !instruction.isInvokeMethod()) continue;
                this.killAllActiveFields();
            }
            this.propagateActiveFieldsFrom(block);
        }
        assert (this.code.isConsistentSSA());
    }

    private void propagateActiveFieldsFrom(BasicBlock block) {
        for (BasicBlock successor : block.getSuccessors()) {
            Instruction exceptionalExit;
            if (successor.getPredecessors().size() != 1) continue;
            if (block.hasCatchSuccessor(successor) && (exceptionalExit = block.exceptionalExit()) != null && exceptionalExit.isFieldInstruction()) {
                this.killActiveFieldsForExceptionalExit(exceptionalExit.asFieldInstruction());
            }
            assert (!this.activeInstanceFieldsAtEntry.containsKey(successor));
            this.activeInstanceFieldsAtEntry.put(successor, new HashMap<FieldAndObject, Instruction>(this.activeInstanceFields));
            assert (!this.activeStaticFieldsAtEntry.containsKey(successor));
            this.activeStaticFieldsAtEntry.put(successor, new HashMap<DexField, Instruction>(this.activeStaticFields));
        }
    }

    private void killAllActiveFields() {
        this.activeInstanceFields.clear();
        this.activeStaticFields.clear();
    }

    private void killActiveFields(FieldInstruction instruction) {
        DexField field = instruction.getField();
        if (instruction.isInstancePut()) {
            ArrayList<FieldAndObject> keysToRemove = new ArrayList<FieldAndObject>();
            for (FieldAndObject key : this.activeInstanceFields.keySet()) {
                if (key.field != field) continue;
                keysToRemove.add(key);
            }
            keysToRemove.forEach(k -> this.activeInstanceFields.remove(k));
        } else if (instruction.isInstanceGet()) {
            Value object = instruction.asInstanceGet().object();
            FieldAndObject fieldAndObject = new FieldAndObject(field, object);
            this.activeInstanceFields.remove(fieldAndObject);
        } else if (instruction.isStaticPut()) {
            if (field.clazz != this.code.method.method.holder) {
                this.activeStaticFields.clear();
            } else {
                this.activeStaticFields.remove(field);
            }
        } else if (instruction.isStaticGet() && field.clazz != this.code.method.method.holder) {
            this.activeStaticFields.clear();
        }
    }

    private void killActiveFieldsForExceptionalExit(FieldInstruction instruction) {
        DexField field = instruction.getField();
        if (instruction.isInstanceGet()) {
            Value object = instruction.asInstanceGet().object();
            FieldAndObject fieldAndObject = new FieldAndObject(field, object);
            this.activeInstanceFields.remove(fieldAndObject);
        } else if (instruction.isStaticGet()) {
            this.activeStaticFields.remove(field);
        }
    }

    private void eliminateRedundantRead(InstructionListIterator it, Instruction redundant, Instruction active) {
        redundant.outValue().replaceUsers(active.outValue());
        it.removeOrReplaceByDebugLocalRead();
        active.outValue().uniquePhiUsers().forEach(Phi::removeTrivialPhi);
    }

    private static class FieldAndObject {
        private final DexField field;
        private final Value object;

        private FieldAndObject(DexField field, Value receiver) {
            this.field = field;
            this.object = receiver;
        }

        public int hashCode() {
            return this.field.hashCode() * 7 + this.object.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof FieldAndObject)) {
                return false;
            }
            FieldAndObject o = (FieldAndObject)other;
            return o.object == this.object && o.field == this.field;
        }
    }
}

