/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.staticizer;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import java.util.Map;

class ClassStaticizerGraphLense
extends GraphLense.NestedGraphLense {
    private final Map<DexEncodedMethod, DexEncodedMethod> staticizedMethods;

    ClassStaticizerGraphLense(GraphLense previous, DexItemFactory factory, BiMap<DexField, DexField> fieldMapping, BiMap<DexMethod, DexMethod> methodMapping, Map<DexEncodedMethod, DexEncodedMethod> encodedMethodMapping) {
        super(ImmutableMap.of(), methodMapping, fieldMapping, fieldMapping.inverse(), methodMapping.inverse(), previous, factory);
        this.staticizedMethods = encodedMethodMapping;
    }

    @Override
    protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, DexEncodedMethod context, Invoke.Type type) {
        if (this.methodMap.get(originalMethod) == newMethod) {
            assert (type == Invoke.Type.VIRTUAL || type == Invoke.Type.DIRECT);
            return Invoke.Type.STATIC;
        }
        return super.mapInvocationType(newMethod, originalMethod, context, type);
    }

    @Override
    public DexEncodedMethod mapDexEncodedMethod(AppInfo appInfo, DexEncodedMethod original) {
        return super.mapDexEncodedMethod(appInfo, this.staticizedMethods.getOrDefault(original, original));
    }
}

