/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.apksig.util.RunnablesExecutor;
import com.android.builder.internal.packaging.ApkFlinger;
import com.android.builder.internal.packaging.ApkFlinger$WhenMappings;
import com.android.builder.internal.packaging.SynchronizedArchive;
import com.android.signflinger.SignedApk;
import com.android.signflinger.SignedApkOptions;
import com.android.tools.build.apkzlib.sign.SigningOptions;
import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.android.zipflinger.Archive;
import com.android.zipflinger.BytesSource;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipArchive;
import com.android.zipflinger.ZipSource;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J6\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001b2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001f2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/builder/internal/packaging/ApkFlinger;", "Lcom/android/tools/build/apkzlib/zfile/ApkCreator;", "creationData", "Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;", "compressionLevel", "", "(Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;I)V", "archive", "Lcom/android/builder/internal/packaging/SynchronizedArchive;", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "kotlin.jvm.PlatformType", "noCompressPredicate", "Lcom/google/common/base/Predicate;", "", "pageAlignPredicate", "subTasks", "", "Ljava/util/concurrent/ForkJoinTask;", "", "close", "deleteFile", "apkPath", "hasPendingChangesWithWait", "", "writeFile", "inputFile", "Ljava/io/File;", "writeZip", "zip", "transform", "Lcom/google/common/base/Function;", "isIgnored", "builder"})
public final class ApkFlinger
implements ApkCreator {
    private final SynchronizedArchive archive;
    private final Predicate<String> noCompressPredicate;
    private final Predicate<String> pageAlignPredicate;
    private final ForkJoinPool forkJoinPool;
    private final List<ForkJoinTask<Unit>> subTasks;
    private final int compressionLevel;

    public void writeZip(@NotNull File zip, @Nullable Function<String, String> transform, @Nullable Predicate<String> isIgnored) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)zip, (String)"zip");
        Preconditions.checkArgument((boolean)zip.isFile(), (String)"!zip.isFile()", (Object[])new Object[0]);
        Predicate predicate = isIgnored;
        if (predicate == null) {
            predicate = writeZip.ignorePredicate.1.INSTANCE;
        }
        Predicate ignorePredicate2 = predicate;
        ZipSource zipSource = new ZipSource(zip);
        Collection entries2 = zipSource.entries().values();
        Iterator iterator = entries2.iterator();
        while (iterator.hasNext()) {
            Object name;
            Entry entry;
            Entry entry2 = entry = (Entry)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)entry2, (String)"entry");
            if (entry2.isDirectory() || ignorePredicate2.apply((Object)entry.getName())) continue;
            Object object = transform;
            if (object == null || (object = (String)object.apply((Object)entry.getName())) == null) {
                object = entry.getName();
            }
            Object object2 = name = object;
            Intrinsics.checkExpressionValueIsNotNull(object2, (String)"name");
            if (StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)"../", (boolean)false, (int)2, null)) {
                throw (Throwable)new InvalidPathException((String)name, "Entry name contains invalid characters");
            }
            Source zipSourceEntry = zipSource.select(entry.getName(), name);
            if (entry.isCompressed()) continue;
            if (this.pageAlignPredicate.apply(name)) {
                zipSourceEntry.align(4096L);
                continue;
            }
            zipSourceEntry.align(4L);
        }
        this.archive.add(zipSource);
    }

    public void writeFile(@NotNull File inputFile, @NotNull String apkPath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
        Intrinsics.checkParameterIsNotNull((Object)apkPath, (String)"apkPath");
        Future future = this.forkJoinPool.submit(new Callable<Unit>(this, apkPath, inputFile){
            final /* synthetic */ ApkFlinger this$0;
            final /* synthetic */ String $apkPath;
            final /* synthetic */ File $inputFile;

            public final void call() {
                boolean mayCompress = !ApkFlinger.access$getNoCompressPredicate$p(this.this$0).apply((Object)this.$apkPath);
                BytesSource bytesSource = new BytesSource(Files.readAllBytes(this.$inputFile.toPath()), this.$apkPath, mayCompress ? ApkFlinger.access$getCompressionLevel$p(this.this$0) : 0);
                if (!mayCompress) {
                    if (ApkFlinger.access$getPageAlignPredicate$p(this.this$0).apply((Object)this.$apkPath)) {
                        bytesSource.align(4096L);
                    } else {
                        bytesSource.align(4L);
                    }
                }
                ApkFlinger.access$getArchive$p(this.this$0).add(bytesSource);
            }
            {
                this.this$0 = apkFlinger;
                this.$apkPath = string;
                this.$inputFile = file;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)future, (String)"forkJoinPool.submit(\n   \u2026          }\n            )");
        this.subTasks.add((ForkJoinTask<Unit>)future);
    }

    public void deleteFile(@NotNull String apkPath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)apkPath, (String)"apkPath");
        this.archive.delete(apkPath);
    }

    public boolean hasPendingChangesWithWait() throws IOException {
        throw (Throwable)new RuntimeException("not implemented");
    }

    public void close() throws IOException {
        Iterable $this$forEach$iv = this.subTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForkJoinTask it = (ForkJoinTask)element$iv;
            boolean bl = false;
            it.join();
        }
        this.archive.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ApkFlinger(@NotNull ApkCreatorFactory.CreationData creationData, int compressionLevel) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)creationData, (String)"creationData");
        this.compressionLevel = compressionLevel;
        this.forkJoinPool = ForkJoinPool.commonPool();
        ApkFlinger apkFlinger = this;
        boolean bl = false;
        apkFlinger.subTasks = list = (List)new ArrayList();
        NativeLibrariesPackagingMode nativeLibrariesPackagingMode = creationData.getNativeLibrariesPackagingMode();
        if (nativeLibrariesPackagingMode == null) throw (Throwable)((Object)new AssertionError());
        switch (ApkFlinger$WhenMappings.$EnumSwitchMapping$0[nativeLibrariesPackagingMode.ordinal()]) {
            case 1: {
                Predicate predicate = creationData.getNoCompressPredicate();
                Intrinsics.checkExpressionValueIsNotNull((Object)predicate, (String)"creationData.noCompressPredicate");
                this.noCompressPredicate = predicate;
                this.pageAlignPredicate = 1.INSTANCE;
                break;
            }
            case 2: {
                final Predicate baseNoCompressPredicate = creationData.getNoCompressPredicate();
                this.noCompressPredicate = (Predicate)new Predicate<String>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(@Nullable String name) {
                        if (baseNoCompressPredicate.apply((Object)name)) return true;
                        String string = name;
                        if (string == null) return false;
                        boolean bl = StringsKt.endsWith$default((String)string, (String)".so", (boolean)false, (int)2, null);
                        if (!bl) return false;
                        return true;
                    }
                };
                this.pageAlignPredicate = 3.INSTANCE;
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError());
            }
        }
        SigningOptions signingOptions = (SigningOptions)creationData.getSigningOptions().orNull();
        if (signingOptions == null) {
            this.archive = new SynchronizedArchive((Archive)new ZipArchive(creationData.getApkPath()));
            return;
        } else {
            SignedApkOptions.Builder builder = new SignedApkOptions.Builder().setCertificates((List)signingOptions.getCertificates()).setMinSdkVersion(signingOptions.getMinSdkVersion()).setPrivateKey(signingOptions.getKey()).setV1Enabled(signingOptions.isV1SigningEnabled()).setV2Enabled(signingOptions.isV2SigningEnabled());
            String string = creationData.getCreatedBy();
            if (string == null) {
                string = "Generated-by-ADT";
            }
            SignedApkOptions.Builder signedApkOptionsBuilder = builder.setV1CreatedBy(string).setV1TrustManifest(creationData.isIncremental());
            if (signingOptions.getExecutor() != null) {
                RunnablesExecutor runnablesExecutor = signingOptions.getExecutor();
                if (runnablesExecutor == null) {
                    Intrinsics.throwNpe();
                }
                signedApkOptionsBuilder.setExecutor(runnablesExecutor);
            }
            this.archive = new SynchronizedArchive((Archive)new SignedApk(creationData.getApkPath(), signedApkOptionsBuilder.build()));
        }
    }

    public static final /* synthetic */ Predicate access$getNoCompressPredicate$p(ApkFlinger $this) {
        return $this.noCompressPredicate;
    }

    public static final /* synthetic */ int access$getCompressionLevel$p(ApkFlinger $this) {
        return $this.compressionLevel;
    }

    public static final /* synthetic */ Predicate access$getPageAlignPredicate$p(ApkFlinger $this) {
        return $this.pageAlignPredicate;
    }

    public static final /* synthetic */ SynchronizedArchive access$getArchive$p(ApkFlinger $this) {
        return $this.archive;
    }
}

