/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.CombinedInputStream;
import com.android.builder.merge.DuplicateRelativeFileException;
import com.android.builder.merge.StreamMergeAlgorithm;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.InputStream;
import java.util.function.Function;

public final class StreamMergeAlgorithms {
    private StreamMergeAlgorithms() {
    }

    public static StreamMergeAlgorithm pickFirst() {
        return (path, from, closer) -> {
            Preconditions.checkArgument((!from.isEmpty() ? 1 : 0) != 0, (Object)"from.isEmpty()");
            from.forEach(arg_0 -> ((Closer)closer).register(arg_0));
            return (InputStream)from.get(0);
        };
    }

    public static StreamMergeAlgorithm concat() {
        return (path, from, closer) -> {
            CombinedInputStream mergedStream = new CombinedInputStream(from, true);
            closer.register((Closeable)mergedStream);
            return mergedStream;
        };
    }

    public static StreamMergeAlgorithm acceptOnlyOne() {
        return (path, from, closer) -> {
            Preconditions.checkArgument((!from.isEmpty() ? 1 : 0) != 0, (Object)"from.isEmpty()");
            from.forEach(arg_0 -> ((Closer)closer).register(arg_0));
            if (from.size() > 1) {
                StringBuilder messageBuilder = new StringBuilder();
                messageBuilder.append("More than one file was found with OS independent path '");
                messageBuilder.append(path);
                messageBuilder.append("'.");
                if (path.endsWith(".so")) {
                    messageBuilder.append(" If you are using jniLibs and CMake IMPORTED targets, see ");
                    messageBuilder.append("https://developer.android.com/studio/preview/features#automatic_packaging_of_prebuilt_dependencies_used_by_cmake");
                }
                throw new DuplicateRelativeFileException(messageBuilder.toString());
            }
            return (InputStream)from.get(0);
        };
    }

    public static StreamMergeAlgorithm select(Function<String, StreamMergeAlgorithm> select) {
        return (path, from, closer) -> {
            StreamMergeAlgorithm algorithm = (StreamMergeAlgorithm)select.apply(path);
            assert (algorithm != null);
            return algorithm.merge(path, from, closer);
        };
    }
}

