/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.FixedSizeList;
import com.android.dx.util.IntList;
import com.android.dx.util.LabeledItem;
import java.util.Arrays;

public class LabeledList
extends FixedSizeList {
    private final IntList labelToIndex;

    public LabeledList(int size) {
        super(size);
        this.labelToIndex = new IntList(size);
    }

    public LabeledList(LabeledList old) {
        super(old.size());
        this.labelToIndex = old.labelToIndex.mutableCopy();
        int sz = old.size();
        for (int i4 = 0; i4 < sz; ++i4) {
            Object one = old.get0(i4);
            if (one == null) continue;
            this.set0(i4, one);
        }
    }

    public final int getMaxLabel() {
        int i4;
        int sz = this.labelToIndex.size();
        for (i4 = sz - 1; i4 >= 0 && this.labelToIndex.get(i4) < 0; --i4) {
        }
        int newSize = i4 + 1;
        this.labelToIndex.shrink(newSize);
        return newSize;
    }

    private void removeLabel(int oldLabel) {
        this.labelToIndex.set(oldLabel, -1);
    }

    private void addLabelIndex(int label, int index) {
        int origSz = this.labelToIndex.size();
        for (int i4 = 0; i4 <= label - origSz; ++i4) {
            this.labelToIndex.add(-1);
        }
        this.labelToIndex.set(label, index);
    }

    public final int indexOfLabel(int label) {
        if (label >= this.labelToIndex.size()) {
            return -1;
        }
        return this.labelToIndex.get(label);
    }

    public final int[] getLabelsInOrder() {
        int sz = this.size();
        int[] result = new int[sz];
        for (int i4 = 0; i4 < sz; ++i4) {
            LabeledItem li = (LabeledItem)this.get0(i4);
            if (li == null) {
                throw new NullPointerException("null at index " + i4);
            }
            result[i4] = li.getLabel();
        }
        Arrays.sort(result);
        return result;
    }

    @Override
    public void shrinkToFit() {
        super.shrinkToFit();
        this.rebuildLabelToIndex();
    }

    private void rebuildLabelToIndex() {
        int szItems = this.size();
        for (int i4 = 0; i4 < szItems; ++i4) {
            LabeledItem li = (LabeledItem)this.get0(i4);
            if (li == null) continue;
            this.labelToIndex.set(li.getLabel(), i4);
        }
    }

    protected void set(int n4, LabeledItem item) {
        LabeledItem old = (LabeledItem)this.getOrNull0(n4);
        this.set0(n4, item);
        if (old != null) {
            this.removeLabel(old.getLabel());
        }
        if (item != null) {
            this.addLabelIndex(item.getLabel(), n4);
        }
    }
}

