/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.SdkConstants;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class ShaderProcessor
implements DirectoryWalker.FileAction {
    public static final String EXT_VERT = "vert";
    public static final String EXT_TESC = "tesc";
    public static final String EXT_TESE = "tese";
    public static final String EXT_GEOM = "geom";
    public static final String EXT_FRAG = "frag";
    public static final String EXT_COMP = "comp";
    private final WorkerExecutorFacade workers;
    private File mNdkLocation;
    private File mSourceFolder;
    private final File mOutputDir;
    private List<String> mDefaultArgs;
    private Map<String, List<String>> mScopedArgs;
    private final ProcessExecutor mProcessExecutor;
    private final ProcessOutputHandler mProcessOutputHandler;
    private File mGlslcLocation;

    public ShaderProcessor(File ndkLocation, File sourceFolder, File outputDir, List<String> defaultArgs, Map<String, List<String>> scopedArgs, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, WorkerExecutorFacade workers) {
        this.mNdkLocation = ndkLocation;
        this.mSourceFolder = sourceFolder;
        this.mOutputDir = new File(outputDir, "shaders");
        this.mDefaultArgs = defaultArgs;
        this.mScopedArgs = scopedArgs;
        this.mProcessExecutor = processExecutor;
        this.mProcessOutputHandler = processOutputHandler;
        this.workers = workers;
        this.init();
    }

    public void init() {
        if (this.mNdkLocation == null) {
            throw new IllegalStateException("NDK location is missing. It is required to compile shaders.");
        }
        if (this.mNdkLocation == null || !this.mNdkLocation.isDirectory()) {
            throw new IllegalStateException("NDK location does not exist. It is required to compile shaders: " + this.mNdkLocation);
        }
        File glslcRootFolder = new File(this.mNdkLocation, "shader-tools");
        switch (SdkConstants.currentPlatform()) {
            case 3: {
                glslcRootFolder = new File(glslcRootFolder, "darwin-x86_64");
                break;
            }
            case 2: {
                glslcRootFolder = new File(glslcRootFolder, "windows-x86_64");
                if (glslcRootFolder.isDirectory()) break;
                glslcRootFolder = new File(glslcRootFolder, "windows");
                break;
            }
            case 1: {
                glslcRootFolder = new File(glslcRootFolder, "linux-x86_64");
            }
        }
        if (!glslcRootFolder.isDirectory()) {
            throw new IllegalStateException("Missing NDK subfolder: " + glslcRootFolder);
        }
        this.mGlslcLocation = new File(glslcRootFolder, SdkConstants.FN_GLSLC);
        if (!this.mGlslcLocation.isFile()) {
            throw new IllegalStateException("glslc is missing: " + this.mGlslcLocation);
        }
    }

    @Override
    public void call(Path start, Path path) throws IOException {
        ShaderProcessorParams params = new ShaderProcessorParams(this.mSourceFolder, this.mOutputDir, this.mDefaultArgs, this.mScopedArgs, this.mProcessExecutor, this.mProcessOutputHandler, start, path, this.mGlslcLocation);
        if (this.workers == null) {
            try {
                new ShaderProcessorRunnable(params).run();
            }
            catch (Exception e4) {
                throw new IOException(e4);
            }
        } else {
            this.workers.submit(ShaderProcessorRunnable.class, (Serializable)params);
        }
    }

    private static class ShaderProcessorParams
    implements Serializable {
        private final File mSourceFolder;
        private final File mOutputDir;
        private final List<String> mDefaultArgs;
        private final Map<String, List<String>> mScopedArgs;
        private final ProcessExecutor mProcessExecutor;
        private final ProcessOutputHandler mProcessOutputHandler;
        private final Path start;
        private final Path path;
        private final File mGlslcLocation;

        ShaderProcessorParams(File mSourceFolder, File mOutputDir, List<String> mDefaultArgs, Map<String, List<String>> mScopedArgs, ProcessExecutor mProcessExecutor, ProcessOutputHandler mProcessOutputHandler, Path start, Path path, File mGlslcLocation) {
            this.mSourceFolder = mSourceFolder;
            this.mOutputDir = mOutputDir;
            this.mDefaultArgs = mDefaultArgs;
            this.mScopedArgs = mScopedArgs;
            this.mProcessExecutor = mProcessExecutor;
            this.mProcessOutputHandler = mProcessOutputHandler;
            this.start = start;
            this.path = path;
            this.mGlslcLocation = mGlslcLocation;
        }
    }

    private static class ShaderProcessorRunnable
    implements Runnable {
        private final ShaderProcessorParams params;

        @Inject
        ShaderProcessorRunnable(ShaderProcessorParams params) {
            this.params = params;
        }

        private List<String> getArgs(String relativePath) {
            int pos = relativePath.indexOf(File.separatorChar);
            if (pos == -1) {
                return this.params.mDefaultArgs;
            }
            String key = relativePath.substring(0, pos);
            List args = (List)this.params.mScopedArgs.get(key);
            if (args != null) {
                return args;
            }
            return this.params.mDefaultArgs;
        }

        @Override
        public void run() {
            ProcessInfoBuilder builder = new ProcessInfoBuilder();
            builder.setExecutable(this.params.mGlslcLocation);
            builder.addArgs("-I", this.params.mSourceFolder.getPath());
            String relativePath = FileUtils.relativePath((File)this.params.path.toFile(), (File)this.params.start.toFile());
            File destFile = new File(this.params.mOutputDir, relativePath + ".spv");
            builder.addArgs(this.getArgs(relativePath));
            builder.addArgs(this.params.path.toString());
            builder.addArgs("-o", destFile.getPath());
            FileUtils.mkdirs((File)destFile.getParentFile());
            ProcessResult result = this.params.mProcessExecutor.execute(builder.createProcess(), this.params.mProcessOutputHandler);
            try {
                result.rethrowFailure().assertNormalExitValue();
            }
            catch (ProcessException pe) {
                throw new RuntimeException(pe);
            }
        }
    }
}

