/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

public final class Hex {
    private Hex() {
    }

    public static String u8(long v4) {
        char[] result = new char[16];
        for (int i4 = 0; i4 < 16; ++i4) {
            result[15 - i4] = Character.forDigit((int)v4 & 0xF, 16);
            v4 >>= 4;
        }
        return new String(result);
    }

    public static String u4(int v4) {
        char[] result = new char[8];
        for (int i4 = 0; i4 < 8; ++i4) {
            result[7 - i4] = Character.forDigit(v4 & 0xF, 16);
            v4 >>= 4;
        }
        return new String(result);
    }

    public static String u3(int v4) {
        char[] result = new char[6];
        for (int i4 = 0; i4 < 6; ++i4) {
            result[5 - i4] = Character.forDigit(v4 & 0xF, 16);
            v4 >>= 4;
        }
        return new String(result);
    }

    public static String u2(int v4) {
        char[] result = new char[4];
        for (int i4 = 0; i4 < 4; ++i4) {
            result[3 - i4] = Character.forDigit(v4 & 0xF, 16);
            v4 >>= 4;
        }
        return new String(result);
    }

    public static String u2or4(int v4) {
        if (v4 == (char)v4) {
            return Hex.u2(v4);
        }
        return Hex.u4(v4);
    }

    public static String u1(int v4) {
        char[] result = new char[2];
        for (int i4 = 0; i4 < 2; ++i4) {
            result[1 - i4] = Character.forDigit(v4 & 0xF, 16);
            v4 >>= 4;
        }
        return new String(result);
    }

    public static String uNibble(int v4) {
        char[] result = new char[]{Character.forDigit(v4 & 0xF, 16)};
        return new String(result);
    }

    public static String s8(long v4) {
        char[] result = new char[17];
        if (v4 < 0L) {
            result[0] = 45;
            v4 = -v4;
        } else {
            result[0] = 43;
        }
        for (int i4 = 0; i4 < 16; ++i4) {
            result[16 - i4] = Character.forDigit((int)v4 & 0xF, 16);
            v4 >>= 4;
        }
        return new String(result);
    }

    public static String s4(int v4) {
        char[] result = new char[9];
        if (v4 < 0) {
            result[0] = 45;
            v4 = -v4;
        } else {
            result[0] = 43;
        }
        for (int i4 = 0; i4 < 8; ++i4) {
            result[8 - i4] = Character.forDigit(v4 & 0xF, 16);
            v4 >>= 4;
        }
        return new String(result);
    }

    public static String s2(int v4) {
        char[] result = new char[5];
        if (v4 < 0) {
            result[0] = 45;
            v4 = -v4;
        } else {
            result[0] = 43;
        }
        for (int i4 = 0; i4 < 4; ++i4) {
            result[4 - i4] = Character.forDigit(v4 & 0xF, 16);
            v4 >>= 4;
        }
        return new String(result);
    }

    public static String s1(int v4) {
        char[] result = new char[3];
        if (v4 < 0) {
            result[0] = 45;
            v4 = -v4;
        } else {
            result[0] = 43;
        }
        for (int i4 = 0; i4 < 2; ++i4) {
            result[2 - i4] = Character.forDigit(v4 & 0xF, 16);
            v4 >>= 4;
        }
        return new String(result);
    }

    public static String dump(byte[] arr, int offset, int length, int outOffset, int bpl, int addressLength) {
        int end = offset + length;
        if ((offset | length | end) < 0 || end > arr.length) {
            throw new IndexOutOfBoundsException("arr.length " + arr.length + "; " + offset + "..!" + end);
        }
        if (outOffset < 0) {
            throw new IllegalArgumentException("outOffset < 0");
        }
        if (length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length * 4 + 6);
        boolean bol = true;
        int col = 0;
        while (length > 0) {
            if (col == 0) {
                String astr;
                switch (addressLength) {
                    case 2: {
                        astr = Hex.u1(outOffset);
                        break;
                    }
                    case 4: {
                        astr = Hex.u2(outOffset);
                        break;
                    }
                    case 6: {
                        astr = Hex.u3(outOffset);
                        break;
                    }
                    default: {
                        astr = Hex.u4(outOffset);
                    }
                }
                sb.append(astr);
                sb.append(": ");
            } else if (!(col & true)) {
                sb.append(' ');
            }
            sb.append(Hex.u1(arr[offset]));
            ++outOffset;
            ++offset;
            if (++col == bpl) {
                sb.append('\n');
                col = 0;
            }
            --length;
        }
        if (col != 0) {
            sb.append('\n');
        }
        return sb.toString();
    }
}

