/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.BytecodeRClassWriterKt;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.RGeneration;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.ManifestData;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001ab\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001aZ\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0001\u001a\u0016\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0019"}, d2={"processLibraryMainSymbolTable", "", "librarySymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "depSymbolTables", "", "mainPackageName", "", "manifestFile", "Ljava/io/File;", "rClassOutputJar", "symbolFileOut", "platformSymbols", "nonTransitiveRClass", "", "generateDependencyRClasses", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "finalPackageName", "Ljava/nio/file/Path;", "writePublicTxtFile", "table", "writer", "Ljava/io/Writer;", "writeSymbolListWithPackageName", "builder"})
@JvmName(name="SymbolExportUtils")
public final class SymbolExportUtils {
    public static final void processLibraryMainSymbolTable(@NotNull SymbolTable librarySymbols, @NotNull List<? extends SymbolTable> depSymbolTables, @Nullable String mainPackageName, @NotNull File manifestFile, @Nullable File rClassOutputJar, @Nullable File symbolFileOut, @NotNull SymbolTable platformSymbols, boolean nonTransitiveRClass, boolean generateDependencyRClasses, @NotNull IdProvider idProvider) throws IOException {
        Intrinsics.checkNotNullParameter((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkNotNullParameter(depSymbolTables, (String)"depSymbolTables");
        Intrinsics.checkNotNullParameter((Object)manifestFile, (String)"manifestFile");
        Intrinsics.checkNotNullParameter((Object)platformSymbols, (String)"platformSymbols");
        Intrinsics.checkNotNullParameter((Object)idProvider, (String)"idProvider");
        String string = mainPackageName;
        String finalPackageName = string == null ? SymbolUtils.getPackageNameFromManifest((ManifestData)SymbolUtils.parseManifest((File)manifestFile)) : string;
        Comparable<File> comparable = symbolFileOut;
        List<SymbolTable> tablesToWrite = SymbolExportUtils.processLibraryMainSymbolTable(finalPackageName, librarySymbols, depSymbolTables, platformSymbols, nonTransitiveRClass, comparable == null ? null : comparable.toPath(), generateDependencyRClasses, idProvider);
        if (rClassOutputJar != null) {
            FileUtils.deleteIfExists((File)rClassOutputJar);
            Iterable iterable = tablesToWrite;
            comparable = rClassOutputJar.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"rClassOutputJar.toPath()");
            BytecodeRClassWriterKt.exportToCompiledJava$default(iterable, (Path)comparable, false, 4, null);
        }
    }

    @VisibleForTesting
    @NotNull
    public static final List<SymbolTable> processLibraryMainSymbolTable(@NotNull String finalPackageName, @NotNull SymbolTable librarySymbols, @NotNull List<? extends SymbolTable> depSymbolTables, @NotNull SymbolTable platformSymbols, boolean nonTransitiveRClass, @Nullable Path symbolFileOut, boolean generateDependencyRClasses, @NotNull IdProvider idProvider) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)finalPackageName, (String)"finalPackageName");
        Intrinsics.checkNotNullParameter((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkNotNullParameter(depSymbolTables, (String)"depSymbolTables");
        Intrinsics.checkNotNullParameter((Object)platformSymbols, (String)"platformSymbols");
        Intrinsics.checkNotNullParameter((Object)idProvider, (String)"idProvider");
        SymbolTable allSymbols = SymbolUtils.mergeAndRenumberSymbols((String)finalPackageName, (SymbolTable)librarySymbols, (Collection)depSymbolTables, (SymbolTable)platformSymbols, (IdProvider)idProvider);
        SymbolTable mainSymbolTable = nonTransitiveRClass ? allSymbols.filter(librarySymbols) : allSymbols;
        Iterable<Path> iterable2 = symbolFileOut;
        if (iterable2 != null) {
            Path path = iterable2;
            boolean bl2 = false;
            boolean bl3 = false;
            Path it2 = path;
            boolean bl4 = false;
            Files.createDirectories(it2.getParent(), new FileAttribute[0]);
            SymbolIo.writeForAar((SymbolTable)mainSymbolTable, (Path)it2);
        }
        if (generateDependencyRClasses) {
            iterable2 = RGeneration.generateAllSymbolTablesToWrite((SymbolTable)allSymbols, (SymbolTable)mainSymbolTable, (Collection)depSymbolTables);
            Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"{\n        RGeneration.generateAllSymbolTablesToWrite(allSymbols, mainSymbolTable, depSymbolTables)\n    }");
            iterable = iterable2;
        } else {
            iterable2 = ImmutableList.of((Object)mainSymbolTable);
            Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"{\n        ImmutableList.of(mainSymbolTable)\n    }");
            iterable = (List)iterable2;
        }
        return iterable;
    }

    public static /* synthetic */ List processLibraryMainSymbolTable$default(String string, SymbolTable symbolTable, List list, SymbolTable symbolTable2, boolean bl2, Path path, boolean bl3, IdProvider idProvider, int n12, Object object) {
        if ((n12 & 0x40) != 0) {
            bl3 = true;
        }
        if ((n12 & 0x80) != 0) {
            idProvider = IdProvider.Companion.sequential();
        }
        return SymbolExportUtils.processLibraryMainSymbolTable(string, symbolTable, list, symbolTable2, bl2, path, bl3, idProvider);
    }

    public static final void writeSymbolListWithPackageName(@NotNull SymbolTable table, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.write(table.getTablePackage());
        writer.write(10);
        ResourceType[] resourceTypeArray = ResourceType.values();
        int n12 = 0;
        int n13 = resourceTypeArray.length;
        while (n12 < n13) {
            ResourceType resourceType = resourceTypeArray[n12];
            ++n12;
            List symbols = table.getSymbolByResourceType(resourceType);
            for (Symbol symbol : symbols) {
                writer.write(resourceType.getName());
                writer.write(32);
                writer.write(symbol.getCanonicalName());
                if (symbol instanceof Symbol.StyleableSymbol) {
                    for (String child : symbol.getChildren()) {
                        writer.write(32);
                        writer.write(child);
                    }
                }
                writer.write(10);
            }
        }
    }

    public static final void writePublicTxtFile(@NotNull SymbolTable table, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        ResourceType[] resourceTypeArray = ResourceType.values();
        int n12 = 0;
        int n13 = resourceTypeArray.length;
        while (n12 < n13) {
            ResourceType resType = resourceTypeArray[n12];
            ++n12;
            List symbols = table.getSymbolByResourceType(resType);
            for (Symbol s12 : symbols) {
                writer.write(s12.getResourceType().getName());
                writer.write(32);
                writer.write(s12.getCanonicalName());
                writer.write(10);
            }
        }
    }
}

