/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.DelegateIncrementalFileMergerInput;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.ide.common.resources.FileStatus;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.function.Predicate;

public class FilterIncrementalFileMergerInput
extends DelegateIncrementalFileMergerInput {
    private final Predicate<String> pathsAccepted;

    public FilterIncrementalFileMergerInput(IncrementalFileMergerInput input, Predicate<String> pathsAccepted) {
        super(input);
        this.pathsAccepted = pathsAccepted;
    }

    @Override
    public ImmutableSet<String> getUpdatedPaths() {
        return (ImmutableSet)super.getUpdatedPaths().stream().filter(this.pathsAccepted).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ImmutableSet<String> getAllPaths() {
        return (ImmutableSet)super.getAllPaths().stream().filter(this.pathsAccepted).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public FileStatus getFileStatus(String path) {
        if (this.pathsAccepted.test(path)) {
            return super.getFileStatus(path);
        }
        return null;
    }

    @Override
    public InputStream openPath(String path) {
        Preconditions.checkArgument((boolean)this.pathsAccepted.test(path));
        return super.openPath(path);
    }
}

