/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.sdk;

import com.android.SdkConstants;
import com.android.repository.api.RemotePackage;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;

public final class LicenceNotAcceptedException
extends Exception {
    private final ImmutableList<RemotePackage> affectedPackages;

    public LicenceNotAcceptedException(Path sdkLocation, List<RemotePackage> affectedPackages) {
        super(LicenceNotAcceptedException.getMessage(sdkLocation, affectedPackages));
        this.affectedPackages = ImmutableList.copyOf(affectedPackages);
    }

    private static String getMessage(Path sdkLocation, List<RemotePackage> affectedPackages) {
        StringBuilder builder = new StringBuilder("Failed to install the following Android SDK packages as some licences have not been accepted.\n");
        for (RemotePackage affectedPackage : affectedPackages) {
            builder.append("   ").append(affectedPackage.getPath()).append(' ').append(affectedPackage.getDisplayName()).append('\n');
        }
        String sdkManagerCommand = "sdkmanager" + (SdkConstants.currentPlatform() != 2 ? ".bat" : "");
        builder.append("To build this project, accept the SDK license agreements and install the missing components using the Android Studio SDK Manager.\nAll licenses can be accepted using the sdkmanager command line tool:\n" + sdkManagerCommand + " --licenses\nOr, to transfer the license agreements from one workstation to another, see https://developer.android.com/studio/intro/update.html#download-with-gradle\n\nUsing Android SDK: ");
        builder.append(sdkLocation.toString());
        return builder.toString();
    }

    public List<RemotePackage> getAffectedPackages() {
        return this.affectedPackages;
    }
}

