/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.D8;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationWriter;
import shadow.bundletool.com.android.tools.r8.dex.Marker;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.LazyLoadedDexApplication;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionUtils;
import shadow.bundletool.com.android.tools.r8.utils.FeatureClassMapping;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

@Keep
public final class DexSplitterHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(D8Command command, FeatureClassMapping featureClassMapping, String output, String proguardMap) throws CompilationFailedException {
        ExecutorService executor = ThreadUtils.getExecutorService(-1);
        try {
            ExceptionUtils.withCompilationHandler(command.getReporter(), () -> DexSplitterHelper.run(command, featureClassMapping, output, proguardMap, executor));
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(D8Command command, FeatureClassMapping featureClassMapping, String output, String proguardMap, ExecutorService executor) throws IOException {
        InternalOptions options = command.getInternalOptions();
        options.enableDesugaring = false;
        options.enableMainDexListCheck = false;
        options.ignoreMainDexMissingClasses = true;
        options.minimalMainDex = false;
        assert (!options.isMinifying());
        options.enableInlining = false;
        options.outline.enabled = false;
        try {
            Timing timing = new Timing("DexSplitter");
            DexApplication app = new ApplicationReader(command.getInputApp(), options, timing).read(null, executor);
            List<Marker> markers = app.dexItemFactory.extractMarkers();
            ClassNameMapper mapper = null;
            if (proguardMap != null) {
                mapper = ClassNameMapper.mapperFromFile(Paths.get(proguardMap, new String[0]));
            }
            Map<String, LazyLoadedDexApplication.Builder> applications = DexSplitterHelper.getDistribution(app, featureClassMapping, mapper);
            for (Map.Entry<String, LazyLoadedDexApplication.Builder> entry : applications.entrySet()) {
                DexApplication featureApp = entry.getValue().build();
                featureApp.dexItemFactory.resetSortedIndices();
                assert (!options.hasMethodsFilter());
                AppInfo appInfo = new AppInfo(featureApp);
                featureApp = D8.optimize(featureApp, appInfo, options, timing, executor);
                Path outputDir = Paths.get(output, new String[0]).resolve(entry.getKey());
                if (!Files.exists(outputDir, new LinkOption[0])) {
                    Files.createDirectory(outputDir, new FileAttribute[0]);
                }
                DexIndexedConsumer.DirectoryConsumer consumer = new DexIndexedConsumer.DirectoryConsumer(outputDir);
                try {
                    new ApplicationWriter(featureApp, null, options, markers, GraphLense.getIdentityLense(), NamingLens.getIdentityLens(), null, consumer).write(executor);
                    options.printWarnings();
                }
                finally {
                    consumer.finished(options.reporter);
                }
            }
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        catch (FeatureClassMapping.FeatureMappingException e) {
            options.reporter.error(e.getMessage());
        }
        finally {
            options.signalFinishedToConsumers();
        }
    }

    private static Map<String, LazyLoadedDexApplication.Builder> getDistribution(DexApplication app, FeatureClassMapping featureClassMapping, ClassNameMapper mapper) throws FeatureClassMapping.FeatureMappingException {
        HashMap<String, LazyLoadedDexApplication.Builder> applications = new HashMap<String, LazyLoadedDexApplication.Builder>();
        for (DexProgramClass clazz : app.classes()) {
            String clazzName = mapper != null ? mapper.deobfuscateClassName(clazz.toString()) : clazz.toString();
            String feature = featureClassMapping.featureForClass(clazzName);
            LazyLoadedDexApplication.Builder featureApplication = (LazyLoadedDexApplication.Builder)applications.get(feature);
            if (featureApplication == null) {
                featureApplication = DexApplication.builder(app.options, app.timing);
                if (feature.equals(featureClassMapping.getBaseName())) {
                    featureApplication.addToMainDexList(app.mainDexList);
                }
                applications.put(feature, featureApplication);
            }
            featureApplication.addProgramClass(clazz);
        }
        return applications;
    }

    public static void runD8ForTesting(D8Command command, boolean dontCreateMarkerInD8) throws CompilationFailedException {
        InternalOptions options = command.getInternalOptions();
        options.testing.dontCreateMarkerInD8 = dontCreateMarkerInD8;
        D8.runForTesting(command.getInputApp(), options);
    }
}

