/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.StringResource;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstNull;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfThrow;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.dex.Marker;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.CfCode;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DirectMappedDexApplication;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.LazyLoadedDexApplication;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryConfiguration;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryConfigurationParser;
import shadow.bundletool.com.android.tools.r8.jar.CfApplicationWriter;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class GenerateLintFiles {
    private static final String ANDROID_JAR_PATTERN = "third_party/android_jar/lib-v%d/android.jar";
    private final DexItemFactory factory = new DexItemFactory();
    private final Reporter reporter = new Reporter();
    private final InternalOptions options = new InternalOptions(this.factory, this.reporter);
    private final DesugaredLibraryConfiguration desugaredLibraryConfiguration;
    private final String outputDirectory;
    private final Set<DexMethod> parallelMethods = Sets.newIdentityHashSet();

    private GenerateLintFiles(String desugarConfigurationPath, String outputDirectory) {
        this.desugaredLibraryConfiguration = this.readDesugaredLibraryConfiguration(desugarConfigurationPath);
        this.outputDirectory = outputDirectory.endsWith("/") ? outputDirectory : outputDirectory + File.separator;
        DexType streamType = this.factory.createType(this.factory.createString("Ljava/util/stream/Stream;"));
        DexMethod parallelMethod = this.factory.createMethod(this.factory.collectionType, this.factory.createProto(streamType, new DexType[0]), this.factory.createString("parallelStream"));
        this.parallelMethods.add(parallelMethod);
        DexType baseStreamType = this.factory.createType(this.factory.createString("Ljava/util/stream/BaseStream;"));
        for (String typePrefix : new String[]{"Base", "Double", "Int", "Long"}) {
            streamType = this.factory.createType(this.factory.createString("Ljava/util/stream/" + typePrefix + "Stream;"));
            parallelMethod = this.factory.createMethod(streamType, this.factory.createProto(streamType, new DexType[0]), this.factory.createString("parallel"));
            this.parallelMethods.add(parallelMethod);
            parallelMethod = this.factory.createMethod(streamType, this.factory.createProto(baseStreamType, new DexType[0]), this.factory.createString("parallel"));
            this.parallelMethods.add(parallelMethod);
        }
    }

    private static Path getAndroidJarPath(AndroidApiLevel apiLevel) {
        String jar = String.format(ANDROID_JAR_PATTERN, apiLevel.getLevel());
        return Paths.get(jar, new String[0]);
    }

    private DesugaredLibraryConfiguration readDesugaredLibraryConfiguration(String desugarConfigurationPath) {
        return new DesugaredLibraryConfigurationParser(this.factory, this.reporter, false, AndroidApiLevel.B.getLevel()).parse(StringResource.fromFile(Paths.get(desugarConfigurationPath, new String[0])));
    }

    private CfCode buildEmptyThrowingCfCode(DexMethod method) {
        CfInstruction[] insn = new CfInstruction[]{new CfConstNull(), new CfThrow()};
        return new CfCode(method.holder, 1, method.proto.parameters.size() + 1, Arrays.asList(insn), Collections.emptyList(), Collections.emptyList());
    }

    private void addMethodsToHeaderJar(DexApplication.Builder builder, DexClass clazz, List<DexEncodedMethod> methods) {
        if (methods.size() == 0) {
            return;
        }
        ArrayList<DexEncodedMethod> directMethods = new ArrayList<DexEncodedMethod>();
        ArrayList<DexEncodedMethod> virtualMethods = new ArrayList<DexEncodedMethod>();
        for (DexEncodedMethod method : methods) {
            assert (method.method.holder == clazz.type);
            CfCode code = null;
            if (!method.accessFlags.isAbstract()) {
                code = this.buildEmptyThrowingCfCode(method.method);
            }
            DexEncodedMethod throwingMethod = new DexEncodedMethod(method.method, method.accessFlags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)code, 50);
            if (method.accessFlags.isStatic()) {
                directMethods.add(throwingMethod);
                continue;
            }
            virtualMethods.add(throwingMethod);
        }
        DexEncodedMethod[] directMethodsArray = new DexEncodedMethod[directMethods.size()];
        DexEncodedMethod[] virtualMethodsArray = new DexEncodedMethod[virtualMethods.size()];
        directMethods.toArray(directMethodsArray);
        virtualMethods.toArray(virtualMethodsArray);
        assert (!this.options.encodeChecksums);
        DexProgramClass.ChecksumSupplier checksumSupplier = DexProgramClass::invalidChecksumRequest;
        DexProgramClass programClass = new DexProgramClass(clazz.type, null, Origin.unknown(), clazz.accessFlags, clazz.superType, clazz.interfaces, null, null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, directMethodsArray, virtualMethodsArray, false, checksumSupplier);
        builder.addProgramClass(programClass);
    }

    private SupportedMethods collectSupportedMethods(AndroidApiLevel compilationApiLevel, Predicate<DexEncodedMethod> supported) throws IOException, ExecutionException {
        AndroidApp library = AndroidApp.builder().addLibraryFiles(GenerateLintFiles.getAndroidJarPath(compilationApiLevel)).build();
        DirectMappedDexApplication dexApplication = new ApplicationReader(library, this.options, new Timing()).read().toDirect();
        Set<DexClass> classesWithAllMethodsSupported = Sets.newIdentityHashSet();
        LinkedHashMap<DexClass, List<DexEncodedMethod>> supportedMethods = new LinkedHashMap<DexClass, List<DexEncodedMethod>>();
        for (DexLibraryClass clazz : dexApplication.libraryClasses()) {
            String className = clazz.toSourceString();
            for (String prefix : this.desugaredLibraryConfiguration.getRewritePrefix().keySet()) {
                if (!clazz.accessFlags.isPublic() || !className.startsWith(prefix)) continue;
                boolean allMethodsAddad = true;
                for (DexEncodedMethod method : clazz.methods()) {
                    if (supported.test(method)) {
                        supportedMethods.computeIfAbsent(clazz, k -> new ArrayList()).add(method);
                        continue;
                    }
                    allMethodsAddad = false;
                }
                if (!allMethodsAddad) continue;
                classesWithAllMethodsSupported.add(clazz);
            }
            for (DexEncodedMethod method : clazz.methods()) {
                if (!this.desugaredLibraryConfiguration.getRetargetCoreLibMember().keySet().contains(method.method.name) || !this.desugaredLibraryConfiguration.getRetargetCoreLibMember().get(method.method.name).containsKey(clazz.type) || !supported.test(method)) continue;
                supportedMethods.computeIfAbsent(clazz, k -> new ArrayList()).add(method);
            }
            if (!this.desugaredLibraryConfiguration.getEmulateLibraryInterface().containsKey(clazz.type)) continue;
            assert (clazz.isInterface());
            for (DexEncodedMethod method : clazz.methods()) {
                if (!method.isDefaultMethod() && !method.isStatic() || !supported.test(method)) continue;
                supportedMethods.computeIfAbsent(clazz, k -> new ArrayList()).add(method);
            }
        }
        return new SupportedMethods(classesWithAllMethodsSupported, supportedMethods);
    }

    private String lintBaseFileName(AndroidApiLevel compilationApiLevel, AndroidApiLevel minApiLevel) {
        return "desugared_apis_" + compilationApiLevel.getLevel() + "_" + minApiLevel.getLevel();
    }

    private Path lintFile(AndroidApiLevel compilationApiLevel, AndroidApiLevel minApiLevel, String extension) throws Exception {
        Path directory = Paths.get(this.outputDirectory + "compile_api_level_" + compilationApiLevel.getLevel(), new String[0]);
        Files.createDirectories(directory, new FileAttribute[0]);
        return Paths.get(directory + File.separator + this.lintBaseFileName(compilationApiLevel, minApiLevel) + extension, new String[0]);
    }

    private void writeLintFiles(AndroidApiLevel compilationApiLevel, AndroidApiLevel minApiLevel, SupportedMethods supportedMethods) throws Exception {
        ArrayList<String> desugaredApisSignatures = new ArrayList<String>();
        LazyLoadedDexApplication.Builder builder = DexApplication.builder(this.options, new Timing());
        supportedMethods.supportedMethods.forEach((clazz, methods) -> {
            String classBinaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(clazz.type.descriptor.toString());
            if (!supportedMethods.classesWithAllMethodsSupported.contains(clazz)) {
                for (DexEncodedMethod method : methods) {
                    desugaredApisSignatures.add(classBinaryName + '#' + method.method.name + method.method.proto.toDescriptorString());
                }
            } else {
                desugaredApisSignatures.add(classBinaryName);
            }
            this.addMethodsToHeaderJar(builder, (DexClass)clazz, (List<DexEncodedMethod>)methods);
        });
        DexApplication app = ((DexApplication.Builder)builder).build();
        desugaredApisSignatures.sort(Comparator.naturalOrder());
        FileUtils.writeTextFile(this.lintFile(compilationApiLevel, minApiLevel, ".txt"), desugaredApisSignatures);
        AppInfo appInfo = new AppInfo(app);
        AppView<AppInfo> appView = AppView.createForD8(appInfo, this.options);
        CfApplicationWriter writer = new CfApplicationWriter(((DexApplication.Builder)builder).build(), appView, this.options, this.options.getMarker(Marker.Tool.L8), GraphLense.getIdentityLense(), NamingLens.getIdentityLens(), null);
        ClassFileConsumer.ArchiveConsumer consumer = new ClassFileConsumer.ArchiveConsumer(this.lintFile(compilationApiLevel, minApiLevel, ".jar"));
        writer.write(consumer, ThreadUtils.getExecutorService(this.options));
        consumer.finished(this.options.reporter);
    }

    private void generateLintFiles(AndroidApiLevel compilationApiLevel, Predicate<AndroidApiLevel> generateForThisMinApiLevel, BiPredicate<AndroidApiLevel, DexEncodedMethod> supportedForMinApiLevel) throws Exception {
        System.out.print("  - generating for min API:");
        for (AndroidApiLevel minApiLevel : AndroidApiLevel.values()) {
            if (!generateForThisMinApiLevel.test(minApiLevel)) continue;
            System.out.print(" " + (Object)((Object)minApiLevel));
            SupportedMethods supportedMethods = this.collectSupportedMethods(compilationApiLevel, method -> supportedForMinApiLevel.test(minApiLevel, (DexEncodedMethod)method));
            this.writeLintFiles(compilationApiLevel, minApiLevel, supportedMethods);
        }
        System.out.println();
    }

    private void run() throws Exception {
        for (int apiLevel = AndroidApiLevel.Q.getLevel(); apiLevel >= this.desugaredLibraryConfiguration.getRequiredCompilationApiLevel().getLevel(); --apiLevel) {
            System.out.println("Generating lint files for compile API " + apiLevel);
            this.generateLintFiles(AndroidApiLevel.getAndroidApiLevel(apiLevel), minApiLevel -> minApiLevel == AndroidApiLevel.L || minApiLevel == AndroidApiLevel.B, (minApiLevel, method) -> {
                assert (minApiLevel == AndroidApiLevel.L || minApiLevel == AndroidApiLevel.B);
                if (minApiLevel == AndroidApiLevel.L) {
                    return true;
                }
                assert (minApiLevel == AndroidApiLevel.B);
                return !this.parallelMethods.contains(method.method);
            });
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: GenerateLineFiles <desuage configuration> <output directory>");
            System.exit(1);
        }
        new GenerateLintFiles(args[0], args[1]).run();
    }

    public static class SupportedMethods {
        public final Set<DexClass> classesWithAllMethodsSupported;
        public final Map<DexClass, List<DexEncodedMethod>> supportedMethods;

        public SupportedMethods(Set<DexClass> classesWithAllMethodsSupported, Map<DexClass, List<DexEncodedMethod>> supportedMethods) {
            this.classesWithAllMethodsSupported = classesWithAllMethodsSupported;
            this.supportedMethods = supportedMethods;
        }
    }
}

