/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.GenerateMainDexListCommand;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.R8;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppServices;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DirectMappedDexApplication;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.shaking.EnqueuerFactory;
import shadow.bundletool.com.android.tools.r8.shaking.MainDexClasses;
import shadow.bundletool.com.android.tools.r8.shaking.MainDexListBuilder;
import shadow.bundletool.com.android.tools.r8.shaking.RootSetBuilder;
import shadow.bundletool.com.android.tools.r8.shaking.WhyAreYouKeepingConsumer;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.Box;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

@Keep
public class GenerateMainDexList {
    private final Timing timing = new Timing("maindex");
    private final InternalOptions options;

    private GenerateMainDexList(InternalOptions options) {
        this.options = options;
    }

    private List<String> run(AndroidApp app, ExecutorService executor) throws IOException {
        try {
            DirectMappedDexApplication application = new ApplicationReader(app, this.options, this.timing).read(executor).toDirect();
            AppView<AppInfoWithSubtyping> appView = AppView.createForR8(new AppInfoWithSubtyping(application), this.options);
            appView.setAppServices(AppServices.builder(appView).build());
            RootSetBuilder.RootSet mainDexRootSet = new RootSetBuilder(appView, application, this.options.mainDexKeepRules).run(executor);
            GraphConsumer graphConsumer = this.options.mainDexKeptGraphConsumer;
            WhyAreYouKeepingConsumer whyAreYouKeepingConsumer = null;
            if (!mainDexRootSet.reasonAsked.isEmpty()) {
                whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(graphConsumer);
                graphConsumer = whyAreYouKeepingConsumer;
            }
            Enqueuer enqueuer = EnqueuerFactory.createForMainDexTracing(appView, graphConsumer);
            Set<DexProgramClass> liveTypes = enqueuer.traceMainDex(mainDexRootSet, executor, this.timing);
            MainDexClasses mainDexClasses = new MainDexListBuilder(liveTypes, application).run();
            List<String> result = mainDexClasses.getClasses().stream().map(c -> c.toSourceString().replace('.', '/') + ".class").sorted().collect(Collectors.toList());
            if (this.options.mainDexListConsumer != null) {
                this.options.mainDexListConsumer.accept(String.join((CharSequence)"\n", result), this.options.reporter);
                this.options.mainDexListConsumer.finished(this.options.reporter);
            }
            R8.processWhyAreYouKeepingAndCheckDiscarded(mainDexRootSet, () -> {
                ArrayList classes = new ArrayList();
                mainDexClasses.getClasses().forEach(type -> {
                    DexClass clazz = appView.definitionFor((DexType)type);
                    assert (clazz.isProgramClass());
                    classes.add(clazz.asProgramClass());
                });
                return classes;
            }, whyAreYouKeepingConsumer, appView, enqueuer, true, this.options, this.timing, executor);
            return result;
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
    }

    public static List<String> run(GenerateMainDexListCommand command) throws CompilationFailedException {
        ExecutorService executorService = ThreadUtils.getExecutorService(command.getInternalOptions());
        try {
            List<String> list = GenerateMainDexList.run(command, executorService);
            return list;
        }
        finally {
            executorService.shutdown();
        }
    }

    public static List<String> run(GenerateMainDexListCommand command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        Box result = new Box();
        ExceptionUtils.withMainDexListHandler(command.getReporter(), () -> {
            try {
                result.set(new GenerateMainDexList(options).run(app, executor));
            }
            finally {
                executor.shutdown();
            }
        });
        return (List)result.get();
    }

    public static void main(String[] args) throws CompilationFailedException {
        GenerateMainDexListCommand.Builder builder = GenerateMainDexListCommand.parse(args);
        GenerateMainDexListCommand command = (GenerateMainDexListCommand)builder.build();
        if (command.isPrintHelp()) {
            System.out.println(GenerateMainDexListCommand.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("MainDexListGenerator 2.0.23");
            return;
        }
        List<String> result = GenerateMainDexList.run(command);
        if (command.getMainDexListConsumer() == null) {
            result.forEach(System.out::println);
        }
    }
}

