/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.BaseCompilerCommandParser;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.D8CommandParser;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.L8;
import shadow.bundletool.com.android.tools.r8.L8Command;
import shadow.bundletool.com.android.tools.r8.OutputMode;
import shadow.bundletool.com.android.tools.r8.StringResource;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.FlagFile;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class L8CommandParser
extends BaseCompilerCommandParser<L8Command, L8Command.Builder> {
    private static final Set<String> OPTIONS_WITH_PARAMETER = ImmutableSet.of("--output", "--lib", "--min-api", "--desugared-lib");
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", Iterables.concat(Arrays.asList("Usage: l8 [options] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and options are:", "  --debug                 # Compile with debugging information (default).", "  --release               # Compile without debugging information.", "  --output <file>         # Output result in <outfile>.", "                          # <file> must be an existing directory or a zip file.", "  --lib <file|jdk-home>   # Add <file|jdk-home> as a library resource.", "  --min-api <number>      # Minimum Android API level compatibility, default: " + AndroidApiLevel.getDefault().getLevel() + ".", "  --pg-conf <file>        # Proguard configuration <file>.", "  --desugared-lib <file>  # Specify desugared library configuration.", "                          # <file> is a desugared library configuration (json)."), ASSERTIONS_USAGE_MESSAGE, Arrays.asList("  --version               # Print the version of l8.", "  --help                  # Print this message.")));

    public static void main(String[] args) throws CompilationFailedException {
        L8Command command = (L8Command)L8CommandParser.parse(args, Origin.root()).build();
        if (command.isPrintHelp()) {
            System.out.println(USAGE_MESSAGE);
            System.exit(1);
        }
        L8.run(command);
    }

    public static L8Command.Builder parse(String[] args, Origin origin) {
        return new L8CommandParser().parse(args, origin, L8Command.builder());
    }

    public static L8Command.Builder parse(String[] args, Origin origin, DiagnosticsHandler handler) {
        return new L8CommandParser().parse(args, origin, L8Command.builder(handler));
    }

    private L8Command.Builder parse(String[] args, Origin origin, L8Command.Builder builder) {
        CompilationMode compilationMode = null;
        Path outputPath = null;
        OutputMode outputMode = null;
        boolean hasDefinedApiLevel = false;
        D8CommandParser.OrderedClassFileResourceProvider.Builder classpathBuilder = D8CommandParser.OrderedClassFileResourceProvider.builder();
        String[] expandedArgs = FlagFile.expandFlagFiles(args, builder);
        for (int i = 0; i < expandedArgs.length; ++i) {
            String arg = expandedArgs[i].trim();
            String nextArg = null;
            if (OPTIONS_WITH_PARAMETER.contains(arg)) {
                if (++i < expandedArgs.length) {
                    nextArg = expandedArgs[i];
                } else {
                    builder.error(new StringDiagnostic("Missing parameter for " + expandedArgs[i - 1] + ".", origin));
                    break;
                }
            }
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--debug")) {
                if (compilationMode == CompilationMode.RELEASE) {
                    builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                    continue;
                }
                compilationMode = CompilationMode.DEBUG;
                continue;
            }
            if (arg.equals("--release")) {
                if (compilationMode == CompilationMode.DEBUG) {
                    builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                    continue;
                }
                compilationMode = CompilationMode.RELEASE;
                continue;
            }
            if (arg.equals("--output")) {
                if (outputPath != null) {
                    builder.error(new StringDiagnostic("Cannot output both to '" + outputPath.toString() + "' and '" + nextArg + "'", origin));
                    continue;
                }
                outputPath = Paths.get(nextArg, new String[0]);
                continue;
            }
            if (arg.equals("--min-api")) {
                if (hasDefinedApiLevel) {
                    builder.error(new StringDiagnostic("Cannot set multiple --min-api options", origin));
                    continue;
                }
                this.parseMinApi(builder, nextArg, origin);
                hasDefinedApiLevel = true;
                continue;
            }
            if (arg.equals("--lib")) {
                L8CommandParser.addLibraryArgument(builder, origin, nextArg);
                continue;
            }
            if (arg.equals("--pg-conf")) {
                builder.addProguardConfigurationFiles(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--desugared-lib")) {
                builder.addDesugaredLibraryConfiguration(StringResource.fromFile(Paths.get(nextArg, new String[0])));
                continue;
            }
            if (arg.startsWith("--")) {
                if (this.tryParseAssertionArgument(builder, arg, origin)) continue;
                builder.error(new StringDiagnostic("Unknown option: " + arg, origin));
                continue;
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
        if (!classpathBuilder.isEmpty()) {
            builder.addClasspathResourceProvider(classpathBuilder.build());
        }
        if (compilationMode != null) {
            builder.setMode(compilationMode);
        }
        if (outputMode == null) {
            outputMode = OutputMode.DexIndexed;
        }
        if (outputPath == null) {
            outputPath = Paths.get(".", new String[0]);
        }
        return (L8Command.Builder)builder.setOutput(outputPath, outputMode);
    }
}

