/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import shadow.bundletool.com.android.tools.r8.graph.AccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;

public class AccessControl {
    public static boolean isClassAccessible(DexClass clazz, DexProgramClass context) {
        if (clazz.accessFlags.isPublic()) {
            return true;
        }
        return clazz.getType().isSamePackage(context.getType());
    }

    public static boolean isMethodAccessible(DexEncodedMethod method, DexClass holder, DexProgramClass context, AppInfoWithSubtyping appInfo) {
        return AccessControl.isMemberAccessible(method.accessFlags, holder, context, appInfo);
    }

    public static boolean isFieldAccessible(DexEncodedField field, DexClass holder, DexProgramClass context, AppInfoWithSubtyping appInfo) {
        return AccessControl.isMemberAccessible(field.accessFlags, holder, context, appInfo);
    }

    private static boolean isMemberAccessible(AccessFlags<?> memberFlags, DexClass holder, DexProgramClass context, AppInfoWithSubtyping appInfo) {
        if (!AccessControl.isClassAccessible(holder, context)) {
            return false;
        }
        if (memberFlags.isPublic()) {
            return true;
        }
        if (memberFlags.isPrivate()) {
            return AccessControl.isNestMate(holder, context);
        }
        if (holder.getType().isSamePackage(context.getType())) {
            return true;
        }
        if (!memberFlags.isProtected()) {
            return false;
        }
        return appInfo.isSubtype(context.getType(), holder.getType());
    }

    private static boolean isNestMate(DexClass clazz, DexProgramClass context) {
        if (clazz == context) {
            return true;
        }
        if (!clazz.isInANest() || !context.isInANest()) {
            return false;
        }
        return clazz.getNestHost() == context.getNestHost();
    }
}

