/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.ClassHierarchy;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DirectMappedDexApplication;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaDescriptor;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;

public class AppInfoWithSubtyping
extends AppInfo
implements ClassHierarchy {
    private static final int ROOT_LEVEL = 0;
    private static final int UNKNOWN_LEVEL = -1;
    private static final int INTERFACE_LEVEL = -2;
    private static final Set<DexType> NO_DIRECT_SUBTYPE = ImmutableSet.of();
    private final Set<DexType> missingClasses = Sets.newIdentityHashSet();
    private final Map<DexType, ImmutableSet<DexType>> subtypeMap = new IdentityHashMap<DexType, ImmutableSet<DexType>>();
    private final Map<DexType, ImmutableSet<DexType>> supertypesForSynthesizedClasses = new ConcurrentHashMap<DexType, ImmutableSet<DexType>>();
    private final Map<DexType, TypeInfo> typeInfo;
    private final Map<DexType, Boolean> mayHaveFinalizeMethodDirectlyOrIndirectlyCache = new ConcurrentHashMap<DexType, Boolean>();

    public AppInfoWithSubtyping(DexApplication application) {
        super(application);
        this.typeInfo = new ConcurrentHashMap<DexType, TypeInfo>();
        this.populateSubtypeMap(application.asDirect(), application.dexItemFactory);
    }

    protected AppInfoWithSubtyping(AppInfoWithSubtyping previous) {
        super(previous);
        this.missingClasses.addAll(previous.missingClasses);
        this.subtypeMap.putAll(previous.subtypeMap);
        this.supertypesForSynthesizedClasses.putAll(previous.supertypesForSynthesizedClasses);
        this.typeInfo = new ConcurrentHashMap<DexType, TypeInfo>(previous.typeInfo);
        assert (this.app() instanceof DirectMappedDexApplication);
    }

    @Override
    public void addSynthesizedClass(DexProgramClass synthesizedClass) {
        super.addSynthesizedClass(synthesizedClass);
        assert (synthesizedClass.superType == this.dexItemFactory().objectType || synthesizedClass.type.toString().contains("-$$LambdaGroup$")) : "Make sure retrieval and iteration of sub types of `" + synthesizedClass.superType + "` is guaranteed to be thread safe and able to see `" + synthesizedClass + "`";
        this.registerNewType(synthesizedClass.type, synthesizedClass.superType);
        Set<DexType> visited = SetUtils.newIdentityHashSet(synthesizedClass.allImmediateSupertypes());
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>(visited);
        while (!worklist.isEmpty()) {
            DexType type = (DexType)worklist.removeFirst();
            assert (visited.contains(type));
            DexClass clazz = this.definitionFor(type);
            if (clazz == null) continue;
            for (DexType supertype : clazz.allImmediateSupertypes()) {
                if (!visited.add(supertype)) continue;
                worklist.addLast(supertype);
            }
        }
        if (!visited.isEmpty()) {
            this.supertypesForSynthesizedClasses.put(synthesizedClass.type, ImmutableSet.copyOf(visited));
        }
    }

    private boolean isSynthesizedClassStrictSubtypeOf(DexType synthesizedClass, DexType supertype) {
        Set supertypesOfSynthesizedClass = this.supertypesForSynthesizedClasses.get(synthesizedClass);
        return supertypesOfSynthesizedClass != null && supertypesOfSynthesizedClass.contains(supertype);
    }

    private DirectMappedDexApplication getDirectApplication() {
        return (DirectMappedDexApplication)this.app();
    }

    public Iterable<DexLibraryClass> libraryClasses() {
        assert (this.checkIfObsolete());
        return this.getDirectApplication().libraryClasses();
    }

    public Set<DexType> getMissingClasses() {
        assert (this.checkIfObsolete());
        return Collections.unmodifiableSet(this.missingClasses);
    }

    public Set<DexType> subtypes(DexType type) {
        assert (this.checkIfObsolete());
        assert (type.isClassType());
        ImmutableSet<DexType> subtypes = this.subtypeMap.get(type);
        return subtypes == null ? ImmutableSet.of() : subtypes;
    }

    private void populateSuperType(Map<DexType, Set<DexType>> map2, DexType superType, DexClass baseClass, Function<DexType, DexClass> definitions) {
        Set set;
        if (superType != null && (set = map2.computeIfAbsent(superType, ignore -> new HashSet())).add(baseClass.type)) {
            this.populateAllSuperTypes(map2, superType, baseClass, definitions);
        }
    }

    private TypeInfo getTypeInfo(DexType type) {
        assert (type != null);
        return this.typeInfo.computeIfAbsent(type, TypeInfo::new);
    }

    private void populateAllSuperTypes(Map<DexType, Set<DexType>> map2, DexType holder, DexClass baseClass, Function<DexType, DexClass> definitions) {
        DexClass holderClass = definitions.apply(holder);
        if (holderClass != null) {
            this.populateSuperType(map2, holderClass.superType, baseClass, definitions);
            if (holderClass.superType != null) {
                this.getTypeInfo(holderClass.superType).addDirectSubtype(this.getTypeInfo(holder));
            } else assert (this.dexItemFactory().objectType == holder);
            for (DexType inter : holderClass.interfaces.values) {
                this.populateSuperType(map2, inter, baseClass, definitions);
                this.getTypeInfo(inter).addInterfaceSubtype(holder);
            }
            if (holderClass.isInterface()) {
                this.getTypeInfo(holder).tagAsInterface();
            }
        } else {
            if (baseClass.isProgramClass() || baseClass.isClasspathClass()) {
                this.missingClasses.add(holder);
            }
            if (holder != this.dexItemFactory().objectType) {
                this.getTypeInfo(this.dexItemFactory().objectType).addDirectSubtype(this.getTypeInfo(holder));
            }
        }
    }

    private void populateSubtypeMap(DirectMappedDexApplication app, DexItemFactory dexItemFactory) {
        this.getTypeInfo(dexItemFactory.objectType).tagAsSubtypeRoot();
        IdentityHashMap<DexType, Set<DexType>> map2 = new IdentityHashMap<DexType, Set<DexType>>();
        for (DexClass dexClass : app.allClasses()) {
            this.populateAllSuperTypes(map2, dexClass.type, dexClass, app::definitionFor);
        }
        for (Map.Entry entry : map2.entrySet()) {
            this.subtypeMap.put((DexType)entry.getKey(), ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        assert (this.validateLevelsAreCorrect(app::definitionFor, dexItemFactory));
    }

    private boolean validateLevelsAreCorrect(Function<DexType, DexClass> definitions, DexItemFactory dexItemFactory) {
        Set<DexType> seenTypes = Sets.newIdentityHashSet();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
        DexType objectType = dexItemFactory.objectType;
        worklist.add(objectType);
        while (!worklist.isEmpty()) {
            DexType next = (DexType)worklist.pop();
            DexClass nextHolder = definitions.apply(next);
            DexType superType = nextHolder == null ? (next == dexItemFactory.objectType ? null : dexItemFactory.objectType) : nextHolder.superType;
            assert (!seenTypes.contains(next));
            seenTypes.add(next);
            TypeInfo nextInfo = this.getTypeInfo(next);
            if (superType == null) {
                assert (nextInfo.hierarchyLevel == 0);
            } else {
                TypeInfo superInfo = this.getTypeInfo(superType);
                assert (superInfo.hierarchyLevel == nextInfo.hierarchyLevel - 1 || superInfo.hierarchyLevel == 0 && nextInfo.hierarchyLevel == -2);
                assert (superInfo.directSubtypes.contains(next));
            }
            if (nextInfo.hierarchyLevel != -2) {
                worklist.addAll(nextInfo.directSubtypes);
                continue;
            }
            if (nextHolder == null) continue;
            for (DexType iface : nextHolder.interfaces.values) {
                TypeInfo ifaceInfo = this.getTypeInfo(iface);
                assert (ifaceInfo.directSubtypes.contains(next));
                assert (ifaceInfo.hierarchyLevel == -2);
            }
        }
        return true;
    }

    protected boolean hasAnyInstantiatedLambdas(DexProgramClass clazz) {
        assert (this.checkIfObsolete());
        return true;
    }

    public boolean methodDefinedInInterfaces(DexEncodedMethod method, DexType implementingClass) {
        DexClass holder = this.definitionFor(implementingClass);
        if (holder == null) {
            return false;
        }
        for (DexType iface : holder.interfaces.values) {
            if (!this.methodDefinedInInterface(method, iface)) continue;
            return true;
        }
        return false;
    }

    public boolean methodDefinedInInterface(DexEncodedMethod method, DexType iface) {
        DexClass potentialHolder = this.definitionFor(iface);
        if (potentialHolder == null) {
            return false;
        }
        assert (potentialHolder.isInterface());
        for (DexEncodedMethod dexEncodedMethod : potentialHolder.virtualMethods) {
            if (!dexEncodedMethod.method.hasSameProtoAndName(method.method) || !dexEncodedMethod.accessFlags.isSameVisibility(method.accessFlags)) continue;
            return true;
        }
        for (DexItem dexItem : potentialHolder.interfaces.values) {
            if (!this.methodDefinedInInterface(method, (DexType)dexItem)) continue;
            return true;
        }
        return false;
    }

    public Set<DexEncodedMethod> lookupLambdaImplementedMethods(DexCallSite callSite) {
        assert (this.checkIfObsolete());
        List<DexType> callSiteInterfaces = LambdaDescriptor.getInterfaces(callSite, this);
        if (callSiteInterfaces == null || callSiteInterfaces.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>(callSiteInterfaces);
        Set<DexType> visited = Sets.newIdentityHashSet();
        while (!worklist.isEmpty()) {
            DexType iface = (DexType)worklist.removeFirst();
            if (this.getTypeInfo(iface).isUnknown() || !visited.add(iface)) continue;
            assert (this.getTypeInfo(iface).isInterface());
            DexClass clazz = this.definitionFor(iface);
            if (clazz == null) continue;
            for (DexEncodedMethod method : clazz.virtualMethods()) {
                if (method.method.name != callSite.methodName || !method.accessFlags.isAbstract()) continue;
                result.add(method);
            }
            Collections.addAll(worklist, clazz.interfaces.values);
        }
        return result;
    }

    public boolean isStringConcat(DexMethodHandle bootstrapMethod) {
        assert (this.checkIfObsolete());
        return bootstrapMethod.type.isInvokeStatic() && (bootstrapMethod.asMethod() == this.dexItemFactory().stringConcatWithConstantsMethod || bootstrapMethod.asMethod() == this.dexItemFactory().stringConcatMethod);
    }

    private void registerNewType(DexType newType, DexType superType) {
        assert (this.checkIfObsolete());
        this.getTypeInfo(superType).addDirectSubtype(this.getTypeInfo(newType));
    }

    @VisibleForTesting
    public void registerNewTypeForTesting(DexType newType, DexType superType) {
        this.registerNewType(newType, superType);
    }

    @Override
    public boolean hasSubtyping() {
        assert (this.checkIfObsolete());
        return true;
    }

    @Override
    public AppInfoWithSubtyping withSubtyping() {
        assert (this.checkIfObsolete());
        return this;
    }

    public Set<DexType> allImmediateSubtypes(DexType type) {
        return this.getTypeInfo((DexType)type).directSubtypes;
    }

    public boolean isUnknown(DexType type) {
        return this.getTypeInfo(type).isUnknown();
    }

    public boolean isMarkedAsInterface(DexType type) {
        return this.getTypeInfo(type).isInterface();
    }

    @Override
    public boolean hasSubtypes(DexType type) {
        return !this.getTypeInfo((DexType)type).directSubtypes.isEmpty();
    }

    public boolean isRelatedBySubtyping(DexType type, DexType other) {
        assert (type.isClassType());
        assert (other.isClassType());
        return this.isSubtype(type, other) || this.isSubtype(other, type);
    }

    @Override
    public boolean isSubtype(DexType subtype, DexType supertype) {
        if (subtype == supertype || this.isStrictSubtypeOf(subtype, supertype)) {
            return true;
        }
        if (this.synthesizedClasses.containsKey(subtype)) {
            return this.isSynthesizedClassStrictSubtypeOf(subtype, supertype);
        }
        return false;
    }

    public boolean isStrictSubtypeOf(DexType subtype, DexType supertype) {
        if (this.isStrictSubtypeOf(subtype, supertype, false)) {
            return true;
        }
        if (this.synthesizedClasses.containsKey(subtype)) {
            return this.isSynthesizedClassStrictSubtypeOf(subtype, supertype);
        }
        return false;
    }

    private boolean isStrictSubtypeOf(DexType subtype, DexType supertype, boolean orElse) {
        if (subtype == supertype) {
            return false;
        }
        if (subtype == this.dexItemFactory().objectType) {
            return false;
        }
        if (supertype == this.dexItemFactory().objectType) {
            return true;
        }
        TypeInfo subInfo = this.getTypeInfo(subtype);
        if (subInfo.hierarchyLevel == -2) {
            return this.isInterfaceSubtypeOf(subtype, supertype);
        }
        TypeInfo superInfo = this.getTypeInfo(supertype);
        if (superInfo.hierarchyLevel == -2) {
            return superInfo.directSubtypes.stream().anyMatch(superSubtype -> this.isSubtype(subtype, (DexType)superSubtype));
        }
        return this.isSubtypeOfClass(subInfo, superInfo, orElse);
    }

    private boolean isInterfaceSubtypeOf(DexType candidate, DexType other) {
        if (candidate == other || other == this.dexItemFactory().objectType) {
            return true;
        }
        DexClass candidateHolder = this.definitionFor(candidate);
        if (candidateHolder == null) {
            return false;
        }
        for (DexType iface : candidateHolder.interfaces.values) {
            assert (this.getTypeInfo((DexType)iface).hierarchyLevel == -2);
            if (!this.isInterfaceSubtypeOf(iface, other)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubtypeOfClass(TypeInfo subInfo, TypeInfo superInfo, boolean orElse) {
        if (superInfo.hierarchyLevel == -1) {
            return orElse;
        }
        while (superInfo.hierarchyLevel < subInfo.hierarchyLevel) {
            DexClass holder = this.definitionFor(subInfo.type);
            assert (holder != null && !holder.isInterface());
            subInfo = this.getTypeInfo(holder.superType);
        }
        return subInfo.type == superInfo.type;
    }

    public void forAllImmediateExtendsSubtypes(DexType type, Consumer<DexType> f) {
        this.allImmediateExtendsSubtypes(type).forEach(f);
    }

    public Iterable<DexType> allImmediateExtendsSubtypes(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        assert (info.hierarchyLevel != -1);
        if (info.hierarchyLevel == -2) {
            return Iterables.filter(info.directSubtypes, t -> this.getTypeInfo((DexType)t).isInterface());
        }
        if (info.hierarchyLevel == 0) {
            return Iterables.filter(info.directSubtypes, t -> !this.getTypeInfo((DexType)t).isInterface());
        }
        return info.directSubtypes;
    }

    public void forAllImmediateImplementsSubtypes(DexType type, Consumer<DexType> f) {
        this.allImmediateImplementsSubtypes(type).forEach(f);
    }

    public Iterable<DexType> allImmediateImplementsSubtypes(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        if (info.hierarchyLevel == -2) {
            return Iterables.filter(info.directSubtypes, subtype -> !this.getTypeInfo((DexType)subtype).isInterface());
        }
        return ImmutableList.of();
    }

    public boolean isMissingOrHasMissingSuperType(DexType type) {
        DexClass clazz = this.definitionFor(type);
        return clazz == null || clazz.hasMissingSuperType(this);
    }

    public boolean isExternalizable(DexType type) {
        return this.implementedInterfaces(type).contains(this.dexItemFactory().externalizableType);
    }

    public boolean isSerializable(DexType type) {
        return this.implementedInterfaces(type).contains(this.dexItemFactory().serializableType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DexType> implementedInterfaces(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        if (info.implementedInterfaces != null) {
            return info.implementedInterfaces;
        }
        AppInfoWithSubtyping appInfoWithSubtyping = this;
        synchronized (appInfoWithSubtyping) {
            if (info.implementedInterfaces == null) {
                Set<DexType> interfaces = Sets.newIdentityHashSet();
                this.implementedInterfaces(type, interfaces);
                info.implementedInterfaces = interfaces;
            }
        }
        return info.implementedInterfaces;
    }

    private void implementedInterfaces(DexType type, Set<DexType> interfaces) {
        DexClass dexClass = this.definitionFor(type);
        while (dexClass != null) {
            if (dexClass.isInterface()) {
                interfaces.add(dexClass.type);
            }
            for (DexType itf : dexClass.interfaces.values) {
                this.implementedInterfaces(itf, interfaces);
            }
            if (dexClass.superType == null) break;
            dexClass = this.definitionFor(dexClass.superType);
        }
    }

    public DexType getSingleSubtype(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        assert (info.hierarchyLevel != -1);
        if (info.directSubtypes.size() == 1) {
            return Iterables.getFirst(info.directSubtypes, null);
        }
        return null;
    }

    @Override
    public boolean isDirectSubtype(DexType subtype, DexType supertype) {
        TypeInfo info = this.getTypeInfo(supertype);
        assert (info.hierarchyLevel != -1);
        return info.directSubtypes.contains(subtype);
    }

    public DexType computeLeastUpperBoundOfClasses(DexType subtype, DexType other) {
        DexClass dexClass;
        TypeInfo t2;
        TypeInfo t1;
        if (subtype == other) {
            return subtype;
        }
        DexType objectType = this.dexItemFactory().objectType;
        TypeInfo subInfo = this.getTypeInfo(subtype);
        TypeInfo superInfo = this.getTypeInfo(other);
        if (subInfo.hierarchyLevel == -1 || superInfo.hierarchyLevel == -1) {
            return objectType;
        }
        if (subtype == objectType || other == objectType) {
            return objectType;
        }
        if (superInfo.hierarchyLevel < subInfo.hierarchyLevel) {
            t1 = superInfo;
            t2 = subInfo;
        } else {
            t1 = subInfo;
            t2 = superInfo;
        }
        while (t2.hierarchyLevel > t1.hierarchyLevel) {
            dexClass = this.definitionFor(t2.type);
            if (dexClass == null || dexClass.superType == null) {
                return objectType;
            }
            t2 = this.getTypeInfo(dexClass.superType);
        }
        DexType lubType = t1.type;
        DexType t2Type = t2.type;
        while (t2Type != lubType) {
            assert (this.getTypeInfo((DexType)t2Type).hierarchyLevel == this.getTypeInfo((DexType)lubType).hierarchyLevel);
            dexClass = this.definitionFor(t2Type);
            if (dexClass == null) {
                lubType = objectType;
                break;
            }
            t2Type = dexClass.superType;
            dexClass = this.definitionFor(lubType);
            if (dexClass == null) {
                lubType = objectType;
                break;
            }
            lubType = dexClass.superType;
        }
        return lubType;
    }

    public boolean inDifferentHierarchy(DexType type1, DexType type2) {
        return !this.isSubtype(type1, type2) && !this.isSubtype(type2, type1);
    }

    public boolean mayHaveFinalizeMethodDirectlyOrIndirectly(ClassTypeLatticeElement type) {
        Set<DexType> interfaces = type.getInterfaces();
        if (!interfaces.isEmpty()) {
            for (DexType interfaceType : interfaces) {
                if (!this.computeMayHaveFinalizeMethodDirectlyOrIndirectlyIfAbsent(interfaceType, false)) continue;
                return true;
            }
            return false;
        }
        return this.computeMayHaveFinalizeMethodDirectlyOrIndirectlyIfAbsent(type.getClassType(), true);
    }

    private boolean computeMayHaveFinalizeMethodDirectlyOrIndirectlyIfAbsent(DexType type, boolean lookUpwards) {
        assert (type.isClassType());
        Boolean cache = this.mayHaveFinalizeMethodDirectlyOrIndirectlyCache.get(type);
        if (cache != null) {
            return cache;
        }
        DexClass clazz = this.definitionFor(type);
        if (clazz == null) {
            this.mayHaveFinalizeMethodDirectlyOrIndirectlyCache.put(type, false);
            return false;
        }
        if (clazz.isProgramClass()) {
            if (lookUpwards) {
                DexEncodedMethod resolutionResult = this.resolveMethod(type, this.dexItemFactory().objectMethods.finalize).getSingleTarget();
                if (resolutionResult != null && resolutionResult.isProgramMethod(this)) {
                    this.mayHaveFinalizeMethodDirectlyOrIndirectlyCache.put(type, true);
                    return true;
                }
            } else if (clazz.lookupVirtualMethod(this.dexItemFactory().objectMethods.finalize) != null) {
                this.mayHaveFinalizeMethodDirectlyOrIndirectlyCache.put(type, true);
                return true;
            }
        }
        for (DexType subtype : this.allImmediateSubtypes(type)) {
            if (!this.computeMayHaveFinalizeMethodDirectlyOrIndirectlyIfAbsent(subtype, false)) continue;
            this.mayHaveFinalizeMethodDirectlyOrIndirectlyCache.put(type, true);
            return true;
        }
        this.mayHaveFinalizeMethodDirectlyOrIndirectlyCache.put(type, false);
        return false;
    }

    private static class TypeInfo {
        private final DexType type;
        int hierarchyLevel = -1;
        Set<DexType> directSubtypes = AppInfoWithSubtyping.access$000();
        Set<DexType> implementedInterfaces = null;

        TypeInfo(DexType type) {
            this.type = type;
        }

        public String toString() {
            return "TypeInfo{" + this.type + ", level:" + this.hierarchyLevel + "}";
        }

        private void ensureDirectSubTypeSet() {
            if (this.directSubtypes == NO_DIRECT_SUBTYPE) {
                this.directSubtypes = new TreeSet<DexType>(DexType::slowCompareTo);
            }
        }

        private void setLevel(int level) {
            if (level == this.hierarchyLevel) {
                return;
            }
            if (this.hierarchyLevel == -2) {
                assert (level == 1);
            } else if (level == -2) {
                assert (this.hierarchyLevel == 1 || this.hierarchyLevel == -1);
                this.hierarchyLevel = -2;
            } else {
                assert (this.hierarchyLevel == -1);
                this.hierarchyLevel = level;
            }
        }

        synchronized void addDirectSubtype(TypeInfo subtypeInfo) {
            assert (this.hierarchyLevel != -1);
            this.ensureDirectSubTypeSet();
            this.directSubtypes.add(subtypeInfo.type);
            subtypeInfo.setLevel(this.hierarchyLevel + 1);
        }

        void tagAsSubtypeRoot() {
            this.setLevel(0);
        }

        void tagAsInterface() {
            this.setLevel(-2);
        }

        public boolean isInterface() {
            assert (this.hierarchyLevel != -1) : "Program class missing: " + this;
            assert (this.type.isClassType());
            return this.hierarchyLevel == -2;
        }

        public boolean isUnknown() {
            return this.hierarchyLevel == -1;
        }

        synchronized void addInterfaceSubtype(DexType type) {
            this.setLevel(-2);
            this.ensureDirectSubTypeSet();
            this.directSubtypes.add(type);
        }
    }
}

