/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Predicates;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppServices;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.analysis.InitializedClassesInInstanceMethodsAnalysis;
import shadow.bundletool.com.android.tools.r8.graph.classmerging.HorizontallyMergedLambdaClasses;
import shadow.bundletool.com.android.tools.r8.graph.classmerging.MergedClassesCollection;
import shadow.bundletool.com.android.tools.r8.graph.classmerging.VerticallyMergedClasses;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.GeneratedExtensionRegistryShrinker;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.GeneratedMessageLiteBuilderShrinker;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.GeneratedMessageLiteShrinker;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoShrinker;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValueFactory;
import shadow.bundletool.com.android.tools.r8.ir.desugar.PrefixRewritingMapper;
import shadow.bundletool.com.android.tools.r8.ir.optimize.CallSiteOptimizationInfoPropagator;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.RootSetBuilder;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.OptionalBool;

public class AppView<T extends AppInfo>
implements DexDefinitionSupplier {
    private T appInfo;
    private AppServices appServices;
    private final DexItemFactory dexItemFactory;
    private final WholeProgramOptimizations wholeProgramOptimizations;
    private GraphLense graphLense;
    private final InternalOptions options;
    private RootSetBuilder.RootSet rootSet;
    private final AbstractValueFactory abstractValueFactory = new AbstractValueFactory();
    public final PrefixRewritingMapper rewritePrefix;
    private final CallSiteOptimizationInfoPropagator callSiteOptimizationInfoPropagator;
    private final ProtoShrinker protoShrinker;
    private boolean allCodeProcessed = false;
    private Predicate<DexType> classesEscapingIntoLibrary = Predicates.alwaysTrue();
    private InitializedClassesInInstanceMethodsAnalysis.InitializedClassesInInstanceMethods initializedClassesInInstanceMethods;
    private Set<DexMethod> unneededVisibilityBridgeMethods = ImmutableSet.of();
    private HorizontallyMergedLambdaClasses horizontallyMergedLambdaClasses;
    private VerticallyMergedClasses verticallyMergedClasses;
    private Map<DexClass, DexValue.DexValueString> sourceDebugExtensions = new IdentityHashMap<DexClass, DexValue.DexValueString>();

    private AppView(T appInfo, WholeProgramOptimizations wholeProgramOptimizations, InternalOptions options) {
        this(appInfo, wholeProgramOptimizations, options, appInfo == null ? PrefixRewritingMapper.empty() : options.desugaredLibraryConfiguration.createPrefixRewritingMapper(options.itemFactory));
    }

    private AppView(T appInfo, WholeProgramOptimizations wholeProgramOptimizations, InternalOptions options, PrefixRewritingMapper mapper) {
        this.appInfo = appInfo;
        this.dexItemFactory = appInfo != null ? ((AppInfo)appInfo).dexItemFactory() : null;
        this.wholeProgramOptimizations = wholeProgramOptimizations;
        this.graphLense = GraphLense.getIdentityLense();
        this.options = options;
        this.rewritePrefix = mapper;
        this.callSiteOptimizationInfoPropagator = this.enableWholeProgramOptimizations() && options.enablePropagationOfDynamicTypesAtCallSites ? new CallSiteOptimizationInfoPropagator(this.withLiveness()) : null;
        this.protoShrinker = this.enableWholeProgramOptimizations() && options.protoShrinking().isProtoShrinkingEnabled() ? new ProtoShrinker(this.withLiveness()) : null;
    }

    public static <T extends AppInfo> AppView<T> createForD8(T appInfo, InternalOptions options) {
        return new AppView<T>(appInfo, WholeProgramOptimizations.OFF, options);
    }

    public static <T extends AppInfo> AppView<T> createForD8(T appInfo, InternalOptions options, PrefixRewritingMapper mapper) {
        return new AppView<T>(appInfo, WholeProgramOptimizations.OFF, options, mapper);
    }

    public static <T extends AppInfo> AppView<T> createForR8(T appInfo, InternalOptions options) {
        return new AppView<T>(appInfo, WholeProgramOptimizations.ON, options);
    }

    public static <T extends AppInfo> AppView<T> createForL8(T appInfo, InternalOptions options, PrefixRewritingMapper mapper) {
        return new AppView<T>(appInfo, WholeProgramOptimizations.OFF, options, mapper);
    }

    public AbstractValueFactory abstractValueFactory() {
        return this.abstractValueFactory;
    }

    public T appInfo() {
        return this.appInfo;
    }

    public <U extends T> AppView<U> setAppInfo(U appInfo) {
        assert (!((AppInfo)appInfo).isObsolete());
        T previous = this.appInfo;
        this.appInfo = appInfo;
        if (appInfo != previous) {
            ((AppInfo)previous).markObsolete();
        }
        AppView appViewWithSpecializedAppInfo = this;
        return appViewWithSpecializedAppInfo;
    }

    public boolean isAllCodeProcessed() {
        return this.allCodeProcessed;
    }

    public void setAllCodeProcessed() {
        this.allCodeProcessed = true;
    }

    public AppServices appServices() {
        return this.appServices;
    }

    public void setAppServices(AppServices appServices) {
        this.appServices = appServices;
    }

    public boolean isClassEscapingIntoLibrary(DexType type) {
        assert (type.isClassType());
        return this.classesEscapingIntoLibrary.test(type);
    }

    public void setClassesEscapingIntoLibrary(Predicate<DexType> classesEscapingIntoLibrary) {
        this.classesEscapingIntoLibrary = classesEscapingIntoLibrary;
    }

    public void setSourceDebugExtensionForType(DexClass clazz, DexValue.DexValueString sourceDebugExtension) {
        this.sourceDebugExtensions.put(clazz, sourceDebugExtension);
    }

    public DexValue.DexValueString getSourceDebugExtensionForType(DexClass clazz) {
        return this.sourceDebugExtensions.get(clazz);
    }

    @Override
    public final DexDefinition definitionFor(DexReference reference) {
        return ((AppInfo)this.appInfo()).definitionFor(reference);
    }

    @Override
    public final DexEncodedField definitionFor(DexField field) {
        return ((AppInfo)this.appInfo()).definitionFor(field);
    }

    @Override
    public final DexEncodedMethod definitionFor(DexMethod method) {
        return ((AppInfo)this.appInfo()).definitionFor(method);
    }

    @Override
    public final DexClass definitionFor(DexType type) {
        return ((AppInfo)this.appInfo()).definitionFor(type);
    }

    @Override
    public final DexProgramClass definitionForProgramType(DexType type) {
        return ((AppInfo)this.appInfo).app().programDefinitionFor(type);
    }

    public OptionalBool isInterface(DexType type) {
        if (this.enableWholeProgramOptimizations()) {
            assert (((AppInfo)this.appInfo()).hasSubtyping());
            if (((AppInfo)this.appInfo()).hasSubtyping()) {
                AppInfoWithSubtyping appInfo = ((AppInfo)this.appInfo()).withSubtyping();
                return appInfo.isUnknown(type) ? OptionalBool.unknown() : OptionalBool.of(appInfo.isMarkedAsInterface(type));
            }
        }
        return OptionalBool.unknown();
    }

    @Override
    public DexItemFactory dexItemFactory() {
        return this.dexItemFactory;
    }

    public boolean enableWholeProgramOptimizations() {
        return this.wholeProgramOptimizations == WholeProgramOptimizations.ON;
    }

    public CallSiteOptimizationInfoPropagator callSiteOptimizationInfoPropagator() {
        return this.callSiteOptimizationInfoPropagator;
    }

    public ProtoShrinker protoShrinker() {
        return this.protoShrinker;
    }

    public void withGeneratedExtensionRegistryShrinker(Consumer<GeneratedExtensionRegistryShrinker> consumer) {
        if (this.protoShrinker != null && this.protoShrinker.generatedExtensionRegistryShrinker != null) {
            consumer.accept(this.protoShrinker.generatedExtensionRegistryShrinker);
        }
    }

    public <U> U withGeneratedExtensionRegistryShrinker(Function<GeneratedExtensionRegistryShrinker, U> fn, U defaultValue) {
        if (this.protoShrinker != null && this.protoShrinker.generatedExtensionRegistryShrinker != null) {
            return fn.apply(this.protoShrinker.generatedExtensionRegistryShrinker);
        }
        return defaultValue;
    }

    public void withGeneratedMessageLiteShrinker(Consumer<GeneratedMessageLiteShrinker> consumer) {
        if (this.protoShrinker != null && this.protoShrinker.generatedMessageLiteShrinker != null) {
            consumer.accept(this.protoShrinker.generatedMessageLiteShrinker);
        }
    }

    public void withGeneratedMessageLiteBuilderShrinker(Consumer<GeneratedMessageLiteBuilderShrinker> consumer) {
        if (this.protoShrinker != null && this.protoShrinker.generatedMessageLiteBuilderShrinker != null) {
            consumer.accept(this.protoShrinker.generatedMessageLiteBuilderShrinker);
        }
    }

    public <U> U withGeneratedMessageLiteShrinker(Function<GeneratedMessageLiteShrinker, U> fn, U defaultValue) {
        if (this.protoShrinker != null && this.protoShrinker.generatedMessageLiteShrinker != null) {
            return fn.apply(this.protoShrinker.generatedMessageLiteShrinker);
        }
        return defaultValue;
    }

    public <U> U withGeneratedMessageLiteBuilderShrinker(Function<GeneratedMessageLiteBuilderShrinker, U> fn, U defaultValue) {
        if (this.protoShrinker != null && this.protoShrinker.generatedMessageLiteBuilderShrinker != null) {
            return fn.apply(this.protoShrinker.generatedMessageLiteBuilderShrinker);
        }
        return defaultValue;
    }

    public GraphLense graphLense() {
        return this.graphLense;
    }

    public boolean setGraphLense(GraphLense graphLense) {
        if (graphLense != this.graphLense) {
            this.graphLense = graphLense;
            return true;
        }
        return false;
    }

    public void setInitializedClassesInInstanceMethods(InitializedClassesInInstanceMethodsAnalysis.InitializedClassesInInstanceMethods initializedClassesInInstanceMethods) {
        this.initializedClassesInInstanceMethods = initializedClassesInInstanceMethods;
    }

    public <U> U withInitializedClassesInInstanceMethods(Function<InitializedClassesInInstanceMethodsAnalysis.InitializedClassesInInstanceMethods, U> fn, U defaultValue) {
        if (this.initializedClassesInInstanceMethods != null) {
            return fn.apply(this.initializedClassesInInstanceMethods);
        }
        return defaultValue;
    }

    public InternalOptions options() {
        return this.options;
    }

    public RootSetBuilder.RootSet rootSet() {
        return this.rootSet;
    }

    public void setRootSet(RootSetBuilder.RootSet rootSet) {
        assert (this.rootSet == null) : "Root set should never be recomputed";
        this.rootSet = rootSet;
    }

    public Set<DexMethod> unneededVisibilityBridgeMethods() {
        return this.unneededVisibilityBridgeMethods;
    }

    public void setUnneededVisibilityBridgeMethods(Set<DexMethod> unneededVisibilityBridgeMethods) {
        this.unneededVisibilityBridgeMethods = unneededVisibilityBridgeMethods;
    }

    public MergedClassesCollection allMergedClasses() {
        MergedClassesCollection collection = new MergedClassesCollection();
        if (this.horizontallyMergedLambdaClasses != null) {
            collection.add(this.horizontallyMergedLambdaClasses);
        }
        if (this.verticallyMergedClasses != null) {
            collection.add(this.verticallyMergedClasses);
        }
        return collection;
    }

    public HorizontallyMergedLambdaClasses horizontallyMergedLambdaClasses() {
        return this.horizontallyMergedLambdaClasses;
    }

    public void setHorizontallyMergedLambdaClasses(HorizontallyMergedLambdaClasses horizontallyMergedLambdaClasses) {
        this.horizontallyMergedLambdaClasses = horizontallyMergedLambdaClasses;
    }

    public VerticallyMergedClasses verticallyMergedClasses() {
        return this.verticallyMergedClasses;
    }

    public void setVerticallyMergedClasses(VerticallyMergedClasses verticallyMergedClasses) {
        this.verticallyMergedClasses = verticallyMergedClasses;
    }

    public AppView<AppInfoWithSubtyping> withSubtyping() {
        return ((AppInfo)this.appInfo).hasSubtyping() ? this : null;
    }

    public AppView<AppInfoWithLiveness> withLiveness() {
        AppView appViewWithLiveness = this;
        return appViewWithLiveness;
    }

    public OptionalBool isSubtype(DexType subtype, DexType supertype) {
        return ((AppInfo)this.appInfo()).hasSubtyping() ? OptionalBool.of(((AppInfo)this.appInfo()).withSubtyping().isSubtype(subtype, supertype)) : OptionalBool.unknown();
    }

    private static enum WholeProgramOptimizations {
        ON,
        OFF;

    }
}

