/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.sideeffect;

import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ValueMayDependOnEnvironmentAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayPut;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeNewArray;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayFilledData;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.utils.OptionalBool;

public class ClassInitializerSideEffectAnalysis {
    public static ClassInitializerSideEffect classInitializerCanBePostponed(AppView<?> appView, IRCode code) {
        DexType context = code.method.method.holder;
        OptionalBool controlFlowMayDependOnEnvironment = OptionalBool.unknown();
        boolean mayHaveSideEffects = false;
        ValueMayDependOnEnvironmentAnalysis environmentAnalysis = new ValueMayDependOnEnvironmentAnalysis(appView, code);
        for (Instruction instruction : code.instructions()) {
            Object array;
            if (instruction.isArrayPut()) {
                ArrayPut arrayPut = instruction.asArrayPut();
                array = arrayPut.array().getAliasedValue();
                if (((Value)array).isPhi() || !((Value)array).definition.isCreatingArray() || environmentAnalysis.valueMayDependOnEnvironment(arrayPut.index()) || environmentAnalysis.valueMayDependOnEnvironment(arrayPut.value()) || arrayPut.instructionInstanceCanThrow(appView, context).isThrowing()) {
                    return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
                }
                if (controlFlowMayDependOnEnvironment.isUnknown()) {
                    controlFlowMayDependOnEnvironment = OptionalBool.of(code.controlFlowMayDependOnEnvironment(environmentAnalysis));
                }
                if (!controlFlowMayDependOnEnvironment.isTrue()) continue;
                return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
            }
            if (instruction.isNewArrayFilledData()) {
                NewArrayFilledData newArrayFilledData = instruction.asNewArrayFilledData();
                array = newArrayFilledData.src();
                if (((Value)array).isPhi() || !((Value)array).definition.isCreatingArray() || newArrayFilledData.instructionInstanceCanThrow(appView, context).isThrowing()) {
                    return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
                }
                if (controlFlowMayDependOnEnvironment.isUnknown()) {
                    controlFlowMayDependOnEnvironment = OptionalBool.of(code.controlFlowMayDependOnEnvironment(environmentAnalysis));
                }
                if (!controlFlowMayDependOnEnvironment.isTrue()) continue;
                return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
            }
            if (instruction.isInvokeNewArray()) {
                InvokeNewArray invokeNewArray = instruction.asInvokeNewArray();
                if (invokeNewArray.instructionInstanceCanThrow(appView, context).isThrowing()) {
                    return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
                }
                for (Value argument : invokeNewArray.arguments()) {
                    if (!environmentAnalysis.valueMayDependOnEnvironment(argument)) continue;
                    return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
                }
                continue;
            }
            if (instruction.isNewArrayEmpty()) {
                if (!instruction.instructionInstanceCanThrow(appView, context).isThrowing()) continue;
                return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
            }
            if (instruction.isStaticPut()) {
                StaticPut staticPut = instruction.asStaticPut();
                DexEncodedField field = ((AppInfo)appView.appInfo()).resolveField(staticPut.getField());
                if (field == null || field.field.holder != context || environmentAnalysis.valueMayDependOnEnvironment(staticPut.value()) || instruction.instructionInstanceCanThrow(appView, context).isThrowing()) {
                    return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
                }
                mayHaveSideEffects = true;
                continue;
            }
            if (!instruction.instructionMayHaveSideEffects(appView, context)) continue;
            return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
        }
        return mayHaveSideEffects ? ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CAN_BE_POSTPONED : ClassInitializerSideEffect.NONE;
    }

    public static enum ClassInitializerSideEffect {
        SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED,
        SIDE_EFFECTS_THAT_CAN_BE_POSTPONED,
        NONE;


        public boolean canBePostponed() {
            return this != SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
        }

        public boolean isNone() {
            return this == NONE;
        }
    }
}

