/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Arrays;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfArrayStore;
import shadow.bundletool.com.android.tools.r8.code.Aput;
import shadow.bundletool.com.android.tools.r8.code.AputBoolean;
import shadow.bundletool.com.android.tools.r8.code.AputByte;
import shadow.bundletool.com.android.tools.r8.code.AputChar;
import shadow.bundletool.com.android.tools.r8.code.AputObject;
import shadow.bundletool.com.android.tools.r8.code.AputShort;
import shadow.bundletool.com.android.tools.r8.code.AputWide;
import shadow.bundletool.com.android.tools.r8.code.Format23x;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.ImpreciseMemberTypeInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayEmpty;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.TypeConstraintResolver;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;

public class ArrayPut
extends Instruction
implements ImpreciseMemberTypeInstruction {
    private static final int ARRAY_INDEX = 0;
    private static final int INDEX_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private MemberType type;

    public ArrayPut(MemberType type, Value array, Value index, Value value) {
        super(null, Arrays.asList(array, index, value));
        assert (type != null);
        assert (array.verifyCompatible(ValueType.OBJECT));
        assert (index.verifyCompatible(ValueType.INT));
        this.type = type;
    }

    @Override
    public int opcode() {
        return 8;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value array() {
        return (Value)this.inValues.get(0);
    }

    public Value index() {
        return (Value)this.inValues.get(1);
    }

    public Value value() {
        return (Value)this.inValues.get(2);
    }

    @Override
    public MemberType getMemberType() {
        return this.type;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format23x instruction;
        int value = builder.allocatedRegister(this.value(), this.getNumber());
        int array = builder.allocatedRegister(this.array(), this.getNumber());
        int index = builder.allocatedRegister(this.index(), this.getNumber());
        switch (this.type) {
            case INT: 
            case FLOAT: {
                instruction = new Aput(value, array, index);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new AputWide(value, array, index);
                break;
            }
            case OBJECT: {
                instruction = new AputObject(value, array, index);
                break;
            }
            case BOOLEAN_OR_BYTE: {
                ArrayTypeLatticeElement arrayType = this.array().getTypeLattice().asArrayTypeLatticeElement();
                if (arrayType != null && arrayType.getArrayMemberTypeAsMemberType() == TypeLatticeElement.BOOLEAN) {
                    instruction = new AputBoolean(value, array, index);
                    break;
                }
                assert (this.array().getTypeLattice().isDefinitelyNull() || arrayType.getArrayMemberTypeAsMemberType() == TypeLatticeElement.BYTE);
                instruction = new AputByte(value, array, index);
                break;
            }
            case CHAR: {
                instruction = new AputChar(value, array, index);
                break;
            }
            case SHORT: {
                instruction = new AputShort(value, array, index);
                break;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)this.type));
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "ArrayPut instructions define no values.";
        return 0;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        Value newArraySizeValue;
        if (this.index().isConstant() && !this.array().isPhi() && this.array().definition.isNewArrayEmpty() && (newArraySizeValue = this.array().definition.asNewArrayEmpty().size()).isConstant()) {
            int newArraySize = newArraySizeValue.getConstInstruction().asConstNumber().getIntValue();
            int index = this.index().getConstInstruction().asConstNumber().getIntValue();
            return newArraySize <= 0 || index < 0 || newArraySize <= index;
        }
        return true;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, DexType context) {
        if (appView.options().debug) {
            return true;
        }
        Value array = this.array().getAliasedValue();
        if (array.isPhi() || !array.definition.isNewArrayEmpty()) {
            return true;
        }
        NewArrayEmpty definition = array.definition.asNewArrayEmpty();
        Value sizeValue = definition.size().getAliasedValue();
        if (sizeValue.isPhi() || !sizeValue.definition.isConstNumber()) {
            return true;
        }
        Value indexValue = this.index().getAliasedValue();
        if (indexValue.isPhi() || !indexValue.definition.isConstNumber()) {
            return true;
        }
        long index = indexValue.definition.asConstNumber().getRawValue();
        long size = sizeValue.definition.asConstNumber().getRawValue();
        if (index < 0L || index >= size) {
            return true;
        }
        TypeLatticeElement arrayType = array.getTypeLattice();
        TypeLatticeElement valueType = this.value().getTypeLattice();
        if (!arrayType.isArrayType()) {
            return true;
        }
        TypeLatticeElement memberType = arrayType.asArrayTypeLatticeElement().getArrayMemberTypeAsValueType();
        if (!valueType.lessThanOrEqualUpToNullability(memberType, appView)) {
            return true;
        }
        for (Instruction user : array.uniqueUsers()) {
            if (user.isArrayPut() && user.asArrayPut().array() == array) continue;
            return true;
        }
        return array.numberOfPhiUsers() > 0;
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return !this.instructionMayHaveSideEffects(appView, code.method.method.holder);
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isArrayPut() && other.asArrayPut().type == this.type;
    }

    @Override
    public boolean isArrayPut() {
        return true;
    }

    @Override
    public ArrayPut asArrayPut() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forArrayPut();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfArrayStore(this.type));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, DexItemFactory dexItemFactory) {
        return this.array() == value;
    }

    @Override
    public boolean throwsOnNullInput() {
        return true;
    }

    @Override
    public Value getNonNullInput() {
        return this.array();
    }

    @Override
    public void constrainType(TypeConstraintResolver constraintResolver) {
        constraintResolver.constrainArrayMemberType(this.type, this.value(), this.array(), t -> {
            this.type = t;
        });
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }
}

