/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfReturn;
import shadow.bundletool.com.android.tools.r8.cf.code.CfReturnVoid;
import shadow.bundletool.com.android.tools.r8.code.ReturnObject;
import shadow.bundletool.com.android.tools.r8.code.ReturnVoid;
import shadow.bundletool.com.android.tools.r8.code.ReturnWide;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.JumpInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public class Return
extends JumpInstruction {
    public Return() {
    }

    public Return(Value value) {
        super(value);
    }

    @Override
    public int opcode() {
        return 54;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean isReturnVoid() {
        return this.inValues.size() == 0;
    }

    public TypeLatticeElement getReturnType() {
        assert (!this.isReturnVoid());
        return this.returnValue().getTypeLattice();
    }

    public Value returnValue() {
        assert (!this.isReturnVoid());
        return (Value)this.inValues.get(0);
    }

    public shadow.bundletool.com.android.tools.r8.code.Instruction createDexInstruction(DexBuilder builder) {
        if (this.isReturnVoid()) {
            return new ReturnVoid();
        }
        int register = builder.allocatedRegister(this.returnValue(), this.getNumber());
        TypeLatticeElement returnType = this.getReturnType();
        if (returnType.isReference()) {
            return new ReturnObject(register);
        }
        if (returnType.isSinglePrimitive()) {
            return new shadow.bundletool.com.android.tools.r8.code.Return(register);
        }
        if (returnType.isWidePrimitive()) {
            return new ReturnWide(register);
        }
        throw new Unreachable();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addReturn(this, this.createDexInstruction(builder));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isReturn()) {
            return false;
        }
        Return o = other.asReturn();
        if (this.isReturnVoid()) {
            return o.isReturnVoid();
        }
        return this.getReturnType().isValueTypeCompatible(o.getReturnType());
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "Return defines no values.";
        return 0;
    }

    @Override
    public boolean isReturn() {
        return true;
    }

    @Override
    public Return asReturn() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forReturn();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        if (!this.isReturnVoid()) {
            helper.loadInValues(this, it);
        }
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(this.isReturnVoid() ? new CfReturnVoid() : new CfReturn(ValueType.fromTypeLattice(this.getReturnType())));
    }
}

