/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Predicates;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.UnknownValue;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.FixedRegisterValue;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueTypeConstraint;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.LiveIntervals;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntListIterator;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.MethodPosition;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.LongInterval;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class Value
implements Comparable<Value> {
    public static final int UNDEFINED_NUMBER = -1;
    public static final Value UNDEFINED = new Value(-1, TypeLatticeElement.BOTTOM, null);
    protected final int number;
    public Instruction definition = null;
    private LinkedList<Instruction> users = new LinkedList();
    private Set<Instruction> uniqueUsers = null;
    private LinkedList<Phi> phiUsers = new LinkedList();
    private Set<Phi> uniquePhiUsers = null;
    private Value nextConsecutive = null;
    private Value previousConsecutive = null;
    private LiveIntervals liveIntervals;
    private int needsRegister = -1;
    private boolean isThis = false;
    private boolean isArgument = false;
    private LongInterval valueRange;
    private DebugData debugData;
    protected TypeLatticeElement typeLattice;

    public void constrainType(ValueTypeConstraint constraint, DexMethod method, Origin origin, Reporter reporter) {
        TypeLatticeElement constrainedType = this.constrainedType(constraint);
        if (constrainedType == null) {
            throw reporter.fatalError(new StringDiagnostic("Cannot constrain type: " + this.typeLattice + " for value: " + this + " by constraint: " + (Object)((Object)constraint), origin, new MethodPosition(method)));
        }
        if (constrainedType != this.typeLattice) {
            this.setTypeLattice(constrainedType);
        }
    }

    public TypeLatticeElement constrainedType(ValueTypeConstraint constraint) {
        if (constraint == ValueTypeConstraint.INT_OR_FLOAT_OR_OBJECT && !this.typeLattice.isWidePrimitive()) {
            return this.typeLattice;
        }
        switch (constraint) {
            case OBJECT: {
                if (this.typeLattice.isTop()) {
                    if (this.definition != null && this.definition.isConstNumber()) {
                        assert (this.definition.asConstNumber().isZero());
                        return TypeLatticeElement.NULL;
                    }
                    return TypeLatticeElement.BOTTOM;
                }
                if (this.typeLattice.isReference()) {
                    return this.typeLattice;
                }
                if (!this.typeLattice.isBottom()) break;
                assert (this.isPhi() || this.definition.isDebugLocalWrite() || this.definition.isArrayGet() && this.definition.asArrayGet().getMemberType() == MemberType.OBJECT);
                return this.typeLattice;
            }
            case INT: {
                if (!this.typeLattice.isTop() && (!this.typeLattice.isSinglePrimitive() || this.typeLattice.isFloat())) break;
                return TypeLatticeElement.INT;
            }
            case FLOAT: {
                if (!this.typeLattice.isTop() && (!this.typeLattice.isSinglePrimitive() || this.typeLattice.isInt())) break;
                return TypeLatticeElement.FLOAT;
            }
            case INT_OR_FLOAT: {
                if (this.typeLattice.isTop()) {
                    return TypeLatticeElement.SINGLE;
                }
                if (!this.typeLattice.isSinglePrimitive()) break;
                return this.typeLattice;
            }
            case LONG: {
                if (!this.typeLattice.isWidePrimitive() || this.typeLattice.isDouble()) break;
                return TypeLatticeElement.LONG;
            }
            case DOUBLE: {
                if (!this.typeLattice.isWidePrimitive() || this.typeLattice.isLong()) break;
                return TypeLatticeElement.DOUBLE;
            }
            case LONG_OR_DOUBLE: {
                if (!this.typeLattice.isWidePrimitive()) break;
                return this.typeLattice;
            }
            default: {
                throw new Unreachable("Unexpected constraint: " + (Object)((Object)constraint));
            }
        }
        return null;
    }

    public boolean verifyCompatible(ValueType valueType) {
        return this.verifyCompatible(ValueTypeConstraint.fromValueType(valueType));
    }

    public boolean verifyCompatible(ValueTypeConstraint constraint) {
        assert (this.constrainedType(constraint) != null);
        return true;
    }

    public void markNonDebugLocalRead() {
        assert (!this.isPhi());
    }

    public Value(int number, TypeLatticeElement typeLattice, DebugLocalInfo local) {
        this.number = number;
        this.debugData = local == null ? null : new DebugData(local);
        this.typeLattice = typeLattice;
    }

    public boolean isFixedRegisterValue() {
        return false;
    }

    public FixedRegisterValue asFixedRegisterValue() {
        return null;
    }

    public Instruction getDefinition() {
        assert (!this.isPhi());
        return this.definition;
    }

    public boolean hasAliasedValue() {
        return this.getAliasedValue() != this;
    }

    public Value getAliasedValue() {
        return this.getAliasedValue(Predicates.alwaysFalse());
    }

    public Value getAliasedValue(Predicate<Value> stoppingCriterion) {
        Value lastAliasedValue;
        assert (stoppingCriterion != null);
        Set<Value> visited = Sets.newIdentityHashSet();
        Value aliasedValue = this;
        do {
            if (stoppingCriterion.test(aliasedValue)) {
                return aliasedValue;
            }
            lastAliasedValue = aliasedValue;
            if (aliasedValue.isPhi()) {
                return aliasedValue;
            }
            Instruction definitionOfAliasedValue = aliasedValue.definition;
            if (!definitionOfAliasedValue.isIntroducingAnAlias()) continue;
            aliasedValue = definitionOfAliasedValue.getAliasForOutValue();
            assert (visited.add(aliasedValue));
        } while (aliasedValue != lastAliasedValue);
        assert (aliasedValue.isPhi() || !aliasedValue.definition.isAssume());
        return aliasedValue;
    }

    public Value getSpecificAliasedValue(Predicate<Value> stoppingCriterion) {
        Value aliasedValue = this.getAliasedValue(stoppingCriterion);
        return stoppingCriterion.test(aliasedValue) ? aliasedValue : null;
    }

    public int getNumber() {
        return this.number;
    }

    public int requiredRegisters() {
        return this.typeLattice.requiredRegisters();
    }

    public DebugLocalInfo getLocalInfo() {
        return this.debugData == null ? null : this.debugData.local;
    }

    public boolean hasLocalInfo() {
        return this.getLocalInfo() != null;
    }

    public void setLocalInfo(DebugLocalInfo local) {
        assert (local != null);
        assert (this.debugData == null);
        this.debugData = new DebugData(local);
    }

    public void clearLocalInfo() {
        assert (this.debugData.users.isEmpty());
        this.debugData = null;
    }

    public boolean hasSameOrNoLocal(Value other) {
        assert (other != null);
        return this.hasLocalInfo() ? other.getLocalInfo() == this.getLocalInfo() : !other.hasLocalInfo();
    }

    public List<Instruction> getDebugLocalStarts() {
        if (this.debugData == null) {
            return Collections.emptyList();
        }
        ArrayList<Instruction> starts = new ArrayList<Instruction>(this.debugData.users.size());
        for (Map.Entry<Instruction, DebugUse> entry : this.debugData.users.entrySet()) {
            if (entry.getValue() != DebugUse.START) continue;
            starts.add(entry.getKey());
        }
        return starts;
    }

    public List<Instruction> getDebugLocalEnds() {
        if (this.debugData == null) {
            return Collections.emptyList();
        }
        ArrayList<Instruction> ends = new ArrayList<Instruction>(this.debugData.users.size());
        for (Map.Entry<Instruction, DebugUse> entry : this.debugData.users.entrySet()) {
            if (entry.getValue() != DebugUse.END) continue;
            ends.add(entry.getKey());
        }
        return ends;
    }

    public void addDebugLocalStart(Instruction start) {
        assert (start != null);
        this.debugData.users.put(start, this.markStart(this.debugData.users.get(start)));
    }

    private DebugUse markStart(DebugUse use) {
        assert (use != null);
        return use == null ? DebugUse.START : use.start();
    }

    public void addDebugLocalEnd(Instruction end) {
        assert (end != null);
        this.debugData.users.put(end, this.markEnd(this.debugData.users.get(end)));
    }

    private DebugUse markEnd(DebugUse use) {
        assert (use != null);
        return use == null ? DebugUse.END : use.end();
    }

    public void linkTo(Value other) {
        assert (this.nextConsecutive == null || this.nextConsecutive == other);
        assert (other.previousConsecutive == null || other.previousConsecutive == this);
        other.previousConsecutive = this;
        this.nextConsecutive = other;
    }

    public void replaceLink(Value newArgument) {
        assert (this.isLinked());
        if (this.previousConsecutive != null) {
            this.previousConsecutive.nextConsecutive = newArgument;
            newArgument.previousConsecutive = this.previousConsecutive;
            this.previousConsecutive = null;
        }
        if (this.nextConsecutive != null) {
            this.nextConsecutive.previousConsecutive = newArgument;
            newArgument.nextConsecutive = this.nextConsecutive;
            this.nextConsecutive = null;
        }
    }

    public boolean isLinked() {
        return this.nextConsecutive != null || this.previousConsecutive != null;
    }

    public Value getStartOfConsecutive() {
        Value current = this;
        while (current.getPreviousConsecutive() != null) {
            current = current.getPreviousConsecutive();
        }
        return current;
    }

    public Value getNextConsecutive() {
        return this.nextConsecutive;
    }

    public Value getPreviousConsecutive() {
        return this.previousConsecutive;
    }

    public boolean onlyUsedInBlock(BasicBlock block) {
        for (Instruction user : this.uniqueUsers()) {
            if (user.getBlock() == block) continue;
            return false;
        }
        return true;
    }

    public Set<Instruction> uniqueUsers() {
        if (this.uniqueUsers != null) {
            return this.uniqueUsers;
        }
        this.uniqueUsers = ImmutableSet.copyOf(this.users);
        return this.uniqueUsers;
    }

    public Instruction singleUniqueUser() {
        assert (ImmutableSet.copyOf(this.users).size() == 1);
        return this.users.getFirst();
    }

    public Set<Instruction> aliasedUsers() {
        Set<Instruction> users = SetUtils.newIdentityHashSet(this.uniqueUsers());
        Set<Instruction> visited = Sets.newIdentityHashSet();
        Value.collectAliasedUsersViaAssume(visited, this.uniqueUsers(), users);
        return users;
    }

    private static void collectAliasedUsersViaAssume(Set<Instruction> visited, Set<Instruction> usersToTest, Set<Instruction> collectedUsers) {
        for (Instruction user : usersToTest) {
            if (!visited.add(user) || !user.isAssume()) continue;
            collectedUsers.addAll(user.outValue().uniqueUsers());
            Value.collectAliasedUsersViaAssume(visited, user.outValue().uniqueUsers(), collectedUsers);
        }
    }

    public Phi firstPhiUser() {
        assert (!this.phiUsers.isEmpty());
        return this.phiUsers.getFirst();
    }

    public Set<Phi> uniquePhiUsers() {
        if (this.uniquePhiUsers != null) {
            return this.uniquePhiUsers;
        }
        this.uniquePhiUsers = ImmutableSet.copyOf(this.phiUsers);
        return this.uniquePhiUsers;
    }

    public Set<Instruction> debugUsers() {
        return this.debugData == null ? null : Collections.unmodifiableSet(this.debugData.users.keySet());
    }

    public boolean hasAnyUsers() {
        return this.hasUsers() || this.hasPhiUsers() || this.hasDebugUsers();
    }

    public boolean hasDebugUsers() {
        return this.debugData != null && !this.debugData.users.isEmpty();
    }

    public boolean hasPhiUsers() {
        return !this.phiUsers.isEmpty();
    }

    public boolean hasUsers() {
        return !this.users.isEmpty();
    }

    public int numberOfUsers() {
        int size = this.users.size();
        if (size <= 1) {
            return size;
        }
        return this.uniqueUsers().size();
    }

    public int numberOfPhiUsers() {
        int size = this.phiUsers.size();
        if (size <= 1) {
            return size;
        }
        return this.uniquePhiUsers().size();
    }

    public int numberOfAllNonDebugUsers() {
        return this.numberOfUsers() + this.numberOfPhiUsers();
    }

    public int numberOfDebugUsers() {
        return this.debugData == null ? 0 : this.debugData.users.size();
    }

    public int numberOfAllUsers() {
        return this.numberOfAllNonDebugUsers() + this.numberOfDebugUsers();
    }

    public boolean isUsed() {
        return !this.users.isEmpty() || !this.phiUsers.isEmpty() || this.numberOfDebugUsers() > 0;
    }

    public boolean isAlwaysNull(AppView<?> appView) {
        if (this.hasLocalInfo()) {
            return false;
        }
        if (this.typeLattice.isDefinitelyNull()) {
            return true;
        }
        if (this.typeLattice.isClassType() && ((AppInfo)appView.appInfo()).hasLiveness()) {
            return this.typeLattice.asClassTypeLatticeElement().getClassType().isAlwaysNull(appView.withLiveness());
        }
        return false;
    }

    public boolean usedInMonitorOperation() {
        for (Instruction instruction : this.uniqueUsers()) {
            if (!instruction.isMonitor()) continue;
            return true;
        }
        return false;
    }

    public void addUser(Instruction user) {
        this.users.add(user);
        this.uniqueUsers = null;
    }

    public void removeUser(Instruction user) {
        this.users.remove(user);
        this.uniqueUsers = null;
    }

    private void fullyRemoveUser(Instruction user) {
        this.users.removeIf(u -> u == user);
        this.uniqueUsers = null;
    }

    public void clearUsers() {
        this.users.clear();
        this.uniqueUsers = null;
        this.phiUsers.clear();
        this.uniquePhiUsers = null;
        if (this.debugData != null) {
            this.debugData.users.clear();
        }
    }

    public void addPhiUser(Phi user) {
        this.phiUsers.add(user);
        this.uniquePhiUsers = null;
    }

    public void removePhiUser(Phi user) {
        this.phiUsers.remove(user);
        this.uniquePhiUsers = null;
    }

    private void fullyRemovePhiUser(Phi user) {
        this.phiUsers.removeIf(u -> u == user);
        this.uniquePhiUsers = null;
    }

    public void addDebugUser(Instruction user) {
        assert (this.hasLocalInfo());
        this.debugData.users.putIfAbsent(user, DebugUse.LIVE);
    }

    public boolean isUninitializedLocal() {
        return this.definition != null && this.definition.isDebugLocalUninitialized();
    }

    public boolean isInitializedLocal() {
        return !this.isUninitializedLocal();
    }

    public void removeDebugUser(Instruction user) {
        if (this.debugData != null && this.debugData.users != null) {
            this.debugData.users.remove(user);
            return;
        }
        assert (false);
    }

    public boolean hasUsersInfo() {
        return this.users != null;
    }

    public void clearUsersInfo() {
        this.users = null;
        this.uniqueUsers = null;
        this.phiUsers = null;
        this.uniquePhiUsers = null;
        if (this.debugData != null) {
            this.debugData.users = null;
        }
    }

    public Set<Value> affectedValues() {
        ImmutableSet.Builder affectedValues = ImmutableSet.builder();
        for (Instruction user : this.uniqueUsers()) {
            if (user.outValue() == null) continue;
            affectedValues.add(user.outValue());
        }
        affectedValues.addAll(this.uniquePhiUsers());
        return affectedValues.build();
    }

    public void replaceUsers(Value newValue) {
        if (this == newValue) {
            return;
        }
        for (Instruction instruction : this.uniqueUsers()) {
            instruction.replaceValue(this, newValue);
        }
        for (Phi phi : this.uniquePhiUsers()) {
            phi.replaceOperand(this, newValue);
        }
        if (this.debugData != null) {
            for (Map.Entry entry : this.debugData.users.entrySet()) {
                this.replaceUserInDebugData(entry, newValue);
            }
            this.debugData.users.clear();
        }
        this.clearUsers();
    }

    public void replaceSelectiveUsers(Value newValue, Set<Instruction> selectedInstructions, Map<Phi, IntList> selectedPhisWithPredecessorIndexes) {
        if (this == newValue) {
            return;
        }
        for (Instruction instruction : this.uniqueUsers()) {
            if (!selectedInstructions.contains(instruction)) continue;
            this.fullyRemoveUser(instruction);
            instruction.replaceValue(this, newValue);
        }
        Set<Phi> selectedPhis = selectedPhisWithPredecessorIndexes.keySet();
        for (Phi phi : this.uniquePhiUsers()) {
            IntList positionsToUpdate;
            if (!selectedPhis.contains(phi)) continue;
            long count = phi.getOperands().stream().filter(operand -> operand == this).count();
            if (count == (long)(positionsToUpdate = selectedPhisWithPredecessorIndexes.get(phi)).size()) {
                this.fullyRemovePhiUser(phi);
            }
            IntListIterator intListIterator = positionsToUpdate.iterator();
            while (intListIterator.hasNext()) {
                int position = (Integer)intListIterator.next();
                assert (phi.getOperand(position) == this);
                phi.replaceOperandAt(position, newValue);
            }
        }
        if (this.debugData != null) {
            Iterator<Map.Entry<Instruction, DebugUse>> iterator2 = this.debugData.users.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Instruction, DebugUse> entry = iterator2.next();
                if (!selectedInstructions.contains(entry.getKey())) continue;
                this.replaceUserInDebugData(entry, newValue);
                iterator2.remove();
            }
        }
    }

    private void replaceUserInDebugData(Map.Entry<Instruction, DebugUse> user, Value newValue) {
        Instruction instruction = user.getKey();
        DebugUse debugUse = user.getValue();
        instruction.replaceDebugValue(this, newValue);
        if (newValue.hasLocalInfo()) {
            DebugUse existing = newValue.debugData.users.get(instruction);
            assert (existing != null);
            newValue.debugData.users.put(instruction, DebugUse.join(debugUse, existing));
        }
    }

    public void replaceDebugUser(Instruction oldUser, Instruction newUser) {
        DebugUse use = this.debugData.users.remove(oldUser);
        if (use == DebugUse.START && newUser.outValue == this) {
            return;
        }
        if (use != null) {
            newUser.addDebugValue(this);
            this.debugData.users.put(newUser, use);
        }
    }

    public void setLiveIntervals(LiveIntervals intervals) {
        assert (this.liveIntervals == null);
        this.liveIntervals = intervals;
    }

    public LiveIntervals getLiveIntervals() {
        return this.liveIntervals;
    }

    public boolean needsRegister() {
        assert (this.needsRegister >= 0);
        assert (!this.hasUsersInfo() || this.needsRegister > 0 == this.internalComputeNeedsRegister());
        return this.needsRegister > 0;
    }

    public void setNeedsRegister(boolean value) {
        assert (this.needsRegister == -1 || this.needsRegister > 0 == value);
        this.needsRegister = value ? 1 : 0;
    }

    public void computeNeedsRegister() {
        assert (this.needsRegister < 0);
        this.setNeedsRegister(this.internalComputeNeedsRegister());
    }

    public boolean internalComputeNeedsRegister() {
        if (!this.isConstNumber()) {
            return true;
        }
        if (this.numberOfPhiUsers() > 0) {
            return true;
        }
        for (Instruction user : this.uniqueUsers()) {
            if (!user.needsValueInRegister(this)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRegisterConstraint() {
        for (Instruction instruction : this.uniqueUsers()) {
            if (instruction.maxInValueRegister() == 65535) continue;
            return true;
        }
        return false;
    }

    public boolean isValueOnStack() {
        return false;
    }

    @Override
    public int compareTo(Value value) {
        return Integer.compare(this.number, value.number);
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        boolean isConstant;
        StringBuilder builder = new StringBuilder();
        builder.append("v");
        builder.append(this.number);
        boolean bl = isConstant = this.definition != null && this.definition.isConstNumber();
        if (isConstant || this.hasLocalInfo()) {
            builder.append("(");
            if (isConstant && this.definition.asConstNumber().outValue != null) {
                ConstNumber constNumber = this.definition.asConstNumber();
                if (constNumber.outValue().getTypeLattice().isSinglePrimitive()) {
                    builder.append((int)constNumber.getRawValue());
                } else {
                    builder.append(constNumber.getRawValue());
                }
            }
            if (isConstant && this.hasLocalInfo()) {
                builder.append(", ");
            }
            if (this.hasLocalInfo()) {
                builder.append(this.getLocalInfo());
            }
            builder.append(")");
        }
        if (this.valueRange != null) {
            builder.append(this.valueRange);
        }
        return builder.toString();
    }

    public ValueType outType() {
        return ValueType.fromTypeLattice(this.typeLattice);
    }

    public ConstInstruction getConstInstruction() {
        assert (this.isConstant());
        return this.definition.getOutConstantConstInstruction();
    }

    public boolean isConstNumber() {
        return this.isConstant() && this.getConstInstruction().isConstNumber();
    }

    public boolean isConstString() {
        return this.isConstant() && this.getConstInstruction().isConstString();
    }

    public boolean isDexItemBasedConstString() {
        return this.isConstant() && this.getConstInstruction().isDexItemBasedConstString();
    }

    public boolean isDexItemBasedConstStringThatNeedsToComputeClassName() {
        return this.isDexItemBasedConstString() && this.getConstInstruction().asDexItemBasedConstString().getNameComputationInfo().needsToComputeName();
    }

    public boolean isConstClass() {
        return this.isConstant() && this.getConstInstruction().isConstClass();
    }

    public boolean isConstant() {
        return this.definition.isOutConstant() && !this.hasLocalInfo();
    }

    public AbstractValue getAbstractValue(AppView<?> appView, DexType context) {
        if (!appView.enableWholeProgramOptimizations()) {
            return UnknownValue.getInstance();
        }
        Value root = this.getAliasedValue();
        if (root.isPhi()) {
            return UnknownValue.getInstance();
        }
        return root.definition.getAbstractValue(appView, context);
    }

    public boolean isPhi() {
        return false;
    }

    public Phi asPhi() {
        return null;
    }

    public boolean isNeverNull() {
        assert (this.typeLattice.isReference());
        return this.definition != null && this.definition.isAssumeNonNull() || this.typeLattice.nullability().isDefinitelyNotNull();
    }

    public void markAsArgument() {
        assert (!this.isArgument);
        assert (!this.isThis);
        this.isArgument = true;
    }

    public boolean isArgument() {
        return this.isArgument;
    }

    public boolean onlyDependsOnArgument() {
        if (this.isPhi()) {
            return false;
        }
        switch (this.definition.opcode()) {
            case 5: 
            case 12: 
            case 15: 
            case 16: 
            case 20: {
                return true;
            }
            case 10: {
                return this.definition.asCheckCast().object().onlyDependsOnArgument();
            }
            case 28: {
                return this.definition.asInstanceOf().value().onlyDependsOnArgument();
            }
        }
        return false;
    }

    public int computeArgumentPosition(IRCode code) {
        assert (this.isArgument);
        int position = 0;
        InstructionIterator instructionIterator = code.entryBlock().iterator();
        while (instructionIterator.hasNext()) {
            Instruction instruction = (Instruction)instructionIterator.next();
            assert (instruction.isArgument());
            if (instruction.outValue() == this) {
                return position;
            }
            ++position;
        }
        throw new Unreachable();
    }

    public boolean knownToBeBoolean() {
        return this.knownToBeBoolean(null);
    }

    public boolean knownToBeBoolean(Set<Phi> seen) {
        if (!this.getTypeLattice().isInt()) {
            return false;
        }
        if (this.isPhi()) {
            Phi self = this.asPhi();
            if (seen == null) {
                seen = Sets.newIdentityHashSet();
            }
            if (seen.contains(self)) {
                return true;
            }
            seen.add(self);
            for (Value operand : self.getOperands()) {
                if (operand.knownToBeBoolean(seen)) continue;
                operand.knownToBeBoolean(seen);
                return false;
            }
            return true;
        }
        assert (this.definition != null);
        return this.definition.outTypeKnownToBeBoolean(seen);
    }

    public void markAsThis() {
        assert (this.isArgument);
        assert (!this.isThis);
        this.isThis = true;
    }

    public boolean isThis() {
        return this.isThis;
    }

    public void setValueRange(LongInterval range) {
        this.valueRange = range;
    }

    public boolean hasValueRange() {
        return this.valueRange != null || this.isConstNumber();
    }

    public boolean isValueInRange(int value) {
        if (this.isConstNumber()) {
            return value == this.getConstInstruction().asConstNumber().getIntValue();
        }
        return this.valueRange != null && this.valueRange.containsValue(value);
    }

    public LongInterval getValueRange() {
        if (this.isConstNumber()) {
            if (this.typeLattice.isSinglePrimitive()) {
                int value = this.getConstInstruction().asConstNumber().getIntValue();
                return new LongInterval(value, value);
            }
            assert (this.typeLattice.isWidePrimitive());
            long value = this.getConstInstruction().asConstNumber().getLongValue();
            return new LongInterval(value, value);
        }
        return this.valueRange;
    }

    public boolean isDead(AppView<?> appView, IRCode code) {
        return !this.isUsed() || this.isDead(appView, code, Predicates.alwaysFalse());
    }

    public boolean isDead(AppView<?> appView, IRCode code, Predicate<Instruction> ignoreUser) {
        return !this.isUsed() || this.isDead(appView, code, ignoreUser, Sets.newIdentityHashSet());
    }

    protected boolean isDead(AppView<?> appView, IRCode code, Predicate<Instruction> ignoreUser, Set<Value> active) {
        if (active.size() > 100) {
            return false;
        }
        if (this.hasDebugUsers()) {
            return false;
        }
        active.add(this);
        for (Instruction instruction : this.uniqueUsers()) {
            if (ignoreUser.test(instruction)) continue;
            if (!instruction.canBeDeadCode(appView, code)) {
                return false;
            }
            Value outValue = instruction.outValue();
            if (outValue == null || active.contains(outValue) || outValue.isDead(appView, code, ignoreUser, active)) continue;
            return false;
        }
        for (Phi phi : this.uniquePhiUsers()) {
            if (active.contains(phi) || phi.isDead(appView, code, ignoreUser, active)) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        return this.isConstant() && this.getConstInstruction().isConstNumber() && this.getConstInstruction().asConstNumber().isZero();
    }

    public void setTypeLattice(TypeLatticeElement newType) {
        this.typeLattice = newType;
    }

    public void widening(AppView<?> appView, TypeLatticeElement newType) {
        assert (this.typeLattice.lessThanOrEqual(newType, appView)) : "During WIDENING, " + newType + " < " + this.typeLattice + " at " + (this.isPhi() ? this.asPhi().printPhi() : this.definition.toString());
        this.setTypeLattice(newType);
    }

    public void narrowing(AppView<?> appView, TypeLatticeElement newType) {
        assert (!appView.options().testing.enableNarrowingChecksInD8 && !appView.enableWholeProgramOptimizations() || !this.typeLattice.strictlyLessThan(newType, appView)) : "During NARROWING, " + this.typeLattice + " < " + newType + " at " + (this.isPhi() ? this.asPhi().printPhi() : this.definition.toString());
        this.setTypeLattice(newType);
    }

    public TypeLatticeElement getTypeLattice() {
        return this.typeLattice;
    }

    public TypeLatticeElement getDynamicUpperBoundType(AppView<? extends AppInfoWithSubtyping> appView) {
        TypeLatticeElement lattice;
        Value root = this.getAliasedValue();
        if (root.isPhi()) {
            assert (this.getSpecificAliasedValue(value -> !value.isPhi() && value.definition.isAssumeDynamicType()) == null);
            return root.getDynamicUpperBoundType(appView);
        }
        Value aliasedValue = this.getSpecificAliasedValue(value -> !value.isPhi() && value.definition.isAssumeDynamicType());
        if (aliasedValue != null) {
            lattice = aliasedValue.definition.asAssumeDynamicType().getAssumption().getDynamicUpperBoundType();
            assert (lattice.lessThanOrEqualUpToNullability(this.typeLattice, appView)) : this.typeLattice + " < " + lattice;
        } else {
            lattice = this.typeLattice;
        }
        if (this.typeLattice.isDefinitelyNotNull() && lattice.isNullable()) {
            assert (lattice.isReference());
            return lattice.asReferenceTypeLatticeElement().asMeetWithNotNull();
        }
        return lattice;
    }

    public ClassTypeLatticeElement getDynamicLowerBoundType(AppView<AppInfoWithLiveness> appView) {
        ClassTypeLatticeElement classType;
        DexType type;
        DexClass clazz;
        Value root = this.getAliasedValue();
        if (root.isPhi()) {
            return null;
        }
        Instruction definition = root.definition;
        if (definition.isNewInstance()) {
            DexType type2 = definition.asNewInstance().clazz;
            DexClass clazz2 = appView.definitionFor(type2);
            if (clazz2 != null && !clazz2.isInterface()) {
                return ClassTypeLatticeElement.create(type2, Nullability.definitelyNotNull(), appView);
            }
            return null;
        }
        Value aliasedValue = this.getSpecificAliasedValue(value -> value.definition.isAssumeDynamicType());
        if (aliasedValue != null) {
            ClassTypeLatticeElement lattice = aliasedValue.definition.asAssumeDynamicType().getAssumption().getDynamicLowerBoundType();
            return lattice != null && this.typeLattice.isDefinitelyNotNull() && lattice.isNullable() ? lattice.asMeetWithNotNull() : lattice;
        }
        if (this.getTypeLattice().isClassType() && (clazz = appView.definitionFor(type = (classType = this.getTypeLattice().asClassTypeLatticeElement()).getClassType())) != null && clazz.isEffectivelyFinal(appView)) {
            return classType;
        }
        return null;
    }

    private static final class DebugUse
    extends Enum<DebugUse> {
        public static final /* enum */ DebugUse LIVE = new DebugUse();
        public static final /* enum */ DebugUse START = new DebugUse();
        public static final /* enum */ DebugUse END = new DebugUse();
        public static final /* enum */ DebugUse LIVE_FINAL = new DebugUse();
        private static final /* synthetic */ DebugUse[] $VALUES;

        public static DebugUse[] values() {
            return (DebugUse[])$VALUES.clone();
        }

        public static DebugUse valueOf(String name) {
            return Enum.valueOf(DebugUse.class, name);
        }

        DebugUse start() {
            switch (this) {
                case LIVE: 
                case START: {
                    return START;
                }
                case END: 
                case LIVE_FINAL: {
                    return LIVE_FINAL;
                }
            }
            throw new Unreachable();
        }

        DebugUse end() {
            switch (this) {
                case LIVE: 
                case END: {
                    return END;
                }
                case START: 
                case LIVE_FINAL: {
                    return LIVE_FINAL;
                }
            }
            throw new Unreachable();
        }

        static DebugUse join(DebugUse a, DebugUse b) {
            if (a == LIVE_FINAL || b == LIVE_FINAL) {
                return LIVE_FINAL;
            }
            if (a == b) {
                return a;
            }
            if (a == LIVE) {
                return b;
            }
            if (b == LIVE) {
                return a;
            }
            assert (a == START && b == END || a == END && b == START);
            return LIVE_FINAL;
        }

        static {
            $VALUES = new DebugUse[]{LIVE, START, END, LIVE_FINAL};
        }
    }

    private static class DebugData {
        final DebugLocalInfo local;
        Map<Instruction, DebugUse> users = new HashMap<Instruction, DebugUse>();

        DebugData(DebugLocalInfo local) {
            this.local = local;
        }
    }
}

