/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallGraphBuilderBase;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

public class PartialCallGraphBuilder
extends CallGraphBuilderBase {
    private final Set<DexEncodedMethod> seeds;

    PartialCallGraphBuilder(AppView<AppInfoWithLiveness> appView, Set<DexEncodedMethod> seeds) {
        super(appView);
        assert (seeds != null && !seeds.isEmpty());
        this.seeds = seeds;
    }

    @Override
    void process(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.seeds, this::processMethod, executorService);
    }

    private void processMethod(DexEncodedMethod method) {
        if (method.hasCode()) {
            method.registerCodeReferences(new CallGraphBuilderBase.InvokeExtractor(this, this.getOrCreateNode(method), this.seeds::contains));
        }
    }

    @Override
    boolean verifyAllMethodsWithCodeExists() {
        for (DexEncodedMethod method : this.seeds) {
            assert (!method.hasCode() || this.nodes.get(method.method) != null);
        }
        return true;
    }
}

