/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.CfCode;
import shadow.bundletool.com.android.tools.r8.graph.ClassAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryAPIConverter;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.DesugaredLibraryAPIConversionCfCodeProvider;
import shadow.bundletool.com.android.tools.r8.origin.SynthesizedOrigin;
import shadow.bundletool.com.android.tools.r8.utils.Box;
import shadow.bundletool.com.android.tools.r8.utils.Pair;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class DesugaredLibraryWrapperSynthesizer {
    public static final String WRAPPER_PREFIX = "$r8$wrapper$";
    public static final String TYPE_WRAPPER_SUFFIX = "$-WRP";
    public static final String VIVIFIED_TYPE_WRAPPER_SUFFIX = "$-V-WRP";
    private final AppView<?> appView;
    private final Map<DexType, Pair<DexType, DexProgramClass>> typeWrappers = new ConcurrentHashMap<DexType, Pair<DexType, DexProgramClass>>();
    private final Map<DexType, Pair<DexType, DexProgramClass>> vivifiedTypeWrappers = new ConcurrentHashMap<DexType, Pair<DexType, DexProgramClass>>();
    private final Set<DexType> invalidWrappers = Sets.newConcurrentHashSet();
    private final Set<DexType> generatedWrappers = Sets.newConcurrentHashSet();
    private final DexItemFactory factory;
    private final DesugaredLibraryAPIConverter converter;

    DesugaredLibraryWrapperSynthesizer(AppView<?> appView, DesugaredLibraryAPIConverter converter) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.converter = converter;
    }

    public static boolean isSynthesizedWrapper(DexType clazz) {
        return clazz.descriptor.toString().contains(WRAPPER_PREFIX);
    }

    boolean hasSynthesized(DexType type) {
        return this.generatedWrappers.contains(type);
    }

    boolean canGenerateWrapper(DexType type) {
        DexClass dexClass = this.appView.definitionFor(type);
        if (dexClass == null) {
            return false;
        }
        return dexClass.isLibraryClass() || this.appView.options().isDesugaredLibraryCompilation();
    }

    DexType getTypeWrapper(DexType type) {
        return this.getWrapper(type, TYPE_WRAPPER_SUFFIX, this.typeWrappers, this::generateTypeWrapper);
    }

    DexType getVivifiedTypeWrapper(DexType type) {
        return this.getWrapper(type, VIVIFIED_TYPE_WRAPPER_SUFFIX, this.vivifiedTypeWrappers, this::generateVivifiedTypeWrapper);
    }

    private DexType createWrapperType(DexType type, String suffix) {
        String desugaredLibPrefix = this.appView.options().desugaredLibraryConfiguration.getSynthesizedLibraryClassesPackagePrefix(this.appView);
        return this.factory.createType("L" + desugaredLibPrefix + WRAPPER_PREFIX + type.toString().replace('.', '$') + suffix + ";");
    }

    private DexType getWrapper(DexType type, String suffix, Map<DexType, Pair<DexType, DexProgramClass>> wrappers, BiFunction<DexClass, DexType, DexProgramClass> wrapperGenerator) {
        assert (!type.toString().startsWith("$-vivified-$."));
        Box<Boolean> toGenerate = new Box<Boolean>(false);
        Pair pair = wrappers.computeIfAbsent(type, t -> {
            toGenerate.set(true);
            DexType wrapperType = this.createWrapperType(type, suffix);
            this.generatedWrappers.add(wrapperType);
            return new Pair<DexType, Object>(wrapperType, null);
        });
        if (toGenerate.get().booleanValue()) {
            assert (pair.getSecond() == null);
            DexClass dexClass = this.appView.definitionFor(type);
            assert (dexClass != null && (dexClass.isLibraryClass() || this.appView.options().isDesugaredLibraryCompilation()));
            if (dexClass.accessFlags.isFinal()) {
                throw this.appView.options().reporter.fatalError(new StringDiagnostic("Cannot generate a wrapper for final class " + dexClass.type + ". Add a custom conversion in the desugared library."));
            }
            pair.setSecond(wrapperGenerator.apply(dexClass, (DexType)pair.getFirst()));
        }
        return (DexType)pair.getFirst();
    }

    private DexType vivifiedTypeFor(DexType type) {
        return DesugaredLibraryAPIConverter.vivifiedTypeFor(type, this.appView);
    }

    private DexProgramClass generateTypeWrapper(DexClass dexClass, DexType typeWrapperType) {
        DexType type = dexClass.type;
        DexEncodedField wrapperField = this.synthesizeWrappedValueField(typeWrapperType, type);
        return this.synthesizeWrapper(this.vivifiedTypeFor(type), dexClass, this.synthesizeVirtualMethodsForTypeWrapper(dexClass, wrapperField), wrapperField);
    }

    private DexProgramClass generateVivifiedTypeWrapper(DexClass dexClass, DexType vivifiedTypeWrapperType) {
        DexType type = dexClass.type;
        DexEncodedField wrapperField = this.synthesizeWrappedValueField(vivifiedTypeWrapperType, this.vivifiedTypeFor(type));
        return this.synthesizeWrapper(type, dexClass, this.synthesizeVirtualMethodsForVivifiedTypeWrapper(dexClass, wrapperField), wrapperField);
    }

    private DexProgramClass synthesizeWrapper(DexType wrappingType, DexClass clazz, DexEncodedMethod[] virtualMethods, DexEncodedField wrapperField) {
        boolean isItf = clazz.isInterface();
        DexType superType = isItf ? this.factory.objectType : wrappingType;
        DexTypeList interfaces = isItf ? new DexTypeList(new DexType[]{wrappingType}) : DexTypeList.empty();
        return new DexProgramClass(wrapperField.field.holder, null, new SynthesizedOrigin("Desugared library API Converter", this.getClass()), ClassAccessFlags.fromSharedAccessFlags(4113), superType, interfaces, clazz.sourceFile, null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, new DexEncodedField[]{wrapperField}, new DexEncodedMethod[]{this.synthesizeConstructor(wrapperField.field)}, virtualMethods, this.factory.getSkipNameValidationForTesting(), this.getChecksumSupplier(this, clazz.type), Collections.emptyList());
    }

    private DexProgramClass.ChecksumSupplier getChecksumSupplier(DesugaredLibraryWrapperSynthesizer synthesizer, DexType keyType) {
        return clazz -> {
            boolean hasWrapper = synthesizer.typeWrappers.containsKey(keyType);
            boolean hasViviWrapper = synthesizer.vivifiedTypeWrappers.containsKey(keyType);
            return (long)clazz.type.hashCode() + 7L * (long)Boolean.hashCode(hasWrapper) + 11L * (long)Boolean.hashCode(hasViviWrapper);
        };
    }

    private DexEncodedMethod[] synthesizeVirtualMethodsForVivifiedTypeWrapper(DexClass dexClass, DexEncodedField wrapperField) {
        List<DexEncodedMethod> dexMethods = this.allImplementedMethods(dexClass);
        ArrayList<DexEncodedMethod> generatedMethods = new ArrayList<DexEncodedMethod>();
        Set<DexMethod> finalMethods = Sets.newIdentityHashSet();
        for (DexEncodedMethod dexEncodedMethod : dexMethods) {
            DexClass holderClass = this.appView.definitionFor(dexEncodedMethod.method.holder);
            assert (holderClass != null);
            DexMethod methodToInstall = this.factory.createMethod(wrapperField.field.holder, dexEncodedMethod.method.proto, dexEncodedMethod.method.name);
            if (dexEncodedMethod.isFinal()) {
                this.invalidWrappers.add(wrapperField.field.holder);
                finalMethods.add(dexEncodedMethod.method);
                continue;
            }
            CfCode cfCode = new DesugaredLibraryAPIConversionCfCodeProvider.APIConverterVivifiedWrapperCfCodeProvider(this.appView, methodToInstall, wrapperField.field, this.converter, holderClass.isInterface()).generateCfCode();
            DexEncodedMethod newDexEncodedMethod = this.newSynthesizedMethod(methodToInstall, dexEncodedMethod, cfCode);
            generatedMethods.add(newDexEncodedMethod);
        }
        return this.finalizeWrapperMethods(generatedMethods, finalMethods);
    }

    private DexEncodedMethod[] synthesizeVirtualMethodsForTypeWrapper(DexClass dexClass, DexEncodedField wrapperField) {
        List<DexEncodedMethod> dexMethods = this.allImplementedMethods(dexClass);
        ArrayList<DexEncodedMethod> generatedMethods = new ArrayList<DexEncodedMethod>();
        Set<DexMethod> finalMethods = Sets.newIdentityHashSet();
        for (DexEncodedMethod dexEncodedMethod : dexMethods) {
            DexClass holderClass = this.appView.definitionFor(dexEncodedMethod.method.holder);
            assert (holderClass != null || this.appView.options().isDesugaredLibraryCompilation());
            boolean isInterface = holderClass == null || holderClass.isInterface();
            DexMethod methodToInstall = DesugaredLibraryAPIConverter.methodWithVivifiedTypeInSignature(dexEncodedMethod.method, wrapperField.field.holder, this.appView);
            if (dexEncodedMethod.isFinal()) {
                this.invalidWrappers.add(wrapperField.field.holder);
                finalMethods.add(dexEncodedMethod.method);
                continue;
            }
            CfCode cfCode = new DesugaredLibraryAPIConversionCfCodeProvider.APIConverterWrapperCfCodeProvider(this.appView, dexEncodedMethod.method, wrapperField.field, this.converter, isInterface).generateCfCode();
            DexEncodedMethod newDexEncodedMethod = this.newSynthesizedMethod(methodToInstall, dexEncodedMethod, cfCode);
            generatedMethods.add(newDexEncodedMethod);
        }
        return this.finalizeWrapperMethods(generatedMethods, finalMethods);
    }

    private DexEncodedMethod[] finalizeWrapperMethods(List<DexEncodedMethod> generatedMethods, Set<DexMethod> finalMethods) {
        if (finalMethods.isEmpty()) {
            return generatedMethods.toArray(DexEncodedMethod.EMPTY_ARRAY);
        }
        this.reportFinalMethodsInWrapper(finalMethods);
        return DexEncodedMethod.EMPTY_ARRAY;
    }

    private void reportFinalMethodsInWrapper(Set<DexMethod> methods) {
        Object[] methodArray = (String[])methods.stream().map(method -> method.holder + "#" + method.name).toArray(String[]::new);
        this.appView.options().reporter.warning(new StringDiagnostic("Desugared library API conversion: cannot wrap final methods " + Arrays.toString(methodArray) + ". " + methods.iterator().next().holder + " is marked as invalid and will throw a runtime exception upon conversion."));
    }

    DexEncodedMethod newSynthesizedMethod(DexMethod methodToInstall, DexEncodedMethod template, Code code) {
        MethodAccessFlags newFlags = template.accessFlags.copy();
        assert (newFlags.isPublic());
        newFlags.unsetAbstract();
        newFlags.unsetBridge();
        newFlags.setSynthetic();
        return new DexEncodedMethod(methodToInstall, newFlags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), code, true);
    }

    private List<DexEncodedMethod> allImplementedMethods(DexClass libraryClass) {
        LinkedList<DexClass> workList = new LinkedList<DexClass>();
        ArrayList<DexEncodedMethod> implementedMethods = new ArrayList<DexEncodedMethod>();
        workList.add(libraryClass);
        while (!workList.isEmpty()) {
            DexClass dexClass = (DexClass)workList.removeFirst();
            for (DexEncodedMethod virtualMethod : dexClass.virtualMethods()) {
                if (virtualMethod.isPrivateMethod()) continue;
                boolean alreadyAdded = false;
                for (DexEncodedMethod alreadyImplementedMethod : implementedMethods) {
                    if (!alreadyImplementedMethod.method.match(virtualMethod.method)) continue;
                    alreadyAdded = true;
                }
                if (alreadyAdded) continue;
                implementedMethods.add(virtualMethod);
            }
            for (DexType itf : dexClass.interfaces.values) {
                DexClass itfClass = this.appView.definitionFor(itf);
                assert (itfClass != null || this.appView.options().isDesugaredLibraryCompilation());
                if (itfClass == null) continue;
                workList.add(itfClass);
            }
            if (dexClass.superType == this.factory.objectType) continue;
            DexClass superClass = this.appView.definitionFor(dexClass.superType);
            assert (superClass != null);
            workList.add(superClass);
        }
        return implementedMethods;
    }

    private DexEncodedField synthesizeWrappedValueField(DexType holder, DexType fieldType) {
        DexField field = this.factory.createField(holder, fieldType, this.factory.wrapperFieldName);
        FieldAccessFlags fieldAccessFlags = FieldAccessFlags.fromCfAccessFlags(4112);
        return new DexEncodedField(field, fieldAccessFlags, DexAnnotationSet.empty(), null);
    }

    private DexEncodedMethod synthesizeConstructor(DexField field) {
        DexMethod method = this.factory.createMethod(field.holder, this.factory.createProto(this.factory.voidType, field.type), this.factory.initMethodName);
        return this.newSynthesizedMethod(method, 4098, true, new DesugaredLibraryAPIConversionCfCodeProvider.APIConverterConstructorCfCodeProvider(this.appView, field).generateCfCode());
    }

    private DexEncodedMethod newSynthesizedMethod(DexMethod methodToInstall, int flags, boolean constructor, Code code) {
        MethodAccessFlags accessFlags = MethodAccessFlags.fromSharedAccessFlags(flags, constructor);
        return new DexEncodedMethod(methodToInstall, accessFlags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), code, true);
    }

    void finalizeWrappers(DexApplication.Builder<?> builder, IRConverter irConverter, ExecutorService executorService) throws ExecutionException {
        assert (this.verifyAllClassesGenerated());
        this.registerWrappers(builder, this.typeWrappers);
        this.registerWrappers(builder, this.vivifiedTypeWrappers);
        this.finalizeWrappers(irConverter, executorService, this.typeWrappers, this::generateTypeConversions);
        this.finalizeWrappers(irConverter, executorService, this.vivifiedTypeWrappers, this::generateVivifiedTypeConversions);
    }

    private void registerWrappers(DexApplication.Builder<?> builder, Map<DexType, Pair<DexType, DexProgramClass>> wrappers) {
        for (DexType type : wrappers.keySet()) {
            DexProgramClass pgrmClass = wrappers.get(type).getSecond();
            assert (pgrmClass != null);
            this.registerSynthesizedClass(pgrmClass, builder);
        }
    }

    private void finalizeWrappers(IRConverter irConverter, ExecutorService executorService, Map<DexType, Pair<DexType, DexProgramClass>> wrappers, BiConsumer<DexType, DexProgramClass> generateConversions) throws ExecutionException {
        for (DexType type : wrappers.keySet()) {
            DexProgramClass pgrmClass = wrappers.get(type).getSecond();
            assert (pgrmClass != null);
            generateConversions.accept(type, pgrmClass);
            irConverter.optimizeSynthesizedClass(pgrmClass, executorService);
        }
    }

    private boolean verifyAllClassesGenerated() {
        for (Pair<DexType, DexProgramClass> pair : this.vivifiedTypeWrappers.values()) {
            assert (pair.getSecond() != null);
        }
        for (Pair<DexType, DexProgramClass> pair : this.typeWrappers.values()) {
            assert (pair.getSecond() != null);
        }
        return true;
    }

    private void registerSynthesizedClass(DexProgramClass synthesizedClass, DexApplication.Builder<?> builder) {
        builder.addSynthesizedClass(synthesizedClass, false);
        ((AppInfo)this.appView.appInfo()).addSynthesizedClass(synthesizedClass);
    }

    private void generateTypeConversions(DexType type, DexProgramClass synthesizedClass) {
        Pair<DexType, DexProgramClass> reverse = this.vivifiedTypeWrappers.get(type);
        assert (reverse == null || reverse.getSecond() != null);
        synthesizedClass.addDirectMethod(this.synthesizeConversionMethod(synthesizedClass.type, type, type, this.vivifiedTypeFor(type), reverse == null ? null : (DexClass)reverse.getSecond()));
    }

    private void generateVivifiedTypeConversions(DexType type, DexProgramClass synthesizedClass) {
        Pair<DexType, DexProgramClass> reverse = this.typeWrappers.get(type);
        synthesizedClass.addDirectMethod(this.synthesizeConversionMethod(synthesizedClass.type, type, this.vivifiedTypeFor(type), type, reverse == null ? null : (DexClass)reverse.getSecond()));
    }

    private DexEncodedMethod synthesizeConversionMethod(DexType holder, DexType type, DexType argType, DexType returnType, DexClass reverseWrapperClassOrNull) {
        CfCode cfCode;
        DexMethod method = this.factory.createMethod(holder, this.factory.createProto(returnType, argType), this.factory.convertMethodName);
        if (this.invalidWrappers.contains(holder)) {
            cfCode = new DesugaredLibraryAPIConversionCfCodeProvider.APIConverterThrowRuntimeExceptionCfCodeProvider(this.appView, this.factory.createString("Unsupported conversion for " + type + ". See compilation time warnings for more details."), holder).generateCfCode();
        } else {
            DexField uniqueFieldOrNull = reverseWrapperClassOrNull == null ? null : reverseWrapperClassOrNull.instanceFields().get((int)0).field;
            cfCode = new DesugaredLibraryAPIConversionCfCodeProvider.APIConverterWrapperConversionCfCodeProvider(this.appView, argType, uniqueFieldOrNull, this.factory.createField(holder, returnType, this.factory.wrapperFieldName)).generateCfCode();
        }
        return this.newSynthesizedMethod(method, 4105, false, cfCode);
    }
}

