/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.BiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.HashBiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DefaultUseRegistry;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeCustom;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.conversion.LensCodeRewriter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaClass;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaDescriptor;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaRewriterGraphLense;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackDelayed;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public class LambdaRewriter {
    public static final String LAMBDA_CLASS_NAME_PREFIX = "-$$Lambda$";
    public static final String LAMBDA_GROUP_CLASS_NAME_PREFIX = "-$$LambdaGroup$";
    static final String EXPECTED_LAMBDA_METHOD_PREFIX = "lambda$";
    private static final String LAMBDA_INSTANCE_FIELD_NAME = "INSTANCE";
    private final AppView<?> appView;
    final DexMethod objectInitMethod;
    final DexString constructorName;
    final DexString classConstructorName;
    final DexString instanceFieldName;
    final BiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
    private final Map<DexCallSite, LambdaDescriptor> knownCallSites = new IdentityHashMap<DexCallSite, LambdaDescriptor>();
    private final Map<DexType, LambdaClass> knownLambdaClasses = new IdentityHashMap<DexType, LambdaClass>();

    public static boolean hasLambdaClassPrefix(DexType clazz) {
        return clazz.getName().startsWith(LAMBDA_CLASS_NAME_PREFIX);
    }

    public LambdaRewriter(AppView<?> appView) {
        this.appView = appView;
        this.constructorName = this.getFactory().createString("<init>");
        DexProto initProto = this.getFactory().createProto(this.getFactory().voidType, new DexType[0]);
        this.objectInitMethod = this.getFactory().createMethod(this.getFactory().objectType, initProto, this.constructorName);
        this.classConstructorName = this.getFactory().createString("<clinit>");
        this.instanceFieldName = this.getFactory().createString(LAMBDA_INSTANCE_FIELD_NAME);
    }

    public AppView<?> getAppView() {
        return this.appView;
    }

    public AppInfo getAppInfo() {
        return this.getAppView().appInfo();
    }

    public DexItemFactory getFactory() {
        return this.getAppView().dexItemFactory();
    }

    public void synthesizeLambdaClassesForWave(Collection<DexEncodedMethod> wave, ExecutorService executorService, OptimizationFeedbackDelayed feedback, LensCodeRewriter lensCodeRewriter, IRConverter converter) throws ExecutionException {
        Set<DexProgramClass> synthesizedLambdaClasses = Sets.newIdentityHashSet();
        for (DexEncodedMethod dexEncodedMethod : wave) {
            this.synthesizeLambdaClassesForMethod(dexEncodedMethod, synthesizedLambdaClasses::add, lensCodeRewriter);
        }
        if (synthesizedLambdaClasses.isEmpty()) {
            return;
        }
        IdentityHashMap<DexEncodedField, Set<DexEncodedMethod>> writesWithContexts = new IdentityHashMap<DexEncodedField, Set<DexEncodedMethod>>();
        for (DexProgramClass synthesizedLambdaClass : synthesizedLambdaClasses) {
            DexEncodedMethod clinit = synthesizedLambdaClass.getClassInitializer();
            if (clinit == null) continue;
            for (DexEncodedField field : synthesizedLambdaClass.staticFields()) {
                writesWithContexts.put(field, ImmutableSet.of(clinit));
            }
        }
        AppView<AppInfoWithLiveness> appView = this.getAppView().withLiveness();
        appView.setAppInfo(appView.appInfo().withStaticFieldWrites(writesWithContexts));
        converter.optimizeSynthesizedLambdaClasses(synthesizedLambdaClasses, executorService);
        feedback.updateVisibleOptimizationInfo();
    }

    public void synthesizeLambdaClassesForMethod(final DexEncodedMethod method, final Consumer<DexProgramClass> consumer, final LensCodeRewriter lensCodeRewriter) {
        if (!method.hasCode() || method.isProcessed()) {
            return;
        }
        Code code = method.getCode();
        if (!code.isCfCode()) {
            return;
        }
        code.registerCodeReferences(method, new DefaultUseRegistry(this.getFactory()){

            @Override
            public void registerCallSite(DexCallSite callSite) {
                LambdaDescriptor descriptor = LambdaRewriter.this.inferLambdaDescriptor(lensCodeRewriter.rewriteCallSite(callSite, method));
                if (descriptor != LambdaDescriptor.MATCH_FAILED) {
                    consumer.accept(LambdaRewriter.this.getOrCreateLambdaClass(descriptor, method.method.holder).getOrCreateLambdaClass());
                }
            }
        });
    }

    public void desugarLambdas(DexEncodedMethod encodedMethod, IRCode code) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        DexType currentType = encodedMethod.method.holder;
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator instructions = block.listIterator(code);
            while (instructions.hasNext()) {
                LambdaClass lambdaClass;
                InvokeCustom invoke;
                LambdaDescriptor descriptor;
                Instruction instruction = (Instruction)instructions.next();
                if (!instruction.isInvokeCustom() || (descriptor = this.inferLambdaDescriptor((invoke = instruction.asInvokeCustom()).getCallSite())) == LambdaDescriptor.MATCH_FAILED) continue;
                LambdaClass lambdaClass2 = lambdaClass = this.getAppView().enableWholeProgramOptimizations() ? this.getKnownLambdaClass(descriptor, currentType) : this.getOrCreateLambdaClass(descriptor, currentType);
                assert (lambdaClass != null);
                this.patchInstruction(invoke, lambdaClass, code, blocks, instructions, affectedValues);
            }
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.getAppView()).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
    }

    public boolean removeLambdaDeserializationMethods(Iterable<DexProgramClass> classes) {
        for (DexProgramClass clazz : classes) {
            List<DexEncodedMethod> directMethods = clazz.directMethods();
            if (directMethods == null) continue;
            int methodCount = directMethods.size();
            for (int i = 0; i < methodCount; ++i) {
                DexEncodedMethod encoded = directMethods.get(i);
                DexMethod method = encoded.method;
                if (!method.isLambdaDeserializeMethod(this.getFactory())) continue;
                assert (encoded.accessFlags.isStatic());
                assert (encoded.accessFlags.isSynthetic());
                clazz.removeDirectMethod(i);
                return true;
            }
        }
        return false;
    }

    public void adjustAccessibility(IRConverter converter, OptimizationFeedback feedback) {
        for (LambdaClass lambdaClass : this.knownLambdaClasses.values()) {
            lambdaClass.target.ensureAccessibility(converter, feedback);
        }
        if (this.getAppView().enableWholeProgramOptimizations() && !this.methodMapping.isEmpty()) {
            this.getAppView().setGraphLense(new LambdaRewriterGraphLense(this.methodMapping, this.getAppView().graphLense(), this.getFactory()));
        }
    }

    public DexProgramClass getLambdaClass(DexType type) {
        LambdaClass lambdaClass = LambdaRewriter.getKnown(this.knownLambdaClasses, type);
        return lambdaClass == null ? null : lambdaClass.getOrCreateLambdaClass();
    }

    public void synthesizeLambdaClasses(DexApplication.Builder<?> builder) {
        for (LambdaClass lambdaClass : this.knownLambdaClasses.values()) {
            DexProgramClass synthesizedClass = lambdaClass.getOrCreateLambdaClass();
            this.getAppInfo().addSynthesizedClass(synthesizedClass);
            builder.addSynthesizedClass(synthesizedClass, lambdaClass.addToMainDexList.get());
        }
    }

    public void optimizeSynthesizedClasses(IRConverter converter, ExecutorService executorService) throws ExecutionException {
        converter.optimizeSynthesizedClasses(this.knownLambdaClasses.values().stream().map(LambdaClass::getOrCreateLambdaClass).collect(ImmutableSet.toImmutableSet()), executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DexCallSite> getDesugaredCallSites() {
        Map<DexCallSite, LambdaDescriptor> map2 = this.knownCallSites;
        synchronized (map2) {
            return this.knownCallSites.keySet();
        }
    }

    private LambdaDescriptor inferLambdaDescriptor(DexCallSite callSite) {
        LambdaDescriptor descriptor = LambdaRewriter.getKnown(this.knownCallSites, callSite);
        return descriptor != null ? descriptor : LambdaRewriter.putIfAbsent(this.knownCallSites, callSite, LambdaDescriptor.infer(callSite, this.getAppInfo()));
    }

    private boolean isInMainDexList(DexType type) {
        return this.getAppInfo().isInMainDexList(type);
    }

    private LambdaClass getOrCreateLambdaClass(LambdaDescriptor descriptor, DexType accessedFrom) {
        DexType lambdaClassType = LambdaClass.createLambdaClassType(this, accessedFrom, descriptor);
        LambdaClass lambdaClass = LambdaRewriter.getKnown(this.knownLambdaClasses, lambdaClassType);
        if (lambdaClass == null) {
            lambdaClass = LambdaRewriter.putIfAbsent(this.knownLambdaClasses, lambdaClassType, new LambdaClass(this, accessedFrom, lambdaClassType, descriptor));
            if (this.getAppView().options().isDesugaredLibraryCompilation()) {
                DexType rewrittenType = this.getAppView().rewritePrefix.rewrittenType(accessedFrom);
                if (rewrittenType == null) {
                    rewrittenType = this.getAppView().options().desugaredLibraryConfiguration.getEmulateLibraryInterface().get(accessedFrom);
                }
                if (rewrittenType != null) {
                    this.addRewritingPrefix(accessedFrom, rewrittenType, lambdaClassType);
                }
            }
        }
        lambdaClass.addSynthesizedFrom(this.getAppView().definitionFor(accessedFrom).asProgramClass());
        if (this.isInMainDexList(accessedFrom)) {
            lambdaClass.addToMainDexList.set(true);
        }
        return lambdaClass;
    }

    private LambdaClass getKnownLambdaClass(LambdaDescriptor descriptor, DexType accessedFrom) {
        DexType lambdaClassType = LambdaClass.createLambdaClassType(this, accessedFrom, descriptor);
        return LambdaRewriter.getKnown(this.knownLambdaClasses, lambdaClassType);
    }

    private void addRewritingPrefix(DexType type, DexType rewritten, DexType lambdaClassType) {
        String javaName = lambdaClassType.toString();
        String typeString = type.toString();
        String actualPrefix = typeString.substring(0, typeString.lastIndexOf(46));
        String rewrittenString = rewritten.toString();
        String actualRewrittenPrefix = rewrittenString.substring(0, rewrittenString.lastIndexOf(46));
        assert (javaName.startsWith(actualPrefix));
        this.getAppView().rewritePrefix.rewriteType(lambdaClassType, this.getFactory().createType(DescriptorUtils.javaTypeToDescriptor(actualRewrittenPrefix + javaName.substring(actualPrefix.length()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> V getKnown(Map<K, V> map2, K key) {
        Map<K, V> map3 = map2;
        synchronized (map3) {
            return map2.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> V putIfAbsent(Map<K, V> map2, K key, V value) {
        Map<K, V> map3 = map2;
        synchronized (map3) {
            V known = map2.get(key);
            if (known != null) {
                return known;
            }
            map2.put(key, value);
            return value;
        }
    }

    private void patchInstruction(InvokeCustom invoke, LambdaClass lambdaClass, IRCode code, ListIterator<BasicBlock> blocks, InstructionListIterator instructions, Set<Value> affectedValues) {
        assert (lambdaClass != null);
        assert (instructions != null);
        Value lambdaInstanceValue = invoke.outValue();
        if (lambdaInstanceValue == null) {
            lambdaInstanceValue = code.createValue(TypeLatticeElement.fromDexType(lambdaClass.type, Nullability.maybeNull(), this.getAppView()));
        } else {
            affectedValues.add(lambdaInstanceValue);
        }
        if (lambdaClass.isStateless()) {
            instructions.replaceCurrentInstruction(new StaticGet(lambdaInstanceValue, lambdaClass.lambdaField));
            return;
        }
        lambdaInstanceValue.setTypeLattice(lambdaInstanceValue.getTypeLattice().asReferenceTypeLatticeElement().asDefinitelyNotNull());
        NewInstance newInstance = new NewInstance(lambdaClass.type, lambdaInstanceValue);
        instructions.replaceCurrentInstruction(newInstance);
        ArrayList<Value> arguments = new ArrayList<Value>();
        arguments.add(lambdaInstanceValue);
        arguments.addAll(invoke.arguments());
        InvokeDirect constructorCall = new InvokeDirect(lambdaClass.constructor, null, arguments);
        instructions.add(constructorCall);
        constructorCall.setPosition(newInstance.getPosition());
        if (!constructorCall.getBlock().hasCatchHandlers()) {
            return;
        }
        instructions.previous();
        assert (instructions.peekNext().isInvokeDirect());
        BasicBlock currentBlock = newInstance.getBlock();
        BasicBlock nextBlock = instructions.split(code, blocks);
        assert (!instructions.hasNext());
        nextBlock.copyCatchHandlers(code, blocks, currentBlock, this.getAppView().options());
    }
}

