/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ListIterator;
import java.util.Set;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.ir.code.Assume;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Assumer;

public class AliasIntroducer
implements Assumer {
    private final AppView<?> appView;

    public AliasIntroducer(AppView<?> appView) {
        this.appView = appView;
    }

    @Override
    public void insertAssumeInstructionsInBlocks(IRCode code, ListIterator<BasicBlock> blockIterator, Predicate<BasicBlock> blockTester) {
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (!blockTester.test(block)) continue;
            this.insertAssumeNoneInstructionsInBlock(code, blockIterator, block);
        }
    }

    private void insertAssumeNoneInstructionsInBlock(IRCode code, ListIterator<BasicBlock> blockIterator, BasicBlock block) {
        Set<Assume<Assume.NoAssumption>> deferredInstructions = Sets.newIdentityHashSet();
        InstructionListIterator instructionIterator = block.listIterator(code);
        while (instructionIterator.hasNext()) {
            Value outValue;
            Instruction current = (Instruction)instructionIterator.next();
            if (!current.hasOutValue() || !current.outValue().isUsed() || (outValue = current.outValue()).getTypeLattice().isPrimitive() || outValue.getTypeLattice().isNullType()) continue;
            BasicBlock insertionBlock = block.hasCatchHandlers() ? instructionIterator.split(code, blockIterator) : block;
            Value aliasedValue = code.createValue(outValue.getTypeLattice(), outValue.getLocalInfo());
            outValue.replaceUsers(aliasedValue);
            Assume<Assume.NoAssumption> assumeNone = Assume.createAssumeNoneInstruction(aliasedValue, outValue, current, this.appView);
            if (current.isArgument()) {
                deferredInstructions.add(assumeNone);
                continue;
            }
            assumeNone.setPosition(this.appView.options().debug ? current.getPosition() : Position.none());
            if (insertionBlock == block) {
                instructionIterator.add(assumeNone);
                continue;
            }
            insertionBlock.listIterator(code).add(assumeNone);
        }
        if (!deferredInstructions.isEmpty()) {
            Position firstNonNonePosition = code.findFirstNonNonePosition();
            InstructionListIterator it = block.listIterator(code);
            it.nextUntil(i -> !i.isArgument());
            it.previous();
            deferredInstructions.forEach(i -> {
                i.setPosition(firstNonNonePosition);
                it.add(i);
            });
        }
    }
}

