/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoInliningReasonStrategy;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.Monitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.MethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.AliasIntroducer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Assumer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.DynamicTypeOptimization;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningOracle;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningStrategy;
import shadow.bundletool.com.android.tools.r8.ir.optimize.NonNullTracker;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.DefaultInliningReasonStrategy;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.InlinerUtils;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.InliningReasonStrategy;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.MainDexDirectReferenceTracer;
import shadow.bundletool.com.android.tools.r8.utils.BooleanUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.IteratorUtils;

public final class DefaultInliningOracle
implements InliningOracle,
InliningStrategy {
    private final AppView<AppInfoWithLiveness> appView;
    private final Inliner inliner;
    private final DexEncodedMethod method;
    private final IRCode code;
    private final MethodProcessor methodProcessor;
    private final Predicate<DexEncodedMethod> isProcessedConcurrently;
    private final InliningReasonStrategy reasonStrategy;
    private final int inliningInstructionLimit;
    private int instructionAllowance;

    DefaultInliningOracle(AppView<AppInfoWithLiveness> appView, Inliner inliner, DexEncodedMethod method, IRCode code, MethodProcessor methodProcessor, int inliningInstructionLimit, int inliningInstructionAllowance) {
        this.appView = appView;
        this.inliner = inliner;
        this.method = method;
        this.code = code;
        this.methodProcessor = methodProcessor;
        this.isProcessedConcurrently = methodProcessor::isProcessedConcurrently;
        this.inliningInstructionLimit = inliningInstructionLimit;
        this.instructionAllowance = inliningInstructionAllowance;
        DefaultInliningReasonStrategy defaultInliningReasonStrategy = new DefaultInliningReasonStrategy(appView, methodProcessor.getCallSiteInformation(), inliner);
        this.reasonStrategy = appView.withGeneratedMessageLiteShrinker(ignore -> new ProtoInliningReasonStrategy(appView, defaultInliningReasonStrategy), defaultInliningReasonStrategy);
    }

    @Override
    public boolean isForcedInliningOracle() {
        return false;
    }

    private boolean isSingleTargetInvalid(InvokeMethod invoke, DexEncodedMethod singleTarget, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        int arity;
        if (singleTarget == null) {
            throw new Unreachable("Unexpected attempt to inline invoke that does not have a single target");
        }
        if (singleTarget.isClassInitializer()) {
            throw new Unreachable("Unexpected attempt to invoke a class initializer (`" + singleTarget.method.toSourceString() + "`)");
        }
        if (!singleTarget.hasCode()) {
            whyAreYouNotInliningReporter.reportInlineeDoesNotHaveCode();
            return true;
        }
        DexClass clazz = this.appView.definitionFor(singleTarget.method.holder);
        if (!clazz.isProgramClass()) {
            if (clazz.isClasspathClass()) {
                whyAreYouNotInliningReporter.reportClasspathMethod();
            } else {
                assert (clazz.isLibraryClass());
                whyAreYouNotInliningReporter.reportLibraryMethod();
            }
            return true;
        }
        int numberOfArguments = invoke.arguments().size() - BooleanUtils.intValue(invoke.isInvokeMethodWithReceiver());
        if (numberOfArguments != (arity = singleTarget.method.getArity())) {
            whyAreYouNotInliningReporter.reportIncorrectArity(numberOfArguments, arity);
            return true;
        }
        return false;
    }

    private boolean canInlineStaticInvoke(InvokeStatic invoke, DexEncodedMethod method, DexEncodedMethod target, ClassInitializationAnalysis classInitializationAnalysis, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        boolean targetIsGuaranteedToBeInitialized;
        DexType targetHolder = target.method.holder;
        if (this.appView.appInfo().isSubtype(method.method.holder, targetHolder)) {
            return true;
        }
        DexClass clazz = this.appView.definitionFor(targetHolder);
        assert (clazz != null);
        if (target.getOptimizationInfo().triggersClassInitBeforeAnySideEffect()) {
            return true;
        }
        if (!method.isStatic() && (targetIsGuaranteedToBeInitialized = this.appView.withInitializedClassesInInstanceMethods(analysis -> analysis.isClassDefinitelyLoadedInInstanceMethodsOn(target.method.holder, method.method.holder), false).booleanValue())) {
            return true;
        }
        if (classInitializationAnalysis.isClassDefinitelyLoadedBeforeInstruction(target.method.holder, invoke)) {
            return true;
        }
        if (!clazz.classInitializationMayHaveSideEffects(this.appView)) {
            return true;
        }
        if (this.appView.rootSet().bypassClinitForInlining.contains(target.method)) {
            return true;
        }
        whyAreYouNotInliningReporter.reportMustTriggerClassInitialization();
        return false;
    }

    @Override
    public boolean passesInliningConstraints(InvokeMethod invoke, DexEncodedMethod singleTarget, Inliner.Reason reason, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        if (singleTarget.getOptimizationInfo().neverInline()) {
            whyAreYouNotInliningReporter.reportMarkedAsNeverInline();
            return false;
        }
        if (this.method.isInstanceInitializer() && this.appView.options().isGeneratingClassFiles() && reason != Inliner.Reason.FORCE) {
            whyAreYouNotInliningReporter.reportNoInliningIntoConstructorsWhenGeneratingClassFiles();
            return false;
        }
        if (this.method == singleTarget) {
            assert (!singleTarget.getOptimizationInfo().forceInline());
            whyAreYouNotInliningReporter.reportRecursiveMethod();
            return false;
        }
        if (reason != Inliner.Reason.FORCE && this.isProcessedConcurrently.test(singleTarget)) {
            whyAreYouNotInliningReporter.reportProcessedConcurrently();
            return false;
        }
        InternalOptions options = this.appView.options();
        if (options.featureSplitConfiguration != null && !options.featureSplitConfiguration.inSameFeatureOrBase(singleTarget.method, this.method.method)) {
            whyAreYouNotInliningReporter.reportInliningAcrossFeatureSplit();
            return false;
        }
        Set<Inliner.Reason> validInliningReasons = options.testing.validInliningReasons;
        if (validInliningReasons != null && !validInliningReasons.contains((Object)reason)) {
            whyAreYouNotInliningReporter.reportInvalidInliningReason(reason, validInliningReasons);
            return false;
        }
        if (!this.inliner.hasInliningAccess(this.method, singleTarget)) {
            whyAreYouNotInliningReporter.reportInaccessible();
            return false;
        }
        if (reason == Inliner.Reason.DUAL_CALLER) {
            if (this.satisfiesRequirementsForSimpleInlining(invoke, singleTarget)) {
                this.inliner.recordDoubleInliningCandidate(this.method, singleTarget);
            } else if (this.inliner.isDoubleInliningEnabled()) {
                if (!this.inliner.satisfiesRequirementsForDoubleInlining(this.method, singleTarget)) {
                    whyAreYouNotInliningReporter.reportInvalidDoubleInliningCandidate();
                    return false;
                }
            } else {
                this.inliner.recordDoubleInliningCandidate(this.method, singleTarget);
            }
        } else if (reason == Inliner.Reason.SIMPLE && !this.satisfiesRequirementsForSimpleInlining(invoke, singleTarget)) {
            whyAreYouNotInliningReporter.reportInlineeNotSimple();
            return false;
        }
        if (reason != Inliner.Reason.FORCE && this.inlineeRefersToClassesNotInMainDex(this.method.method.holder, singleTarget)) {
            whyAreYouNotInliningReporter.reportInlineeRefersToClassesNotInMainDex();
            return false;
        }
        assert (reason != Inliner.Reason.FORCE || !this.inlineeRefersToClassesNotInMainDex(this.method.method.holder, singleTarget));
        return true;
    }

    private boolean inlineeRefersToClassesNotInMainDex(DexType holder, DexEncodedMethod target) {
        if (this.inliner.mainDexClasses.isEmpty() || !this.inliner.mainDexClasses.getRoots().contains(holder)) {
            return false;
        }
        return MainDexDirectReferenceTracer.hasReferencesOutsideFromCode(this.appView.appInfo(), target, this.inliner.mainDexClasses.getRoots());
    }

    private boolean satisfiesRequirementsForSimpleInlining(InvokeMethod invoke, DexEncodedMethod target) {
        int instructionLimit;
        Code code = target.getCode();
        return code.estimatedSizeForInliningAtMost(instructionLimit = this.computeInstructionLimit(invoke, target));
    }

    private int computeInstructionLimit(InvokeMethod invoke, DexEncodedMethod candidate) {
        int instructionLimit = this.inliningInstructionLimit;
        BitSet hints = candidate.getOptimizationInfo().getNonNullParamOrThrow();
        if (hints != null) {
            List<Value> arguments = invoke.inValues();
            if (invoke.isInvokeMethodWithReceiver()) {
                arguments = arguments.subList(1, arguments.size());
            }
            for (int index = 0; index < arguments.size(); ++index) {
                Value argument = arguments.get(index);
                if (!argument.isArgument() && (!argument.getTypeLattice().isReference() || !argument.isNeverNull()) || !hints.get(index)) continue;
                instructionLimit += 4;
            }
        }
        return instructionLimit;
    }

    @Override
    public DexEncodedMethod lookupSingleTarget(InvokeMethod invoke, DexType context) {
        return invoke.lookupSingleTarget(this.appView, context);
    }

    @Override
    public Inliner.InlineAction computeInlining(InvokeMethod invoke, DexEncodedMethod singleTarget, ClassInitializationAnalysis classInitializationAnalysis, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        if (this.isSingleTargetInvalid(invoke, singleTarget, whyAreYouNotInliningReporter)) {
            return null;
        }
        if (this.inliner.isBlacklisted(singleTarget, whyAreYouNotInliningReporter)) {
            return null;
        }
        Inliner.Reason reason = this.reasonStrategy.computeInliningReason(invoke, singleTarget);
        if (reason == Inliner.Reason.NEVER) {
            return null;
        }
        if (!singleTarget.isInliningCandidate(this.method, reason, (AppInfoWithSubtyping)this.appView.appInfo(), whyAreYouNotInliningReporter)) {
            return null;
        }
        if (!this.passesInliningConstraints(invoke, singleTarget, reason, whyAreYouNotInliningReporter)) {
            return null;
        }
        return invoke.computeInlining(singleTarget, reason, this, classInitializationAnalysis, whyAreYouNotInliningReporter);
    }

    public Inliner.InlineAction computeForInvokeWithReceiver(InvokeMethodWithReceiver invoke, DexEncodedMethod singleTarget, Inliner.Reason reason, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        Value receiver = invoke.getReceiver();
        if (receiver.getTypeLattice().isDefinitelyNull()) {
            whyAreYouNotInliningReporter.reportReceiverDefinitelyNull();
            return null;
        }
        Inliner.InlineAction action = new Inliner.InlineAction(singleTarget, invoke, reason);
        if (receiver.getTypeLattice().isNullable()) {
            assert (!receiver.getTypeLattice().isDefinitelyNull());
            if (!singleTarget.getOptimizationInfo().checksNullReceiverBeforeAnySideEffect()) {
                InternalOptions options = this.appView.options();
                if (!options.enableInliningOfInvokesWithNullableReceivers) {
                    whyAreYouNotInliningReporter.reportReceiverMaybeNull();
                    return null;
                }
                action.setShouldSynthesizeNullCheckForReceiver();
            }
        }
        return action;
    }

    public Inliner.InlineAction computeForInvokeStatic(InvokeStatic invoke, DexEncodedMethod singleTarget, Inliner.Reason reason, ClassInitializationAnalysis classInitializationAnalysis, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        if (!this.canInlineStaticInvoke(invoke, this.method, singleTarget, classInitializationAnalysis, whyAreYouNotInliningReporter)) {
            return null;
        }
        return new Inliner.InlineAction(singleTarget, invoke, reason);
    }

    @Override
    public void ensureMethodProcessed(DexEncodedMethod target, IRCode inlinee, OptimizationFeedback feedback) {
        if (!target.isProcessed()) {
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Forcing extra inline on " + target.toSourceString(), new Object[0]);
            }
            this.inliner.performInlining(target, inlinee, feedback, this.methodProcessor);
        }
    }

    @Override
    public boolean allowInliningOfInvokeInInlinee(Inliner.InlineAction action, int inliningDepth, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        assert (inliningDepth > 0);
        if (action.reason.mustBeInlined()) {
            return true;
        }
        int threshold = this.appView.options().applyInliningToInlineeMaxDepth;
        if (inliningDepth <= threshold) {
            return true;
        }
        whyAreYouNotInliningReporter.reportWillExceedMaxInliningDepth(inliningDepth, threshold);
        return false;
    }

    @Override
    public boolean canInlineInstanceInitializer(IRCode inlinee, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        DexType callerMethodHolder = this.method.method.holder;
        DexType calleeMethodHolder = inlinee.method.method.holder;
        if (this.method.isInstanceInitializer() && callerMethodHolder == calleeMethodHolder) {
            return true;
        }
        Value thisValue = inlinee.entryBlock().entry().asArgument().outValue();
        ArrayList<InvokeDirect> initCallsOnThis = new ArrayList<InvokeDirect>();
        for (Instruction instruction : inlinee.instructions()) {
            if (instruction.isInvokeDirect()) {
                Value receiver;
                InvokeDirect initCall = instruction.asInvokeDirect();
                DexMethod invokedMethod = initCall.getInvokedMethod();
                if (!this.appView.dexItemFactory().isConstructor(invokedMethod) || (receiver = initCall.getReceiver().getAliasedValue()) != thisValue) continue;
                if (calleeMethodHolder != invokedMethod.holder) {
                    whyAreYouNotInliningReporter.reportUnsafeConstructorInliningDueToIndirectConstructorCall(initCall);
                    return false;
                }
                initCallsOnThis.add(initCall);
                continue;
            }
            if (!instruction.isInstancePut()) continue;
            InstancePut instancePut = instruction.asInstancePut();
            DexField field = instancePut.getField();
            DexEncodedField target = this.appView.appInfo().lookupInstanceTarget(field.holder, field);
            if (target != null && !target.accessFlags.isFinal()) continue;
            whyAreYouNotInliningReporter.reportUnsafeConstructorInliningDueToFinalFieldAssignment(instancePut);
            return false;
        }
        int markingColor = inlinee.reserveMarkingColor();
        for (InvokeDirect initCallOnThis : initCallsOnThis) {
            BasicBlock block = initCallOnThis.getBlock();
            for (Instruction instruction : block.instructionsBefore(initCallOnThis)) {
                for (Value inValue : instruction.inValues()) {
                    Value root = inValue.getAliasedValue();
                    if (root != thisValue) continue;
                    inlinee.returnMarkingColor(markingColor);
                    whyAreYouNotInliningReporter.reportUnsafeConstructorInliningDueToUninitializedObjectUse(instruction);
                    return false;
                }
            }
            for (BasicBlock predecessor : block.getPredecessors()) {
                inlinee.markTransitivePredecessors(predecessor, markingColor);
            }
        }
        for (BasicBlock block : inlinee.blocks) {
            if (!block.isMarked(markingColor)) continue;
            for (Instruction instruction : block.getInstructions()) {
                for (Value inValue : instruction.inValues()) {
                    Value root = inValue.getAliasedValue();
                    if (root != thisValue) continue;
                    inlinee.returnMarkingColor(markingColor);
                    whyAreYouNotInliningReporter.reportUnsafeConstructorInliningDueToUninitializedObjectUse(instruction);
                    return false;
                }
            }
        }
        inlinee.returnMarkingColor(markingColor);
        return true;
    }

    @Override
    public boolean stillHasBudget(Inliner.InlineAction action, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        boolean stillHasBudget;
        if (action.reason.mustBeInlined()) {
            return true;
        }
        boolean bl = stillHasBudget = this.instructionAllowance > 0;
        if (!stillHasBudget) {
            whyAreYouNotInliningReporter.reportInstructionBudgetIsExceeded();
        }
        return stillHasBudget;
    }

    @Override
    public boolean willExceedBudget(IRCode code, InvokeMethod invoke, Inliner.InlineeWithReason inlinee, BasicBlock block, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        if (inlinee.reason.mustBeInlined()) {
            return false;
        }
        return this.willExceedInstructionBudget(inlinee, whyAreYouNotInliningReporter) || this.willExceedMonitorEnterValuesBudget(code, invoke, inlinee, whyAreYouNotInliningReporter) || this.willExceedControlFlowResolutionBlocksBudget(inlinee, block, whyAreYouNotInliningReporter);
    }

    private boolean willExceedInstructionBudget(Inliner.InlineeWithReason inlinee, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        int numberOfInstructions = Inliner.numberOfInstructions(inlinee.code);
        if (this.instructionAllowance < Inliner.numberOfInstructions(inlinee.code)) {
            whyAreYouNotInliningReporter.reportWillExceedInstructionBudget(numberOfInstructions, this.instructionAllowance);
            return true;
        }
        return false;
    }

    private boolean willExceedMonitorEnterValuesBudget(IRCode code, InvokeMethod invoke, Inliner.InlineeWithReason inlinee, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        int threshold;
        if (!code.metadata().mayHaveMonitorInstruction()) {
            return false;
        }
        if (!inlinee.code.metadata().mayHaveMonitorInstruction()) {
            return false;
        }
        Set<DexType> constantMonitorEnterValues = Sets.newIdentityHashSet();
        Set<Value> nonConstantMonitorEnterValues = Sets.newIdentityHashSet();
        InlinerUtils.collectAllMonitorEnterValues(code, constantMonitorEnterValues, nonConstantMonitorEnterValues);
        if (constantMonitorEnterValues.isEmpty() && nonConstantMonitorEnterValues.isEmpty()) {
            return false;
        }
        for (Monitor monitor : inlinee.code.instructions(Instruction::isMonitorEnter)) {
            Value monitorEnterValue = monitor.object().getAliasedValue();
            if (monitorEnterValue.isArgument()) {
                monitorEnterValue = invoke.arguments().get(monitorEnterValue.computeArgumentPosition(inlinee.code)).getAliasedValue();
            }
            InlinerUtils.addMonitorEnterValue(monitorEnterValue, constantMonitorEnterValues, nonConstantMonitorEnterValues);
        }
        int numberOfMonitorEnterValuesAfterInlining = constantMonitorEnterValues.size() + nonConstantMonitorEnterValues.size();
        if (numberOfMonitorEnterValuesAfterInlining > (threshold = this.appView.options().inliningMonitorEnterValuesAllowance)) {
            whyAreYouNotInliningReporter.reportWillExceedMonitorEnterValuesBudget(numberOfMonitorEnterValuesAfterInlining, threshold);
            return true;
        }
        return false;
    }

    private boolean willExceedControlFlowResolutionBlocksBudget(Inliner.InlineeWithReason inlinee, BasicBlock block, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        int threshold;
        if (!block.hasCatchHandlers()) {
            return false;
        }
        int numberOfThrowingInstructionsInInlinee = 0;
        for (BasicBlock inlineeBlock : inlinee.code.blocks) {
            numberOfThrowingInstructionsInInlinee += inlineeBlock.numberOfThrowingInstructions();
        }
        int estimatedNumberOfControlFlowResolutionBlocks = numberOfThrowingInstructionsInInlinee * block.numberOfCatchHandlers();
        if (estimatedNumberOfControlFlowResolutionBlocks >= (threshold = this.appView.options().inliningControlFlowResolutionBlocksThreshold)) {
            whyAreYouNotInliningReporter.reportPotentialExplosionInExceptionalControlFlowResolutionBlocks(estimatedNumberOfControlFlowResolutionBlocks, threshold);
            return true;
        }
        return false;
    }

    @Override
    public void markInlined(Inliner.InlineeWithReason inlinee) {
        this.instructionAllowance -= Inliner.numberOfInstructions(inlinee.code);
    }

    @Override
    public void updateTypeInformationIfNeeded(IRCode inlinee, ListIterator<BasicBlock> blockIterator, BasicBlock block) {
        boolean assumersEnabled;
        boolean bl = assumersEnabled = this.appView.options().enableNonNullTracking || this.appView.options().enableDynamicTypeOptimization || this.appView.options().testing.forceAssumeNoneInsertion;
        if (assumersEnabled) {
            BasicBlock state = IteratorUtils.peekNext(blockIterator);
            Set<BasicBlock> inlineeBlocks = Sets.newIdentityHashSet();
            inlineeBlocks.addAll(inlinee.blocks);
            if (this.appView.options().testing.forceAssumeNoneInsertion) {
                this.insertAssumeInstructionsToInlinee(new AliasIntroducer(this.appView), this.code, block, blockIterator, inlineeBlocks);
            }
            if (this.appView.options().enableNonNullTracking) {
                Consumer<BasicBlock> splitBlockConsumer = inlineeBlocks::add;
                NonNullTracker nonNullTracker = new NonNullTracker(this.appView, splitBlockConsumer);
                this.insertAssumeInstructionsToInlinee(nonNullTracker, this.code, block, blockIterator, inlineeBlocks);
            }
            if (this.appView.options().enableDynamicTypeOptimization) {
                this.insertAssumeInstructionsToInlinee(new DynamicTypeOptimization(this.appView), this.code, block, blockIterator, inlineeBlocks);
            }
            while (blockIterator.hasPrevious() && blockIterator.previous() != state) {
            }
            assert (IteratorUtils.peekNext(blockIterator) == state);
        }
    }

    private void insertAssumeInstructionsToInlinee(Assumer assumer, IRCode code, BasicBlock block, ListIterator<BasicBlock> blockIterator, Set<BasicBlock> inlineeBlocks) {
        while (blockIterator.hasPrevious() && blockIterator.previous() != block) {
        }
        assert (IteratorUtils.peekNext(blockIterator) == block);
        assumer.insertAssumeInstructionsInBlocks(code, blockIterator, inlineeBlocks::contains);
        assert (!blockIterator.hasNext());
    }

    @Override
    public DexType getReceiverTypeIfKnown(InvokeMethod invoke) {
        return null;
    }
}

