/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Predicates;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.optimize.MemberPoolCollection;
import shadow.bundletool.com.android.tools.r8.utils.MethodSignatureEquivalence;

public class MethodPoolCollection
extends MemberPoolCollection<DexMethod> {
    private final Predicate<DexEncodedMethod> methodTester;

    public MethodPoolCollection(AppView<? extends AppInfoWithSubtyping> appView) {
        super(appView, MethodSignatureEquivalence.get());
        this.methodTester = Predicates.alwaysTrue();
    }

    public MethodPoolCollection(AppView<? extends AppInfoWithSubtyping> appView, Predicate<DexEncodedMethod> methodTester) {
        super(appView, MethodSignatureEquivalence.get());
        this.methodTester = methodTester;
    }

    public static boolean excludesPrivateInstanceMethod(DexEncodedMethod method) {
        return !method.isPrivateMethod() || method.isStatic();
    }

    @Override
    Runnable computeMemberPoolForClass(DexClass clazz) {
        return () -> {
            DexClass superClazz;
            MemberPoolCollection.MemberPool methodPool = this.memberPools.computeIfAbsent(clazz, k -> new MemberPoolCollection.MemberPool(this.equivalence));
            clazz.forEachMethod(encodedMethod -> {
                if (this.methodTester.test((DexEncodedMethod)encodedMethod)) {
                    methodPool.seen(this.equivalence.wrap(encodedMethod.method));
                }
            });
            if (clazz.superType != null && (superClazz = this.appView.definitionFor(clazz.superType)) != null) {
                MemberPoolCollection.MemberPool superPool = this.memberPools.computeIfAbsent(superClazz, k -> new MemberPoolCollection.MemberPool(this.equivalence));
                superPool.linkSubtype(methodPool);
                methodPool.linkSupertype(superPool);
            }
            if (clazz.isInterface()) {
                for (DexType subtype : ((AppInfoWithSubtyping)this.appView.appInfo()).allImmediateSubtypes(clazz.type)) {
                    DexClass subClazz = this.appView.definitionFor(subtype);
                    if (subClazz == null) continue;
                    MemberPoolCollection.MemberPool childPool = this.memberPools.computeIfAbsent(subClazz, k -> new MemberPoolCollection.MemberPool(this.equivalence));
                    methodPool.linkSubtype(childPool);
                    childPool.linkInterface(methodPool);
                }
            }
        };
    }
}

