/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntPredicate;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.Goto;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.IntSwitch;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;

class SwitchCaseEliminator {
    private final BasicBlock block;
    private final BasicBlock defaultTarget;
    private final InstructionListIterator iterator;
    private final IntSwitch theSwitch;
    private boolean mayHaveIntroducedUnreachableBlocks = false;
    private IntSet switchCasesToBeRemoved;

    SwitchCaseEliminator(IntSwitch theSwitch, InstructionListIterator iterator2) {
        this.block = theSwitch.getBlock();
        this.defaultTarget = theSwitch.fallthroughBlock();
        this.iterator = iterator2;
        this.theSwitch = theSwitch;
    }

    private boolean allSwitchCasesMarkedForRemoval() {
        assert (this.switchCasesToBeRemoved != null);
        return this.switchCasesToBeRemoved.size() == this.theSwitch.numberOfKeys();
    }

    private boolean canBeOptimized() {
        assert (this.switchCasesToBeRemoved == null || !this.switchCasesToBeRemoved.isEmpty());
        return this.switchCasesToBeRemoved != null;
    }

    boolean mayHaveIntroducedUnreachableBlocks() {
        return this.mayHaveIntroducedUnreachableBlocks;
    }

    void markSwitchCaseForRemoval(int i) {
        if (this.switchCasesToBeRemoved == null) {
            this.switchCasesToBeRemoved = new IntOpenHashSet();
        }
        this.switchCasesToBeRemoved.add(i);
    }

    boolean optimize() {
        if (this.canBeOptimized()) {
            int originalNumberOfSuccessors = this.block.getSuccessors().size();
            this.unlinkDeadSuccessors();
            if (this.allSwitchCasesMarkedForRemoval()) {
                this.replaceSwitchByGoto();
            } else {
                this.replaceSwitchByOptimizedSwitch(originalNumberOfSuccessors);
            }
            return true;
        }
        return false;
    }

    private void unlinkDeadSuccessors() {
        IntPredicate successorHasBecomeDeadPredicate = this.computeSuccessorHasBecomeDeadPredicate();
        IntArrayList successorIndicesToBeRemoved = new IntArrayList();
        for (int i = 0; i < this.block.getSuccessors().size(); ++i) {
            if (!successorHasBecomeDeadPredicate.test(i)) continue;
            BasicBlock successor = this.block.getSuccessors().get(i);
            successor.removePredecessor(this.block, null);
            successorIndicesToBeRemoved.add(i);
            if (!successor.getPredecessors().isEmpty()) continue;
            this.mayHaveIntroducedUnreachableBlocks = true;
        }
        successorIndicesToBeRemoved.sort(Comparator.naturalOrder());
        this.block.removeSuccessorsByIndex(successorIndicesToBeRemoved);
    }

    private IntPredicate computeSuccessorHasBecomeDeadPredicate() {
        int[] numberOfControlFlowEdgesToBlockWithIndex = new int[this.block.getSuccessors().size()];
        for (int i2 = 0; i2 < this.theSwitch.numberOfKeys(); ++i2) {
            int targetBlockIndex;
            if (this.switchCasesToBeRemoved.contains(i2)) continue;
            int n = targetBlockIndex = this.theSwitch.getTargetBlockIndex(i2);
            numberOfControlFlowEdgesToBlockWithIndex[n] = numberOfControlFlowEdgesToBlockWithIndex[n] + 1;
        }
        int n = this.theSwitch.getFallthroughBlockIndex();
        numberOfControlFlowEdgesToBlockWithIndex[n] = numberOfControlFlowEdgesToBlockWithIndex[n] + 1;
        Iterator<Integer> iterator2 = this.block.getCatchHandlersWithSuccessorIndexes().getUniqueTargets().iterator();
        while (iterator2.hasNext()) {
            int i3;
            int n2 = i3 = iterator2.next().intValue();
            numberOfControlFlowEdgesToBlockWithIndex[n2] = numberOfControlFlowEdgesToBlockWithIndex[n2] + 1;
        }
        return i -> numberOfControlFlowEdgesToBlockWithIndex[i] == 0;
    }

    private void replaceSwitchByGoto() {
        this.iterator.replaceCurrentInstruction(new Goto(this.defaultTarget));
    }

    private void replaceSwitchByOptimizedSwitch(int originalNumberOfSuccessors) {
        int[] targetBlockIndexOffset = new int[originalNumberOfSuccessors];
        IntIterator intIterator = this.switchCasesToBeRemoved.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            int targetBlockIndex = this.theSwitch.getTargetBlockIndex(i);
            if (targetBlockIndex + 1 >= targetBlockIndexOffset.length) continue;
            targetBlockIndexOffset[targetBlockIndex + 1] = 1;
        }
        for (int i = 1; i < targetBlockIndexOffset.length; ++i) {
            int n = i;
            targetBlockIndexOffset[n] = targetBlockIndexOffset[n] + targetBlockIndexOffset[i - 1];
        }
        int newNumberOfKeys = this.theSwitch.numberOfKeys() - this.switchCasesToBeRemoved.size();
        int[] newKeys = new int[newNumberOfKeys];
        int[] newTargetBlockIndices = new int[newNumberOfKeys];
        int j = 0;
        for (int i = 0; i < this.theSwitch.numberOfKeys(); ++i) {
            if (this.switchCasesToBeRemoved.contains(i)) continue;
            newKeys[j] = this.theSwitch.getKey(i);
            newTargetBlockIndices[j] = this.theSwitch.getTargetBlockIndex(i) - targetBlockIndexOffset[this.theSwitch.getTargetBlockIndex(i)];
            assert (newTargetBlockIndices[j] < this.block.getSuccessors().size());
            assert (newTargetBlockIndices[j] != this.theSwitch.getFallthroughBlockIndex());
            ++j;
        }
        assert (targetBlockIndexOffset[this.theSwitch.getFallthroughBlockIndex()] == 0);
        this.iterator.replaceCurrentInstruction(new IntSwitch(this.theSwitch.value(), newKeys, newTargetBlockIndices, this.theSwitch.getFallthroughBlockIndex()));
    }
}

