/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Streams;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionOrPhi;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.CodeRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningOracle;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.ClassInlinerCostAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.InlineCandidateProcessor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import shadow.bundletool.com.android.tools.r8.ir.optimize.string.StringOptimizer;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public final class ClassInliner {
    private final LambdaRewriter lambdaRewriter;
    private final ConcurrentHashMap<DexClass, EligibilityStatus> knownClasses = new ConcurrentHashMap();

    public ClassInliner(LambdaRewriter lambdaRewriter) {
        this.lambdaRewriter = lambdaRewriter;
    }

    private void logEligibilityStatus(DexEncodedMethod context, Instruction root, EligibilityStatus status) {
        if (Log.ENABLED && Log.isLoggingEnabledFor(ClassInliner.class)) {
            Log.info(this.getClass(), "At %s,", context.toSourceString());
            Log.info(this.getClass(), "ClassInlining eligibility of `%s`: %s.", new Object[]{root, status});
        }
    }

    private void logIneligibleUser(DexEncodedMethod context, Instruction root, InstructionOrPhi ineligibleUser) {
        if (Log.ENABLED && Log.isLoggingEnabledFor(ClassInliner.class)) {
            Log.info(this.getClass(), "At %s,", context.toSourceString());
            Log.info(this.getClass(), "Ineligible user of `%s`: `%s`.", root, ineligibleUser);
        }
    }

    public final void processMethodCode(AppView<AppInfoWithLiveness> appView, CodeRewriter codeRewriter, StringOptimizer stringOptimizer, DexEncodedMethod method, IRCode code, Predicate<DexEncodedMethod> isProcessedConcurrently, Inliner inliner, Supplier<InliningOracle> defaultOracle) {
        boolean repeat;
        List roots = Streams.stream(code.instructionIterator()).filter(insn -> insn.isNewInstance() || insn.isStaticGet()).collect(Collectors.toList());
        boolean anyInlinedMethods = false;
        do {
            repeat = false;
            Iterator rootsIterator = roots.iterator();
            while (rootsIterator.hasNext()) {
                Instruction root = (Instruction)rootsIterator.next();
                InlineCandidateProcessor processor = new InlineCandidateProcessor(appView, this.lambdaRewriter, inliner, clazz -> this.isClassEligible(appView, (DexClass)clazz), isProcessedConcurrently, method, root);
                EligibilityStatus status = processor.isInstanceEligible();
                if (status != EligibilityStatus.ELIGIBLE) {
                    this.logEligibilityStatus(code.method, root, status);
                    rootsIterator.remove();
                    continue;
                }
                status = processor.isClassAndUsageEligible();
                this.logEligibilityStatus(code.method, root, status);
                if (status != EligibilityStatus.ELIGIBLE) {
                    rootsIterator.remove();
                    continue;
                }
                InstructionOrPhi ineligibleUser = processor.areInstanceUsersEligible(defaultOracle);
                if (ineligibleUser != null) {
                    this.logIneligibleUser(code.method, root, ineligibleUser);
                    continue;
                }
                assert (processor.getReceivers().verifyReceiverSetsAreDisjoint());
                InliningIRProvider inliningIRProvider = new InliningIRProvider(appView, method, code);
                ClassInlinerCostAnalysis costAnalysis = new ClassInlinerCostAnalysis(appView, inliningIRProvider, processor.getReceivers().getDefiniteReceiverAliases());
                if (costAnalysis.willExceedInstructionBudget(code, processor.getEligibleClass(), processor.getDirectInlinees(), processor.getIndirectInlinees())) {
                    rootsIterator.remove();
                    continue;
                }
                try {
                    anyInlinedMethods |= processor.processInlining(code, defaultOracle, inliningIRProvider);
                }
                catch (InlineCandidateProcessor.IllegalClassInlinerStateException e) {
                    assert (appView.options().testing.allowClassInlinerGracefulExit);
                    anyInlinedMethods = true;
                }
                assert (inliningIRProvider.verifyIRCacheIsEmpty());
                Set<Value> affectedValues = Sets.newIdentityHashSet();
                code.removeAllTrivialPhis(affectedValues);
                if (!affectedValues.isEmpty()) {
                    new TypeAnalysis(appView).narrowing(affectedValues);
                }
                assert (code.isConsistentSSA());
                rootsIterator.remove();
                repeat = true;
            }
        } while (repeat);
        if (anyInlinedMethods) {
            boolean isDebugMode;
            codeRewriter.removeTrivialCheckCastAndInstanceOfInstructions(code);
            codeRewriter.simplifyControlFlow(code);
            boolean bl = isDebugMode = appView.options().debug || method.getOptimizationInfo().isReachabilitySensitive();
            if (!isDebugMode) {
                stringOptimizer.computeTrivialOperationsOnConstString(code);
                stringOptimizer.removeTrivialConversions(code);
            }
        }
    }

    private EligibilityStatus isClassEligible(AppView<AppInfoWithLiveness> appView, DexClass clazz) {
        EligibilityStatus eligible = this.knownClasses.get(clazz);
        if (eligible == null) {
            EligibilityStatus computed = this.computeClassEligible(appView, clazz);
            EligibilityStatus existing = this.knownClasses.putIfAbsent(clazz, computed);
            assert (existing == null || existing == computed);
            eligible = existing == null ? computed : existing;
        }
        return eligible;
    }

    private EligibilityStatus computeClassEligible(AppView<AppInfoWithLiveness> appView, DexClass clazz) {
        if (clazz == null) {
            return EligibilityStatus.UNKNOWN_TYPE;
        }
        if (clazz.isNotProgramClass()) {
            return EligibilityStatus.NON_PROGRAM_CLASS;
        }
        if (clazz.isAbstract() || clazz.isInterface()) {
            return EligibilityStatus.ABSTRACT_OR_INTERFACE;
        }
        if (appView.appInfo().neverClassInline.contains(clazz.type)) {
            return EligibilityStatus.NEVER_CLASS_INLINE;
        }
        if (appView.appInfo().isPinned(clazz.type)) {
            return EligibilityStatus.IS_PINNED_TYPE;
        }
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            if (method.method.name != dexItemFactory.finalizeMethodName || method.method.proto != dexItemFactory.objectMethods.finalize.proto) continue;
            return EligibilityStatus.HAS_FINALIZER;
        }
        if (clazz.initializationOfParentTypesMayHaveSideEffects(appView)) {
            return EligibilityStatus.TRIGGER_CLINIT;
        }
        return EligibilityStatus.ELIGIBLE;
    }

    static enum EligibilityStatus {
        NON_CLASS_TYPE,
        NOT_A_SINGLETON_FIELD,
        RETRIEVAL_MAY_HAVE_SIDE_EFFECTS,
        UNKNOWN_TYPE,
        UNUSED_INSTANCE,
        NON_PROGRAM_CLASS,
        ABSTRACT_OR_INTERFACE,
        NEVER_CLASS_INLINE,
        IS_PINNED_TYPE,
        HAS_FINALIZER,
        TRIGGER_CLINIT,
        HAS_CLINIT,
        HAS_INSTANCE_FIELDS,
        NON_FINAL_TYPE,
        NOT_INITIALIZED_AT_INIT,
        PINNED_FIELD,
        ELIGIBLE;

    }
}

