/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.inliner;

import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallSiteInformation;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.InliningReasonStrategy;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class DefaultInliningReasonStrategy
implements InliningReasonStrategy {
    private final AppView<AppInfoWithLiveness> appView;
    private final CallSiteInformation callSiteInformation;
    private final Inliner inliner;

    public DefaultInliningReasonStrategy(AppView<AppInfoWithLiveness> appView, CallSiteInformation callSiteInformation, Inliner inliner) {
        this.appView = appView;
        this.callSiteInformation = callSiteInformation;
        this.inliner = inliner;
    }

    @Override
    public Inliner.Reason computeInliningReason(InvokeMethod invoke, DexEncodedMethod target) {
        if (target.getOptimizationInfo().forceInline() || this.appView.appInfo().hasLiveness() && this.appView.withLiveness().appInfo().forceInline.contains(target.method)) {
            assert (!this.appView.appInfo().neverInline.contains(target.method));
            return Inliner.Reason.FORCE;
        }
        if (this.appView.appInfo().hasLiveness() && this.appView.withLiveness().appInfo().alwaysInline.contains(target.method)) {
            return Inliner.Reason.ALWAYS;
        }
        if (this.appView.options().disableInliningOfLibraryMethodOverrides && target.isLibraryMethodOverride().isTrue()) {
            return Inliner.Reason.SIMPLE;
        }
        if (this.callSiteInformation.hasSingleCallSite(target.method)) {
            return Inliner.Reason.SINGLE_CALLER;
        }
        if (this.isDoubleInliningTarget(target)) {
            return Inliner.Reason.DUAL_CALLER;
        }
        return Inliner.Reason.SIMPLE;
    }

    private boolean isDoubleInliningTarget(DexEncodedMethod candidate) {
        if (this.callSiteInformation.hasDoubleCallSite(candidate.method) || this.inliner.isDoubleInlineSelectedTarget(candidate)) {
            return candidate.getCode().estimatedSizeForInliningAtMost(10);
        }
        return false;
    }
}

