/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes;

import java.util.List;
import java.util.ListIterator;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.LinearFlowInstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.DupDupDupPeephole;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.LoadLoadDupPeephole;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.MoveLoadUpPeephole;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.StoreLoadPeephole;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.StoreLoadToDupStorePeephole;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.StoreSequenceLoadPeephole;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class BasicBlockMuncher {
    private static List<BasicBlockPeephole> nonDestructivePeepholes() {
        return ImmutableList.of(new MoveLoadUpPeephole(), new StoreLoadPeephole());
    }

    private static List<BasicBlockPeephole> destructivePeepholes() {
        return ImmutableList.of(new StoreSequenceLoadPeephole(), new StoreLoadPeephole(), new LoadLoadDupPeephole(), new DupDupDupPeephole(), new StoreLoadToDupStorePeephole());
    }

    public static void optimize(IRCode code, InternalOptions options) {
        BasicBlockMuncher.runPeepholes(code, BasicBlockMuncher.nonDestructivePeepholes(), options);
        BasicBlockMuncher.runPeepholes(code, BasicBlockMuncher.destructivePeepholes(), options);
    }

    private static void runPeepholes(IRCode code, List<BasicBlockPeephole> peepholes, InternalOptions options) {
        ListIterator<BasicBlock> blocksIterator = code.listIterator(code.blocks.size());
        int iterations = 0;
        while (blocksIterator.hasPrevious()) {
            BasicBlock currentBlock = blocksIterator.previous();
            LinearFlowInstructionListIterator it = new LinearFlowInstructionListIterator(code, currentBlock, currentBlock.getInstructions().size());
            boolean matched = false;
            while (matched || it.hasPrevious()) {
                if (!it.hasPrevious()) {
                    matched = false;
                    it = new LinearFlowInstructionListIterator(code, currentBlock, currentBlock.getInstructions().size());
                }
                for (BasicBlockPeephole peepHole : peepholes) {
                    boolean localMatch = peepHole.match(it);
                    if (localMatch && peepHole.resetAfterMatch()) {
                        it = new LinearFlowInstructionListIterator(code, currentBlock, currentBlock.getInstructions().size());
                        continue;
                    }
                    matched |= localMatch;
                }
                if (!it.hasPrevious()) continue;
                if (options.testing.basicBlockMuncherIterationLimit != InternalOptions.TestingOptions.NO_LIMIT) {
                    if (iterations > options.testing.basicBlockMuncherIterationLimit) {
                        throw new CompilationError("Too many iterations in BasicBlockMuncher");
                    }
                    ++iterations;
                }
                it.previous();
            }
        }
    }
}

