/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Lists;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.MethodNameMinifier;
import shadow.bundletool.com.android.tools.r8.naming.MethodNamingState;
import shadow.bundletool.com.android.tools.r8.naming.MethodReservationState;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.DisjointSets;
import shadow.bundletool.com.android.tools.r8.utils.MethodJavaSignatureEquivalence;
import shadow.bundletool.com.android.tools.r8.utils.MethodSignatureEquivalence;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

class InterfaceMethodNameMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final Set<DexCallSite> desugaredCallSites;
    private final Equivalence<DexMethod> equivalence;
    private final MethodNameMinifier.State minifierState;
    private final Map<DexCallSite, DexString> callSiteRenamings = new IdentityHashMap<DexCallSite, DexString>();
    private final Map<Equivalence.Wrapper<DexMethod>, InterfaceMethodGroupState> globalStateMap = new HashMap<Equivalence.Wrapper<DexMethod>, InterfaceMethodGroupState>();
    private final Map<DexType, InterfaceReservationState> interfaceStateMap = new HashMap<DexType, InterfaceReservationState>();

    InterfaceMethodNameMinifier(AppView<AppInfoWithLiveness> appView, Set<DexCallSite> desugaredCallSites, MethodNameMinifier.State minifierState) {
        this.appView = appView;
        this.desugaredCallSites = desugaredCallSites;
        this.minifierState = minifierState;
        this.equivalence = appView.options().getProguardConfiguration().isOverloadAggressively() ? MethodSignatureEquivalence.get() : MethodJavaSignatureEquivalence.get();
    }

    private Comparator<Equivalence.Wrapper<DexMethod>> getDefaultInterfaceMethodOrdering() {
        return Comparator.comparing(this.globalStateMap::get);
    }

    Map<DexCallSite, DexString> getCallSiteRenamings() {
        return this.callSiteRenamings;
    }

    private void reserveNamesInInterfaces(Collection<DexClass> interfaces) {
        for (DexClass iface : interfaces) {
            assert (iface.isInterface());
            this.minifierState.allocateReservationStateAndReserve(iface.type, iface.type);
            InterfaceReservationState iFaceState = new InterfaceReservationState(iface);
            iFaceState.reservationTypes.add(iface.type);
            this.interfaceStateMap.put(iface.type, iFaceState);
        }
    }

    void assignNamesToInterfaceMethods(Timing timing, Collection<DexClass> interfaces) {
        InterfaceMethodGroupState groupState;
        timing.begin("Interface minification");
        timing.begin("Reserve direct and compute hierarchy");
        this.reserveNamesInInterfaces(interfaces);
        this.patchUpChildrenInReservationStates();
        timing.end();
        timing.begin("Compute map");
        this.computeReservationFrontiersForAllImplementingClasses();
        for (DexClass iface : interfaces) {
            InterfaceReservationState inheritanceState = this.interfaceStateMap.get(iface.type);
            assert (inheritanceState != null);
            for (DexEncodedMethod method : iface.methods()) {
                Equivalence.Wrapper<DexMethod> key = this.equivalence.wrap(method.method);
                this.globalStateMap.computeIfAbsent(key, k -> new InterfaceMethodGroupState()).addState(method.method, inheritanceState);
            }
        }
        timing.end();
        Sets.SetView<DexCallSite> liveCallSites = Sets.union(this.desugaredCallSites, this.appView.appInfo().callSites);
        timing.begin("Union-find");
        DisjointSets unification = new DisjointSets();
        liveCallSites.forEach(callSite -> {
            HashSet<Equivalence.Wrapper<DexMethod>> callSiteMethods = new HashSet<Equivalence.Wrapper<DexMethod>>();
            Set<DexEncodedMethod> implementedMethods = this.appView.appInfo().lookupLambdaImplementedMethods((DexCallSite)callSite);
            if (implementedMethods.isEmpty()) {
                return;
            }
            for (DexEncodedMethod method : implementedMethods) {
                Equivalence.Wrapper<DexMethod> wrapped = this.equivalence.wrap(method.method);
                InterfaceMethodGroupState interfaceMethodGroupState = this.globalStateMap.get(wrapped);
                assert (interfaceMethodGroupState != null);
                interfaceMethodGroupState.addCallSite((DexCallSite)callSite);
                callSiteMethods.add(wrapped);
            }
            if (callSiteMethods.size() > 1) {
                Equivalence.Wrapper mainKey = (Equivalence.Wrapper)callSiteMethods.iterator().next();
                Equivalence.Wrapper representative = unification.findOrMakeSet(mainKey);
                for (Equivalence.Wrapper wrapper : callSiteMethods) {
                    unification.unionWithMakeSet(representative, wrapper);
                }
            }
        });
        timing.end();
        timing.begin("States for union");
        Map unions = unification.collectSets();
        for (Equivalence.Wrapper wrapped : unions.keySet()) {
            InterfaceMethodGroupState groupState2 = this.globalStateMap.get(wrapped);
            assert (groupState2 != null);
            for (Equivalence.Wrapper groupedMethod : unions.get(wrapped)) {
                DexMethod method = (DexMethod)groupedMethod.get();
                assert (method != null);
                groupState2.appendMethodGroupState(this.globalStateMap.get(groupedMethod));
            }
        }
        timing.end();
        timing.begin("Sort");
        List<Equivalence.Wrapper<DexMethod>> interfaceMethodGroups = this.globalStateMap.keySet().stream().filter(unification::isRepresentativeOrNotPresent).sorted(this.appView.options().testing.minifier.getInterfaceMethodOrderingOrDefault(this.getDefaultInterfaceMethodOrdering())).collect(Collectors.toList());
        timing.end();
        assert (this.verifyAllMethodsAreRepresentedIn(interfaceMethodGroups));
        assert (this.verifyAllCallSitesAreRepresentedIn(interfaceMethodGroups));
        timing.begin("Reserve in groups");
        ArrayList<Equivalence.Wrapper<DexMethod>> nonReservedMethodGroups = new ArrayList<Equivalence.Wrapper<DexMethod>>();
        for (Equivalence.Wrapper<DexMethod> interfaceMethodGroup : interfaceMethodGroups) {
            groupState = this.globalStateMap.get(interfaceMethodGroup);
            assert (groupState != null);
            DexString reservedName = groupState.getReservedName();
            if (reservedName == null) {
                nonReservedMethodGroups.add(interfaceMethodGroup);
                continue;
            }
            groupState.reserveName(reservedName);
            for (DexCallSite callSite2 : groupState.callSites) {
                assert (!this.callSiteRenamings.containsKey(callSite2));
                this.callSiteRenamings.put(callSite2, reservedName);
            }
        }
        timing.end();
        timing.begin("Rename in groups");
        for (Equivalence.Wrapper<DexMethod> interfaceMethodGroup : nonReservedMethodGroups) {
            groupState = this.globalStateMap.get(interfaceMethodGroup);
            assert (groupState != null);
            assert (groupState.getReservedName() == null);
            DexString newName = this.assignNewName(interfaceMethodGroup.get(), groupState);
            assert (newName != null);
            Set<String> loggingFilter = this.appView.options().extensiveInterfaceMethodMinifierLoggingFilter;
            if (!loggingFilter.isEmpty()) {
                Set<DexMethod> sourceMethods = groupState.methodStates.keySet();
                if (sourceMethods.stream().map(DexMethod::toSourceString).anyMatch(loggingFilter::contains)) {
                    this.print(interfaceMethodGroup.get(), sourceMethods, System.out);
                }
            }
            for (DexCallSite callSite3 : groupState.callSites) {
                assert (!this.callSiteRenamings.containsKey(callSite3));
                this.callSiteRenamings.put(callSite3, newName);
            }
        }
        timing.end();
        timing.end();
    }

    private DexString assignNewName(DexMethod method, InterfaceMethodGroupState groupState) {
        assert (groupState.getReservedName() == null);
        assert (groupState.methodStates.containsKey(method));
        assert (groupState.containsReservation(method, method.holder));
        MethodNamingState<?> namingState = this.minifierState.getNamingState(method.holder);
        DexString newName = namingState.newOrReservedNameFor(method, (candidate, ignore) -> groupState.isAvailable((DexString)candidate));
        groupState.addRenaming(newName, this.minifierState);
        return newName;
    }

    private void patchUpChildrenInReservationStates() {
        for (Map.Entry<DexType, InterfaceReservationState> entry : this.interfaceStateMap.entrySet()) {
            for (DexType parent : entry.getValue().iface.interfaces.values) {
                InterfaceReservationState parentState = this.interfaceStateMap.get(parent);
                if (parentState == null) continue;
                parentState.children.add(entry.getKey());
            }
        }
    }

    private void computeReservationFrontiersForAllImplementingClasses() {
        for (DexClass clazz : this.appView.appInfo().app().asDirect().allClasses()) {
            if (clazz.isInterface()) continue;
            for (DexType directlyImplemented : this.appView.appInfo().implementedInterfaces(clazz.type)) {
                InterfaceReservationState iState = this.interfaceStateMap.get(directlyImplemented);
                if (iState == null) continue;
                DexType frontierType = this.minifierState.getFrontier(clazz.type);
                assert (this.minifierState.getReservationState(frontierType) != null);
                iState.reservationTypes.add(frontierType);
            }
        }
    }

    private boolean verifyAllCallSitesAreRepresentedIn(List<Equivalence.Wrapper<DexMethod>> groups2) {
        HashSet<Equivalence.Wrapper<DexMethod>> unifiedMethods = new HashSet<Equivalence.Wrapper<DexMethod>>(groups2);
        HashSet<DexCallSite> unifiedSeen = new HashSet<DexCallSite>();
        HashSet<DexCallSite> seen = new HashSet<DexCallSite>();
        for (Map.Entry<Equivalence.Wrapper<DexMethod>, InterfaceMethodGroupState> state : this.globalStateMap.entrySet()) {
            for (DexCallSite callSite : state.getValue().callSites) {
                seen.add(callSite);
                if (!unifiedMethods.contains(state.getKey())) continue;
                boolean added = unifiedSeen.add(callSite);
                assert (added);
            }
        }
        assert (seen.size() == unifiedSeen.size());
        assert (unifiedSeen.containsAll(seen));
        return true;
    }

    private boolean verifyAllMethodsAreRepresentedIn(List<Equivalence.Wrapper<DexMethod>> groups2) {
        HashSet<Equivalence.Wrapper<DexMethod>> unifiedMethods = new HashSet<Equivalence.Wrapper<DexMethod>>(groups2);
        HashSet<DexMethod> unifiedSeen = new HashSet<DexMethod>();
        HashSet<DexMethod> seen = new HashSet<DexMethod>();
        for (Map.Entry<Equivalence.Wrapper<DexMethod>, InterfaceMethodGroupState> state : this.globalStateMap.entrySet()) {
            for (DexMethod method : state.getValue().methodStates.keySet()) {
                seen.add(method);
                if (!unifiedMethods.contains(state.getKey())) continue;
                boolean added = unifiedSeen.add(method);
                assert (added);
            }
        }
        assert (seen.size() == unifiedSeen.size());
        assert (unifiedSeen.containsAll(seen));
        return true;
    }

    private void print(DexMethod method, Set<DexMethod> sourceMethods, PrintStream out) {
        out.println("-----------------------------------------------------------------------");
        out.println("assignNameToInterfaceMethod(`" + method.toSourceString() + "`)");
        out.println("-----------------------------------------------------------------------");
        out.println("Source methods:");
        for (DexMethod sourceMethod : sourceMethods) {
            out.println("  " + sourceMethod.toSourceString());
        }
        out.println("States:");
        out.println();
    }

    class InterfaceMethodGroupState
    implements Comparable<InterfaceMethodGroupState> {
        private final Set<DexCallSite> callSites = new HashSet<DexCallSite>();
        private final Map<DexMethod, Set<InterfaceReservationState>> methodStates = new HashMap<DexMethod, Set<InterfaceReservationState>>();

        InterfaceMethodGroupState() {
        }

        void addState(DexMethod method, InterfaceReservationState interfaceState) {
            this.methodStates.computeIfAbsent(method, m -> new HashSet()).add(interfaceState);
        }

        void appendMethodGroupState(InterfaceMethodGroupState state) {
            this.callSites.addAll(state.callSites);
            for (DexMethod key : state.methodStates.keySet()) {
                this.methodStates.computeIfAbsent(key, k -> new HashSet()).addAll((Collection)state.methodStates.get(key));
            }
        }

        void addCallSite(DexCallSite callSite) {
            this.callSites.add(callSite);
        }

        DexString getReservedName() {
            if (this.methodStates.isEmpty()) {
                return null;
            }
            ArrayList<DexMethod> sortedMethods = Lists.newArrayList(this.methodStates.keySet());
            sortedMethods.sort(DexMethod::slowCompareTo);
            DexString reservedName = null;
            for (DexMethod method : sortedMethods) {
                for (InterfaceReservationState state : this.methodStates.get(method)) {
                    DexString stateReserved = state.getReservedName(method);
                    if (stateReserved == method.name) {
                        return method.name;
                    }
                    if (stateReserved == null) continue;
                    reservedName = stateReserved;
                }
            }
            return reservedName;
        }

        void reserveName(DexString reservedName) {
            this.forEachState((method, state) -> {
                DexString stateReserved = state.getReservedName((DexMethod)method);
                if (stateReserved != null) {
                    state.reserveName(stateReserved, (DexMethod)method);
                    InterfaceMethodNameMinifier.this.minifierState.putRenaming((DexMethod)method, stateReserved);
                } else {
                    state.reserveName(reservedName, (DexMethod)method);
                    InterfaceMethodNameMinifier.this.minifierState.putRenaming((DexMethod)method, reservedName);
                }
            });
        }

        boolean isAvailable(DexString candidate) {
            Boolean result = this.forAnyState((m, s) -> {
                if (!s.isAvailable(candidate, (DexMethod)m)) {
                    return false;
                }
                return null;
            });
            return result == null ? true : result;
        }

        void addRenaming(DexString newName, MethodNameMinifier.State minifierState) {
            this.forEachState((m, s) -> {
                s.addRenaming(newName, (DexMethod)m);
                minifierState.putRenaming((DexMethod)m, newName);
            });
        }

        void forEachState(BiConsumer<DexMethod, InterfaceReservationState> action) {
            this.forAnyState((s, i) -> {
                action.accept((DexMethod)s, (InterfaceReservationState)i);
                return null;
            });
        }

        <T> T forAnyState(BiFunction<DexMethod, InterfaceReservationState, T> callback) {
            for (Map.Entry<DexMethod, Set<InterfaceReservationState>> entry : this.methodStates.entrySet()) {
                for (InterfaceReservationState state : entry.getValue()) {
                    T returnValue = callback.apply(entry.getKey(), state);
                    if (returnValue == null) continue;
                    return returnValue;
                }
            }
            return null;
        }

        boolean containsReservation(DexMethod method, DexType reservationType) {
            Set<InterfaceReservationState> states = this.methodStates.get(method);
            if (states != null) {
                for (InterfaceReservationState state : states) {
                    if (!state.containsReservation(reservationType)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(InterfaceMethodGroupState o) {
            return o.methodStates.size() - this.methodStates.size();
        }
    }

    class InterfaceReservationState {
        final DexClass iface;
        final Set<DexType> children = new HashSet<DexType>();
        final Set<DexType> reservationTypes = new HashSet<DexType>();

        InterfaceReservationState(DexClass iface) {
            this.iface = iface;
        }

        DexString getReservedName(DexMethod method) {
            DexString reservedName;
            DexEncodedMethod encodedMethod;
            if (InterfaceMethodNameMinifier.this.appView.options().getProguardConfiguration().hasApplyMappingFile() && (encodedMethod = InterfaceMethodNameMinifier.this.appView.definitionFor(method)) != null && (reservedName = InterfaceMethodNameMinifier.this.minifierState.getReservedName(encodedMethod, this.iface)) != null) {
                return reservedName;
            }
            Boolean isReserved = this.forAny(s -> {
                for (DexType reservationType : s.reservationTypes) {
                    Set<DexString> reservedNamesFor = InterfaceMethodNameMinifier.this.minifierState.getReservationState(reservationType).getReservedNamesFor(method);
                    assert (reservedNamesFor == null || !reservedNamesFor.isEmpty());
                    if (reservedNamesFor == null || !reservedNamesFor.contains(method.name)) continue;
                    return true;
                }
                return null;
            });
            return isReserved == null ? null : method.name;
        }

        void reserveName(DexString reservedName, DexMethod method) {
            this.forAll(s -> s.reservationTypes.forEach(resType -> {
                MethodReservationState<?> state = InterfaceMethodNameMinifier.this.minifierState.getReservationState((DexType)resType);
                state.reserveName(reservedName, method);
            }));
        }

        boolean isAvailable(DexString candidate, DexMethod method) {
            Boolean result = this.forAny(s -> {
                for (DexType resType : s.reservationTypes) {
                    MethodNamingState<?> state = InterfaceMethodNameMinifier.this.minifierState.getNamingState(resType);
                    if (state.isAvailable(candidate, method)) continue;
                    return false;
                }
                return null;
            });
            return result == null ? true : result;
        }

        void addRenaming(DexString newName, DexMethod method) {
            this.forAll(s -> s.reservationTypes.forEach(resType -> {
                MethodNamingState<?> state = InterfaceMethodNameMinifier.this.minifierState.getNamingState((DexType)resType);
                state.addRenaming(newName, method);
            }));
        }

        <T> void forAll(Consumer<InterfaceReservationState> action) {
            this.forAny(s -> {
                action.accept((InterfaceReservationState)s);
                return null;
            });
        }

        private <T> T forAny(Function<InterfaceReservationState, T> action) {
            T result = action.apply(this);
            if (result != null) {
                return result;
            }
            result = this.forChildren(action);
            if (result != null) {
                return result;
            }
            return this.forParents(action);
        }

        private <T> T forParents(Function<InterfaceReservationState, T> action) {
            for (DexType parent : this.iface.interfaces.values) {
                InterfaceReservationState parentState = (InterfaceReservationState)InterfaceMethodNameMinifier.this.interfaceStateMap.get(parent);
                if (parentState == null) continue;
                T returnValue = action.apply(parentState);
                if (returnValue != null) {
                    return returnValue;
                }
                returnValue = parentState.forParents(action);
                if (returnValue == null) continue;
                return returnValue;
            }
            return null;
        }

        private <T> T forChildren(Function<InterfaceReservationState, T> action) {
            for (DexType child : this.children) {
                InterfaceReservationState childState = (InterfaceReservationState)InterfaceMethodNameMinifier.this.interfaceStateMap.get(child);
                if (childState == null) continue;
                T returnValue = action.apply(childState);
                if (returnValue != null) {
                    return returnValue;
                }
                returnValue = childState.forChildren(action);
                if (returnValue == null) continue;
                return returnValue;
            }
            return null;
        }

        boolean containsReservation(DexType reservationType) {
            return this.reservationTypes.contains(reservationType);
        }
    }
}

