/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import shadow.bundletool.com.android.tools.r8.naming.ClassNaming;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.naming.ProguardMap;
import shadow.bundletool.com.android.tools.r8.naming.Range;
import shadow.bundletool.com.android.tools.r8.position.TextPosition;
import shadow.bundletool.com.android.tools.r8.utils.IdentifierUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class ProguardMapReader
implements AutoCloseable {
    private final BufferedReader reader;
    private int lineNo = 0;
    private int lineOffset = 0;
    private String line;
    final HashMap<String, String> cache = new HashMap();

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    ProguardMapReader(BufferedReader reader) {
        this.reader = reader;
    }

    private int peekCodePoint() {
        return this.lineOffset < this.line.length() ? this.line.codePointAt(this.lineOffset) : 10;
    }

    private char peekChar(int distance) {
        return this.lineOffset + distance < this.line.length() ? this.line.charAt(this.lineOffset + distance) : (char)'\n';
    }

    private boolean hasNext() {
        return this.lineOffset < this.line.length();
    }

    private int nextCodePoint() {
        try {
            int cp = this.line.codePointAt(this.lineOffset);
            this.lineOffset += Character.charCount(cp);
            return cp;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Unexpected end of line");
        }
    }

    private char nextChar() {
        assert (this.hasNext());
        try {
            return this.line.charAt(this.lineOffset++);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Unexpected end of line");
        }
    }

    private boolean nextLine() throws IOException {
        if (this.line.length() != this.lineOffset) {
            throw new ParseException("Expected end of line");
        }
        return this.skipLine();
    }

    private boolean isEmptyOrCommentLine(String line) {
        if (line == null) {
            return true;
        }
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '#') {
                return true;
            }
            if (StringUtils.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private boolean skipLine() throws IOException {
        this.lineOffset = 0;
        do {
            ++this.lineNo;
            this.line = this.reader.readLine();
        } while (this.hasLine() && this.isEmptyOrCommentLine(this.line));
        return this.hasLine();
    }

    private boolean hasLine() {
        return this.line != null;
    }

    private void skipWhitespace() {
        while (this.hasNext() && StringUtils.isWhitespace(this.peekCodePoint())) {
            this.nextCodePoint();
        }
    }

    private void expectWhitespace() {
        boolean seen = false;
        while (this.hasNext() && StringUtils.isWhitespace(this.peekCodePoint())) {
            seen = seen || !StringUtils.isBOM(this.peekCodePoint());
            this.nextCodePoint();
        }
        if (!seen) {
            throw new ParseException("Expected whitespace", true);
        }
    }

    private void expect(char c) {
        if (!this.hasNext()) {
            throw new ParseException("Expected '" + c + "'", true);
        }
        if (this.nextChar() != c) {
            throw new ParseException("Expected '" + c + "'");
        }
    }

    void parse(ProguardMap.Builder mapBuilder) throws IOException {
        do {
            this.line = this.reader.readLine();
            ++this.lineNo;
        } while (this.hasLine() && this.isEmptyOrCommentLine(this.line));
        this.parseClassMappings(mapBuilder);
    }

    private void parseClassMappings(ProguardMap.Builder mapBuilder) throws IOException {
        while (this.hasLine()) {
            this.skipWhitespace();
            String before = this.parseType(false);
            this.skipWhitespace();
            assert (IdentifierUtils.isDexIdentifierPart(45));
            if (before.endsWith("package-info")) {
                this.skipLine();
                continue;
            }
            if (before.endsWith("-") && this.acceptString(">")) {
                before = before.substring(0, before.length() - 1);
            } else {
                this.skipWhitespace();
                this.acceptArrow();
            }
            this.skipWhitespace();
            String after = this.parseType(false);
            this.skipWhitespace();
            this.expect(':');
            ClassNaming.Builder currentClassBuilder = mapBuilder.classNamingBuilder(after, before, this.getPosition());
            this.skipWhitespace();
            if (!this.nextLine()) continue;
            this.parseMemberMappings(currentClassBuilder);
        }
    }

    private void parseMemberMappings(ClassNaming.Builder classNamingBuilder) throws IOException {
        MemberNaming lastAddedNaming = null;
        MemberNaming activeMemberNaming = null;
        Range previousMappedRange = null;
        do {
            Object originalRange = null;
            Range mappedRange = null;
            if (!StringUtils.isWhitespace(this.peekCodePoint())) break;
            this.skipWhitespace();
            Object maybeRangeOrInt = this.maybeParseRangeOrInt();
            if (maybeRangeOrInt != null) {
                if (!(maybeRangeOrInt instanceof Range)) {
                    throw new ParseException(String.format("Invalid obfuscated line number range (%s).", maybeRangeOrInt));
                }
                mappedRange = (Range)maybeRangeOrInt;
                this.skipWhitespace();
                this.expect(':');
            }
            this.skipWhitespace();
            MemberNaming.Signature signature = this.parseSignature();
            this.skipWhitespace();
            if (this.peekChar(0) == ':') {
                this.nextChar();
                this.skipWhitespace();
                originalRange = this.maybeParseRangeOrInt();
                if (originalRange == null) {
                    throw new ParseException("No number follows the colon after the method signature.");
                }
            }
            if (mappedRange == null && originalRange != null) {
                throw new ParseException("No mapping for original range " + originalRange + ".");
            }
            this.skipWhitespace();
            this.skipArrow();
            this.skipWhitespace();
            String renamedName = this.parseMethodName();
            if (signature instanceof MemberNaming.MethodSignature) {
                classNamingBuilder.addMappedRange(mappedRange, (MemberNaming.MethodSignature)signature, originalRange, renamedName);
            }
            assert (mappedRange == null || signature instanceof MemberNaming.MethodSignature);
            if (activeMemberNaming != null) {
                boolean changedMappedRange;
                boolean changedName = !activeMemberNaming.getRenamedName().equals(renamedName);
                boolean bl = changedMappedRange = !Objects.equals(previousMappedRange, mappedRange);
                if (!(!changedName && previousMappedRange != null && !changedMappedRange || lastAddedNaming != null && lastAddedNaming.getOriginalSignature().equals(activeMemberNaming.signature))) {
                    classNamingBuilder.addMemberEntry(activeMemberNaming);
                    lastAddedNaming = activeMemberNaming;
                }
            }
            activeMemberNaming = new MemberNaming(signature, renamedName, this.getPosition());
            previousMappedRange = mappedRange;
        } while (this.nextLine());
        if (activeMemberNaming != null) {
            boolean notAdded;
            boolean bl = notAdded = lastAddedNaming == null || !lastAddedNaming.getOriginalSignature().equals(activeMemberNaming.signature);
            if (previousMappedRange == null || notAdded) {
                classNamingBuilder.addMemberEntry(activeMemberNaming);
            }
        }
    }

    private TextPosition getPosition() {
        return new TextPosition(0L, this.lineNo, 1);
    }

    private void skipIdentifier(boolean allowInit) {
        boolean isInit = false;
        if (allowInit && this.peekChar(0) == '<') {
            this.nextChar();
            isInit = true;
        }
        if (!IdentifierUtils.isDexIdentifierStart(this.peekCodePoint()) && !IdentifierUtils.isQuestionMark(this.peekCodePoint())) {
            throw new ParseException("Identifier expected");
        }
        this.nextCodePoint();
        while (IdentifierUtils.isDexIdentifierPart(this.peekCodePoint()) || IdentifierUtils.isQuestionMark(this.peekCodePoint())) {
            this.nextCodePoint();
        }
        if (isInit) {
            this.expect('>');
        }
        if (IdentifierUtils.isDexIdentifierPart(this.peekCodePoint())) {
            throw new ParseException("End of identifier expected (was 0x" + Integer.toHexString(this.peekCodePoint()) + ")");
        }
    }

    private String substring(int start) {
        String result = this.line.substring(start, this.lineOffset);
        if (this.cache.containsKey(result)) {
            return this.cache.get(result);
        }
        this.cache.put(result, result);
        return result;
    }

    private String parseMethodName() {
        int startPosition = this.lineOffset;
        this.skipIdentifier(true);
        while (this.peekChar(0) == '.') {
            this.nextChar();
            this.skipIdentifier(true);
        }
        return this.substring(startPosition);
    }

    private String parseType(boolean allowArray) {
        int startPosition = this.lineOffset;
        this.skipIdentifier(false);
        while (this.peekChar(0) == '.') {
            this.nextChar();
            this.skipIdentifier(false);
        }
        if (allowArray) {
            while (this.peekChar(0) == '[') {
                this.nextChar();
                this.expect(']');
            }
        }
        return this.substring(startPosition);
    }

    private MemberNaming.Signature parseSignature() {
        MemberNaming.Signature signature;
        String type = this.parseType(true);
        this.expectWhitespace();
        String name = this.parseMethodName();
        this.skipWhitespace();
        if (this.peekChar(0) == '(') {
            String[] arguments;
            this.nextChar();
            this.skipWhitespace();
            if (this.peekChar(0) == ')') {
                arguments = new String[]{};
            } else {
                LinkedList<String> items = new LinkedList<String>();
                items.add(this.parseType(true));
                this.skipWhitespace();
                while (this.peekChar(0) != ')') {
                    this.skipWhitespace();
                    this.expect(',');
                    this.skipWhitespace();
                    items.add(this.parseType(true));
                }
                arguments = items.toArray(StringUtils.EMPTY_ARRAY);
            }
            this.expect(')');
            signature = new MemberNaming.MethodSignature(name, type, arguments);
        } else {
            signature = new MemberNaming.FieldSignature(name, type);
        }
        return signature;
    }

    private void skipArrow() {
        this.expect('-');
        this.expect('>');
    }

    private boolean acceptArrow() {
        if (this.peekChar(0) == '-' && this.peekChar(1) == '>') {
            this.nextChar();
            this.nextChar();
            return true;
        }
        return false;
    }

    private boolean acceptString(String s) {
        int i;
        for (i = 0; i < s.length(); ++i) {
            if (this.peekChar(i) == s.charAt(i)) continue;
            return false;
        }
        for (i = 0; i < s.length(); ++i) {
            this.nextChar();
        }
        return true;
    }

    private boolean isSimpleDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private Object maybeParseRangeOrInt() {
        if (!this.isSimpleDigit(this.peekChar(0))) {
            return null;
        }
        int from = this.parseNumber();
        this.skipWhitespace();
        if (this.peekChar(0) != ':') {
            return from;
        }
        this.expect(':');
        this.skipWhitespace();
        int to = this.parseNumber();
        return new Range(from, to);
    }

    private int parseNumber() {
        int result = 0;
        if (!this.isSimpleDigit(this.peekChar(0))) {
            throw new ParseException("Number expected");
        }
        do {
            result *= 10;
            result += Character.getNumericValue(this.nextChar());
        } while (this.isSimpleDigit(this.peekChar(0)));
        return result;
    }

    private class ParseException
    extends RuntimeException {
        private final int lineNo;
        private final int lineOffset;
        private final boolean eol;
        private final String msg;

        ParseException(String msg) {
            this(msg, false);
        }

        ParseException(String msg, boolean eol) {
            this.lineNo = ProguardMapReader.this.lineNo;
            this.lineOffset = ProguardMapReader.this.lineOffset;
            this.eol = eol;
            this.msg = msg;
        }

        @Override
        public String toString() {
            if (this.eol) {
                return "Parse error [" + this.lineNo + ":eol] " + this.msg;
            }
            return "Parse error [" + this.lineNo + ":" + this.lineOffset + "] " + this.msg;
        }
    }
}

