/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.IdentityHashMap;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.FieldNamingStateBase;

class ReservedFieldNamingState
extends FieldNamingStateBase<InternalState> {
    ReservedFieldNamingState(AppView<?> appView) {
        super(appView, new IdentityHashMap());
    }

    boolean isReserved(DexString name, DexType type) {
        return this.getReservedByName(name, type) != null;
    }

    DexString getReservedByName(DexString name, DexType type) {
        InternalState internalState = (InternalState)this.getInternalState(type);
        return internalState == null ? null : internalState.getReservedByName(name);
    }

    void markReservedDirectly(DexString name, DexString originalName, DexType type) {
        ((InternalState)this.getOrCreateInternalState(type)).markReservedDirectly(name, originalName);
    }

    void includeReservations(ReservedFieldNamingState reservedNames) {
        for (Map.Entry entry : reservedNames.internalStates.entrySet()) {
            ((InternalState)this.getOrCreateInternalState((DexType)entry.getKey())).includeReservations((InternalState)entry.getValue());
        }
    }

    void includeReservationsFromBelow(ReservedFieldNamingState reservedNames) {
        for (Map.Entry entry : reservedNames.internalStates.entrySet()) {
            ((InternalState)this.getOrCreateInternalState((DexType)entry.getKey())).includeReservationsFromBelow((InternalState)entry.getValue());
        }
    }

    @Override
    InternalState createInternalState() {
        return new InternalState();
    }

    static class InternalState {
        private Map<DexString, DexString> reservedNamesDirect = new IdentityHashMap<DexString, DexString>();
        private Map<DexString, DexString> reservedNamesBelow = new IdentityHashMap<DexString, DexString>();

        InternalState() {
        }

        DexString getReservedByName(DexString name) {
            DexString reservedBy = this.reservedNamesDirect.get(name);
            return reservedBy != null ? reservedBy : this.reservedNamesBelow.get(name);
        }

        void markReservedDirectly(DexString name, DexString originalName) {
            this.reservedNamesDirect.put(name, originalName);
        }

        void includeReservations(InternalState state) {
            this.reservedNamesDirect.putAll(state.reservedNamesDirect);
        }

        void includeReservationsFromBelow(InternalState state) {
            this.reservedNamesBelow.putAll(state.reservedNamesDirect);
            this.reservedNamesBelow.putAll(state.reservedNamesBelow);
        }
    }
}

