/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.naming.ClassNamingForNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.references.ClassReference;
import shadow.bundletool.com.android.tools.r8.references.Reference;
import shadow.bundletool.com.android.tools.r8.retrace.Result;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceBase;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceFieldResult;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceMethodResult;
import shadow.bundletool.com.android.tools.r8.utils.Box;

@Keep
public class RetraceClassResult
extends Result<Element, RetraceClassResult> {
    private final ClassReference obfuscatedReference;
    private final ClassNamingForNameMapper mapper;

    private RetraceClassResult(ClassReference obfuscatedReference, ClassNamingForNameMapper mapper) {
        this.obfuscatedReference = obfuscatedReference;
        this.mapper = mapper;
    }

    static RetraceClassResult create(ClassReference obfuscatedReference, ClassNamingForNameMapper mapper) {
        return new RetraceClassResult(obfuscatedReference, mapper);
    }

    public RetraceFieldResult lookupField(String fieldName) {
        return this.lookup(fieldName, (mapper, name) -> {
            List<MemberNaming> memberNamings = mapper.mappedNamingsByName.get(name);
            if (memberNamings == null || memberNamings.isEmpty()) {
                return null;
            }
            return memberNamings;
        }, RetraceFieldResult::new);
    }

    public RetraceMethodResult lookupMethod(String methodName) {
        return this.lookup(methodName, (mapper, name) -> {
            ClassNamingForNameMapper.MappedRangesOfName mappedRanges = mapper.mappedRangesByRenamedName.get(name);
            if (mappedRanges == null || mappedRanges.getMappedRanges().isEmpty()) {
                return null;
            }
            return mappedRanges;
        }, RetraceMethodResult::new);
    }

    private <T, R> R lookup(String name, BiFunction<ClassNamingForNameMapper, String, T> lookupFunction, ResultConstructor<T, R> constructor) {
        Box elementBox = new Box();
        this.forEach(element -> {
            assert (!elementBox.isSet());
            Object mappedRangesForT = null;
            if (((Element)element).mapper != null) {
                mappedRangesForT = lookupFunction.apply(((Element)element).mapper, name);
            }
            elementBox.set(constructor.create((Element)element, mappedRangesForT, name));
        });
        return (R)elementBox.get();
    }

    private boolean hasRetraceResult() {
        return this.mapper != null;
    }

    @Override
    public Stream<Element> stream() {
        return Stream.of(new Element(this, this.mapper == null ? this.obfuscatedReference : Reference.classFromTypeName(this.mapper.originalName), this.mapper));
    }

    @Override
    public RetraceClassResult forEach(Consumer<Element> resultConsumer) {
        this.stream().forEach(resultConsumer);
        return this;
    }

    public static class Element {
        private final RetraceClassResult classResult;
        private final ClassReference classReference;
        private final ClassNamingForNameMapper mapper;

        public Element(RetraceClassResult classResult, ClassReference classReference, ClassNamingForNameMapper mapper) {
            this.classResult = classResult;
            this.classReference = classReference;
            this.mapper = mapper;
        }

        public ClassReference getClassReference() {
            return this.classReference;
        }

        public RetraceClassResult getRetraceClassResult() {
            return this.classResult;
        }

        public String retraceSourceFile(String fileName, RetraceBase retraceBase) {
            return retraceBase.retraceSourceFile(this.classResult.obfuscatedReference, fileName, this.classReference, this.mapper != null);
        }

        public RetraceFieldResult lookupField(String fieldName) {
            return this.lookup(fieldName, (mapper, name) -> {
                List<MemberNaming> memberNamings = mapper.mappedNamingsByName.get(name);
                if (memberNamings == null || memberNamings.isEmpty()) {
                    return null;
                }
                return memberNamings;
            }, RetraceFieldResult::new);
        }

        public RetraceMethodResult lookupMethod(String methodName) {
            return this.lookup(methodName, (mapper, name) -> {
                ClassNamingForNameMapper.MappedRangesOfName mappedRanges = mapper.mappedRangesByRenamedName.get(name);
                if (mappedRanges == null || mappedRanges.getMappedRanges().isEmpty()) {
                    return null;
                }
                return mappedRanges;
            }, RetraceMethodResult::new);
        }

        private <T, R> R lookup(String name, BiFunction<ClassNamingForNameMapper, String, T> lookupFunction, ResultConstructor<T, R> constructor) {
            return constructor.create(this, this.mapper != null ? (Object)lookupFunction.apply(this.mapper, name) : null, name);
        }
    }

    private static interface ResultConstructor<T, R> {
        public R create(Element var1, T var2, String var3);
    }
}

